/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKEDDSAPrivateKey;
import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKPrivateKey;
import com.dyadicsec.provider.DYKey;
import com.dyadicsec.provider.EDDSAPublicKey;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;

public class EDDSAPrivateKey
extends DYKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    KeyParameters keyParams = null;
    private EDDSAPublicKey genPublicKey = null;
    CKEDDSAPrivateKey pkcs11Key = null;

    @Override
    protected CKPrivateKey getPkcs11Key() {
        return this.pkcs11Key;
    }

    EDDSAPrivateKey() {
    }

    EDDSAPrivateKey(CKEDDSAPrivateKey pkcs11Key) {
        this.pkcs11Key = pkcs11Key;
    }

    EDDSAPrivateKey initForGenerate(KeyParameters keyParams, EDDSAPublicKey genPublicKey) {
        this.keyParams = keyParams;
        this.genPublicKey = genPublicKey;
        genPublicKey.prvKey = this;
        return this;
    }

    @Override
    protected void generate(KeyStore store, String alias) throws KeyStoreException {
        try {
            this.pkcs11Key = CKEDDSAPrivateKey.generate(store.slot, alias, KeyParameters.toPolicy(this.keyParams));
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
        if (this.genPublicKey != null) {
            try {
                this.genPublicKey.pkcs11Key = this.pkcs11Key.getPublicKey();
            }
            catch (Throwable e) {
                throw new KeyStoreException(e);
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return "EDDSA";
    }
}

