/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.Policy;

public class KeyParameters {
    public static final int EXPORT_NONE = 3;
    public static final int EXPORT_WRAP_WITH_TRUSTED = 2;
    public static final int EXPORT_WRAP = 1;
    public static final int EXPORT_PLAIN = 0;
    int exportLevelMode = -1;
    int signMode = -1;
    int verifyMode = -1;
    int encryptMode = -1;
    int decryptMode = -1;
    int wrapMode = -1;
    int unwrapMode = -1;
    int deriveMode = -1;
    int trustedMode = -1;
    int hwMode = -1;
    private boolean allowEncrypt = true;
    private boolean allowDecrypt = true;
    private boolean allowSign = true;
    private boolean allowVerify = true;
    private boolean allowDerive = true;
    private boolean extractable = false;
    private boolean sensitive = true;
    private boolean trusted = false;
    private boolean token = true;

    public boolean isSetSign() {
        return this.signMode >= 0;
    }

    public boolean isSetVerify() {
        return this.verifyMode >= 0;
    }

    public boolean isSetEncrypt() {
        return this.encryptMode >= 0;
    }

    public boolean isSetDecrypt() {
        return this.decryptMode >= 0;
    }

    public boolean isSetWrap() {
        return this.wrapMode >= 0;
    }

    public boolean isSetUnwrap() {
        return this.unwrapMode >= 0;
    }

    public boolean isSetDerive() {
        return this.deriveMode >= 0;
    }

    public boolean isSetTrusted() {
        return this.trustedMode >= 0;
    }

    public boolean isSetToken() {
        return this.hwMode >= 0;
    }

    public boolean isSetExportProtection() {
        return this.exportLevelMode >= 0;
    }

    public void setToken(boolean v) {
        this.token = v;
        this.hwMode = v ? 1 : 0;
    }

    public void setAllowEncrypt(boolean v) {
        this.allowEncrypt = v;
        this.encryptMode = v ? 1 : 0;
    }

    public void setAllowDecrypt(boolean v) {
        this.allowDecrypt = v;
        this.decryptMode = v ? 1 : 0;
    }

    public void setAllowSign(boolean v) {
        this.allowSign = v;
        this.signMode = v ? 1 : 0;
    }

    public void setAllowVerify(boolean v) {
        this.allowVerify = v;
        this.verifyMode = v ? 1 : 0;
    }

    public void setAllowDerive(boolean v) {
        this.allowDerive = v;
        this.deriveMode = v ? 1 : 0;
    }

    public void setTrusted(boolean v) {
        this.trusted = v;
        this.trustedMode = v ? 1 : 0;
    }

    public void setWrap(boolean v) {
        this.wrapMode = v ? 1 : 0;
    }

    public void setUnwrap(boolean v) {
        this.unwrapMode = v ? 1 : 0;
    }

    public void setExportProtection(int exportLevel) {
        if (exportLevel < 0 || exportLevel > 3) {
            throw new IllegalArgumentException("Invalid export level");
        }
        this.exportLevelMode = exportLevel;
    }

    public int getExportProtection() {
        return this.exportLevelMode < 0 ? 3 : this.exportLevelMode;
    }

    public void setExtractable(boolean v) {
        this.extractable = v;
    }

    public void setSensitive(boolean v) {
        this.sensitive = v;
    }

    public boolean isAllowEncrypt() {
        return this.allowEncrypt;
    }

    public boolean isAllowDecrypt() {
        return this.allowDecrypt;
    }

    public boolean isAllowSign() {
        return this.allowSign;
    }

    public boolean isAllowVerify() {
        return this.allowVerify;
    }

    public boolean isAllowDerive() {
        return this.allowDerive;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean isExtractable() {
        return this.extractable;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean isAllowWrap() {
        return this.wrapMode != 0;
    }

    public boolean isAllowUnwrap() {
        return this.unwrapMode != 0;
    }

    static Policy toPolicy(KeyParameters params) {
        if (params == null) {
            return null;
        }
        Policy policy = new Policy();
        policy.setToken(params == null || params.token);
        policy.setEncrypt(params == null || params.allowEncrypt);
        policy.setDecrypt(params == null || params.allowDecrypt);
        policy.setSign(params == null || params.allowSign);
        policy.setVerify(params == null || params.allowVerify);
        policy.setDerive(params == null || params.allowDerive);
        policy.setExtractable(params != null && params.extractable);
        policy.setSensitive(params == null || params.sensitive);
        policy.setTrusted(params != null && params.trusted);
        return policy;
    }
}

