/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKCertificate;
import com.dyadicsec.pkcs11.CKECPrivateKey;
import com.dyadicsec.pkcs11.CKEDDSAPrivateKey;
import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKKey;
import com.dyadicsec.pkcs11.CKLIMAPrivateKey;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CKRSAPrivateKey;
import com.dyadicsec.pkcs11.CKSecretKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.provider.DYCryptoProvider;
import com.dyadicsec.provider.DYKey;
import com.dyadicsec.provider.ECPrivateKey;
import com.dyadicsec.provider.EDDSAPrivateKey;
import com.dyadicsec.provider.LIMAPrivateKey;
import com.dyadicsec.provider.RSAPrivateKey;
import com.dyadicsec.provider.RSAPublicKey;
import com.dyadicsec.provider.SecretKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.crypto.spec.SecretKeySpec;

public final class KeyStore
extends KeyStoreSpi {
    Slot slot = null;
    private boolean loggedInSO = false;
    private Hashtable<String, Entry> map = new Hashtable();

    private synchronized void removeMapAlias(String alias) {
        this.map.remove(alias);
    }

    public KeyStore(Slot slot) {
        this.slot = slot;
    }

    public Slot getSlot() {
        return this.slot;
    }

    void register(Key key, String alias) {
    }

    synchronized void setAlias(Key key, String alias) throws KeyStoreException {
        if (alias == null) {
            return;
        }
        if (key == null) {
            return;
        }
        try {
            CKKey pkcs11Key = this.getPkcs11Key(key);
            if (pkcs11Key == null) {
                return;
            }
            String old = pkcs11Key.getName();
            if (alias.equals(old)) {
                return;
            }
            pkcs11Key.setName(alias);
            this.removeMapAlias(old);
            this.removeMapAlias(alias);
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
    }

    private synchronized Entry findKeyEntry(String alias) {
        Entry entry = this.map.get(alias);
        if (entry != null) {
            if (entry.key != null) {
                return entry;
            }
            return null;
        }
        entry = this.findPrivateKeyEntry(alias);
        if (entry != null) {
            return entry;
        }
        return this.findSecretKeyEntry(alias);
    }

    private synchronized Entry findAnyEntry(String alias) {
        Entry entry = this.map.get(alias);
        if (entry != null) {
            return entry;
        }
        entry = this.findKeyEntry(alias);
        if (entry != null) {
            return entry;
        }
        return this.findCertEntry(alias);
    }

    private synchronized Entry findSecretKeyEntry(String alias) {
        if (!KeyStore.isPrintableAlias(alias)) {
            return null;
        }
        Entry entry = this.map.get(alias);
        if (entry != null) {
            if (entry.cert != null) {
                return null;
            }
            if (entry.key instanceof SecretKey) {
                return entry;
            }
            return null;
        }
        CKSecretKey pkcs11Key = CKSecretKey.find(this.slot, alias);
        if (pkcs11Key == null) {
            return null;
        }
        entry = new Entry(new SecretKey(pkcs11Key));
        this.map.put(alias, entry);
        return entry;
    }

    private synchronized Entry findPrivateKeyEntry(String alias) {
        long uid;
        DYKey key;
        if (!KeyStore.isPrintableAlias(alias)) {
            return null;
        }
        Entry entry = this.map.get(alias);
        if (entry != null) {
            if (entry.key instanceof PrivateKey) {
                return entry;
            }
            return null;
        }
        CKObject pkcs11Key = this.slot.findObject(3, -1, alias);
        if (pkcs11Key == null) {
            return null;
        }
        if (pkcs11Key instanceof CKRSAPrivateKey) {
            key = new RSAPrivateKey((CKRSAPrivateKey)pkcs11Key);
        } else if (pkcs11Key instanceof CKECPrivateKey) {
            key = new ECPrivateKey((CKECPrivateKey)pkcs11Key);
        } else if (pkcs11Key instanceof CKLIMAPrivateKey) {
            key = new LIMAPrivateKey((CKLIMAPrivateKey)pkcs11Key);
        } else if (pkcs11Key instanceof CKEDDSAPrivateKey) {
            key = new EDDSAPrivateKey((CKEDDSAPrivateKey)pkcs11Key);
        } else {
            return null;
        }
        try {
            uid = pkcs11Key.getUID();
        }
        catch (CKException e) {
            return null;
        }
        entry = new Entry(key);
        entry.cert = CKCertificate.findCertByPrivateKeyUID(this.slot, uid);
        this.map.put(alias, entry);
        return entry;
    }

    private synchronized Entry findCertEntry(String alias) {
        long uid;
        if (!KeyStore.isPrintableAlias(alias)) {
            return null;
        }
        Entry entry = this.map.get(alias);
        if (entry != null) {
            if (entry.key == null) {
                return entry;
            }
            return null;
        }
        CKCertificate cert = CKCertificate.find(this.slot, alias);
        if (cert == null) {
            return null;
        }
        try {
            uid = cert.getPrivateKeyUID();
        }
        catch (CKException e) {
            return null;
        }
        if (0 != this.slot.findObjectHandle(uid)) {
            return null;
        }
        entry = new Entry(null);
        entry.cert = cert;
        this.map.put(alias, entry);
        return entry;
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) {
        Entry entry = this.findAnyEntry(alias);
        if (entry == null) {
            return null;
        }
        if (entry.key == null) {
            return new KeyStore.TrustedCertificateEntry(this.getX509(entry));
        }
        if (entry.key instanceof SecretKey) {
            return new KeyStore.SecretKeyEntry((SecretKey)entry.key);
        }
        if (entry.key instanceof PrivateKey) {
            if (entry.cert == null) {
                return new DYCryptoProvider.KeyEntry((PrivateKey)entry.key);
            }
            return new KeyStore.PrivateKeyEntry((PrivateKey)entry.key, this.getChain(entry));
        }
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws ProviderException {
        try {
            this.login(password);
        }
        catch (KeyStoreException e) {
            throw new ProviderException(e);
        }
        Entry entry = this.findKeyEntry(alias);
        if (entry == null) {
            return null;
        }
        return entry.key;
    }

    private X509Certificate getX509(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.cert == null) {
            return null;
        }
        try {
            return entry.cert.getX509();
        }
        catch (CKException e) {
            return null;
        }
        catch (CertificateException e) {
            return null;
        }
    }

    private X509Certificate[] getChain(Entry entry) {
        CKCertificate object;
        if (entry == null) {
            return null;
        }
        X509Certificate cert = this.getX509(entry);
        if (cert == null) {
            return new X509Certificate[]{null};
        }
        if (cert.getSubjectX500Principal().equals(cert.getIssuerX500Principal())) {
            return new X509Certificate[]{cert};
        }
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        chain.add(cert);
        while ((object = this.slot.findObject(CKCertificate.class, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, true), new CK_ATTRIBUTE(0, 1), new CK_ATTRIBUTE(257, cert.getIssuerX500Principal().getEncoded())})) != null) {
            try {
                cert = object.getX509();
            }
            catch (CKException e) {
                break;
            }
            catch (CertificateException e) {
                break;
            }
            chain.add(cert);
            if (!cert.getSubjectX500Principal().equals(cert.getIssuerX500Principal())) continue;
            break;
        }
        return chain.toArray(new X509Certificate[chain.size()]);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return this.getChain(this.findPrivateKeyEntry(alias));
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        Entry entry = this.findAnyEntry(alias);
        return entry != null;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Entry entry = this.findKeyEntry(alias);
        return entry != null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        Entry entry = this.findCertEntry(alias);
        return entry != null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return this.getX509(this.findAnyEntry(alias));
    }

    @Override
    public int engineSize() {
        return 0;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        byte[] encoded;
        try {
            encoded = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            return null;
        }
        CKCertificate object = this.slot.findObject(CKCertificate.class, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, true), new CK_ATTRIBUTE(0, 1), new CK_ATTRIBUTE(17, encoded)});
        if (object == null) {
            return null;
        }
        try {
            return object.getName();
        }
        catch (CKException e) {
            return null;
        }
    }

    private Key newKey(CKObject object) {
        if (object instanceof CKRSAPrivateKey) {
            return new RSAPrivateKey((CKRSAPrivateKey)object);
        }
        if (object instanceof CKECPrivateKey) {
            return new ECPrivateKey((CKECPrivateKey)object);
        }
        if (object instanceof CKLIMAPrivateKey) {
            return new LIMAPrivateKey((CKLIMAPrivateKey)object);
        }
        if (object instanceof CKEDDSAPrivateKey) {
            return new EDDSAPrivateKey((CKEDDSAPrivateKey)object);
        }
        if (object instanceof CKSecretKey) {
            return new SecretKey((CKSecretKey)object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<String> engineAliases() {
        Hashtable<String, Entry> map = new Hashtable<String, Entry>();
        String alias = null;
        ArrayList<CKObject> prvKeys = this.slot.findObjects(3, -1);
        for (CKObject cKObject : prvKeys) {
            Key key;
            try {
                alias = cKObject.getName();
            }
            catch (CKException e) {
                continue;
            }
            if (alias.isEmpty() || (key = this.newKey(cKObject)) == null) continue;
            map.put(alias, new Entry(key));
        }
        ArrayList<CKObject> secretKeys = this.slot.findObjects(4, -1);
        for (CKObject object : secretKeys) {
            Key key;
            try {
                alias = object.getName();
            }
            catch (CKException e) {
                continue;
            }
            if (alias.isEmpty() || (key = this.newKey(object)) == null) continue;
            map.put(alias, new Entry(key));
        }
        ArrayList<CKObject> arrayList = this.slot.findObjects(1, -1);
        for (CKObject object : arrayList) {
            try {
                alias = object.getName();
            }
            catch (CKException e) {
                continue;
            }
            if (alias.isEmpty()) continue;
            Entry entry = (Entry)map.get(alias);
            if (entry == null) {
                entry = new Entry(null);
                map.put(alias, entry);
            }
            entry.cert = (CKCertificate)object;
        }
        KeyStore keyStore = this;
        synchronized (keyStore) {
            this.map = map;
        }
        return map.keys();
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    private void login(char[] password) throws KeyStoreException {
        boolean so;
        if (password == null || password.length == 0) {
            if (this.loggedInSO) {
                this.slot.logout();
            }
            this.loggedInSO = false;
            return;
        }
        this.loggedInSO = false;
        StringTokenizer stok = new StringTokenizer(new String(password), "\t\n\r\f\" :,{}");
        String[] tokens = new String[stok.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = stok.nextToken();
        }
        boolean bl = so = tokens.length > 2 && tokens[0].equalsIgnoreCase("USERNAME") && tokens[1].equalsIgnoreCase("SO");
        if (!so && !this.slot.isUserLoginRequired()) {
            return;
        }
        int rv = 0;
        if (so) {
            this.slot.logout();
            rv = this.slot.login(0, password);
        } else {
            rv = this.slot.login(-2147454975, password);
        }
        if (rv != 0) {
            throw new KeyStoreException("Login failed");
        }
        this.loggedInSO = so;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws ProviderException {
        try {
            this.login(password);
        }
        catch (KeyStoreException e) {
            throw new ProviderException(e);
        }
    }

    private CKKey getPkcs11Key(Key key) throws KeyStoreException {
        if (key == null) {
            return null;
        }
        if (key instanceof DYKey) {
            return ((DYKey)key).getPkcs11Key();
        }
        throw new KeyStoreException("Unsupported key type");
    }

    private void destroyKey(Key key) throws KeyStoreException {
        if (key == null) {
            return;
        }
        try {
            this.getPkcs11Key(key).destroy();
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Entry entry = this.findAnyEntry(alias);
        if (entry == null) {
            return;
        }
        this.removeMapAlias(alias);
        this.destroyKey(entry.key);
        if (entry.cert != null) {
            try {
                entry.cert.destroy();
            }
            catch (CKException e) {
                throw new KeyStoreException(e);
            }
        }
    }

    private CKCertificate createCert(String alias, X509Certificate cert) throws KeyStoreException {
        try {
            return CKCertificate.create(this.slot, alias, null, cert);
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public synchronized void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.setCertificateEntry(alias, cert, null);
    }

    private void createTrustedPublicKeyFromCert(String alias, X509Certificate cer) throws KeyStoreException {
        PublicKey pub = cer.getPublicKey();
        if (!(pub instanceof java.security.interfaces.RSAPublicKey)) {
            return;
        }
        java.security.interfaces.RSAPublicKey rsa = (java.security.interfaces.RSAPublicKey)pub;
        RSAPublicKey key = new RSAPublicKey(rsa);
        key.createTrusted(this, alias);
    }

    private synchronized void setCertificateEntry(String alias, Certificate cert, char[] password) throws KeyStoreException {
        this.login(password);
        Entry entry = this.findCertEntry(alias);
        if (entry != null) {
            this.engineDeleteEntry(alias);
            this.createCert(alias, (X509Certificate)cert);
            return;
        }
        entry = this.findPrivateKeyEntry(alias);
        if (entry != null) {
            if (entry.cert != null) {
                try {
                    entry.cert.destroy();
                }
                catch (CKException cKException) {
                    // empty catch block
                }
                entry.cert = null;
            }
            this.createCert(alias, (X509Certificate)cert);
        } else {
            this.createCert(alias, (X509Certificate)cert);
        }
        if (this.loggedInSO) {
            this.createTrustedPublicKeyFromCert(alias, (X509Certificate)cert);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Not supported");
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        char[] password = null;
        if (protParam != null && protParam instanceof KeyStore.PasswordProtection) {
            password = ((KeyStore.PasswordProtection)protParam).getPassword();
        }
        this.removeMapAlias(alias);
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)entry;
            this.engineSetKeyEntry(alias, keyEntry.getPrivateKey(), password, keyEntry.getCertificateChain());
            return;
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
            this.engineSetKeyEntry(alias, secretKeyEntry.getSecretKey(), password, null);
            return;
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)entry;
            this.setCertificateEntry(alias, certEntry.getTrustedCertificate(), password);
            return;
        }
        if (entry instanceof DYCryptoProvider.KeyEntry) {
            DYCryptoProvider.KeyEntry keyEntry = (DYCryptoProvider.KeyEntry)entry;
            this.engineSetKeyEntry(alias, keyEntry.key, password, null);
            return;
        }
        throw new KeyStoreException(new UnsupportedOperationException("unsupported entry type: " + entry.getClass().getName()));
    }

    private void saveChain(CKKey key, String alias, Certificate[] chain) throws KeyStoreException {
        if (chain == null) {
            return;
        }
        try {
            long uid = key.getUID();
            ArrayList<CKCertificate> list = CKCertificate.findCertsByPrivateKeyUID(this.slot, uid);
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).destroy();
            }
        }
        catch (CKException uid) {
            // empty catch block
        }
        this.createCert(alias, (X509Certificate)chain[0]);
        for (int i = 1; i < chain.length; ++i) {
            try {
                this.createCert(null, (X509Certificate)chain[i]);
                continue;
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (!KeyStore.isPrintableAlias(alias)) {
            throw new KeyStoreException("invalid entry name " + alias);
        }
        this.login(password);
        this.removeMapAlias(alias);
        if (key instanceof DYKey) {
            ((DYKey)key).save(this, alias);
            if (key instanceof RSAPrivateKey || key instanceof ECPrivateKey) {
                this.saveChain(((DYKey)key).getPkcs11Key(), alias, chain);
            }
            return;
        }
        if (key instanceof RSAPrivateCrtKey) {
            this.engineDeleteEntry(alias);
            RSAPrivateKey prvKey = new RSAPrivateKey().initForImport((RSAPrivateCrtKey)key);
            prvKey.save(this, alias);
            this.saveChain(prvKey.pkcs11Key, alias, chain);
            return;
        }
        if (key instanceof java.security.interfaces.ECPrivateKey) {
            this.engineDeleteEntry(alias);
            ECPrivateKey prvKey = new ECPrivateKey().initForImport((java.security.interfaces.ECPrivateKey)key);
            prvKey.save(this, alias);
            this.saveChain(prvKey.pkcs11Key, alias, chain);
            return;
        }
        if (key instanceof SecretKeySpec) {
            this.engineDeleteEntry(alias);
            SecretKey secretKey = new SecretKey().initForImport(null, -1, (SecretKeySpec)key);
            return;
        }
        throw new KeyStoreException("Unsupported key type");
    }

    private static boolean isPrintableAlias(String alias) {
        return alias != null;
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        if (entryClass == KeyStore.TrustedCertificateEntry.class) {
            return this.findCertEntry(alias) != null;
        }
        if (entryClass == KeyStore.PrivateKeyEntry.class) {
            return this.findPrivateKeyEntry(alias) != null;
        }
        if (entryClass == KeyStore.SecretKeyEntry.class) {
            return this.findSecretKeyEntry(alias) != null;
        }
        return false;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (alias == null) {
            return null;
        }
        return new Date();
    }

    private static class Entry {
        Key key = null;
        CKCertificate cert = null;

        Entry(Key key) {
            this.key = key;
        }
    }
}

