/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.provider.LIMAPrivateKey;
import com.dyadicsec.provider.LIMAPublicKey;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CipherSpi;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class LIMACipher
extends CipherSpi {
    static final int N = 1024;
    static final int SEED_SIZE = 32;
    static final int MAX_MSG_SIZE = 96;
    static final int MAX_ENC_SIZE = LIMACipher.getEncSize(96);
    private int mode = 1;
    private byte[] buffer = null;
    private LIMAPrivateKey prvKey = null;
    private LIMAPublicKey pubKey = null;

    private static byte[] combine(byte[] a, byte[] b) {
        if (a == null) {
            return b;
        }
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    @Override
    protected void engineSetMode(String mode) {
    }

    @Override
    protected void engineSetPadding(String mode) {
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    static int getEncSize(int inputLen) {
        return ((inputLen + 32) * 8 + 1024) * 3 + 3;
    }

    static int getDecSize(int inputLen) {
        return ((inputLen - 3) / 3 - 1024) / 8 - 32;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        switch (this.mode) {
            case 1: 
            case 3: {
                return LIMACipher.getEncSize(inputLen);
            }
            case 2: 
            case 4: {
                return LIMACipher.getDecSize(inputLen);
            }
        }
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int mode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.mode = mode;
        this.buffer = null;
        switch (mode) {
            case 1: 
            case 3: {
                if (!(key instanceof LIMAPublicKey)) {
                    throw new InvalidKeyException("CKKey type must be CKLIMAPublicKey");
                }
                this.pubKey = (LIMAPublicKey)key;
                break;
            }
            case 2: 
            case 4: {
                if (!(key instanceof LIMAPrivateKey)) {
                    throw new InvalidKeyException("CKKey type must be CKLIMAPrivateKey");
                }
                this.prvKey = (LIMAPrivateKey)key;
            }
        }
    }

    @Override
    protected void engineInit(int mode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(mode, key, null);
    }

    @Override
    protected void engineInit(int mode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(mode, key, null);
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOffset, int inLen) {
        this.engineUpdate(in, inOffset, inLen, null, 0);
        return new byte[0];
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ProviderException {
        this.buffer = LIMACipher.combine(this.buffer, in);
        if (this.mode == 1 && this.buffer.length > 96 || this.mode == 2 && this.buffer.length > MAX_ENC_SIZE) {
            throw new ProviderException("Input is too long");
        }
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOffset, int inLen) throws ProviderException {
        this.engineUpdate(in, inOffset, inLen);
        byte[] out = new byte[this.engineGetOutputSize(this.buffer.length)];
        try {
            this.doFinal(out, 0);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
        return out;
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        this.engineUpdate(in, inOffset, inLen);
        return this.doFinal(out, outOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doFinal(byte[] out, int outOffset) throws ShortBufferException {
        if (outOffset + this.engineGetOutputSize(this.buffer.length) > out.length) {
            throw new ShortBufferException();
        }
        try (Session session = null;){
            switch (this.mode) {
                case 1: {
                    try {
                        this.pubKey.prvKey.save();
                        session = this.pubKey.pkcs11Key.encryptInit(new CK_MECHANISM(-2147451311));
                        session.encrypt(this.buffer, 0, this.buffer.length, out, outOffset);
                        break;
                    }
                    catch (CKException e) {
                        throw new ProviderException(e);
                    }
                    catch (KeyStoreException e) {
                        throw new ProviderException(e);
                    }
                }
                case 2: {
                    try {
                        this.prvKey.save();
                        session = this.prvKey.pkcs11Key.decryptInit(new CK_MECHANISM(-2147451311));
                        session.decrypt(this.buffer, 0, this.buffer.length, out, outOffset);
                        break;
                    }
                    catch (CKException e) {
                        throw new ProviderException(e);
                    }
                    catch (KeyStoreException e) {
                        throw new ProviderException(e);
                    }
                }
            }
            int n = this.engineGetOutputSize(this.buffer.length);
            return n;
        }
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return 128;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, ProviderException {
        byte[] keyBuf = key.getEncoded();
        if (keyBuf == null || keyBuf.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        if (keyBuf.length > 96) {
            throw new InvalidKeyException("CKKey is too long for wrapping");
        }
        byte[] out = new byte[LIMACipher.getEncSize(keyBuf.length)];
        try {
            this.pubKey.prvKey.save();
            Session session = this.pubKey.pkcs11Key.encryptInit(new CK_MECHANISM(-2147451311));
            session.encrypt(keyBuf, 0, keyBuf.length, out, 0);
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
        catch (KeyStoreException e) {
            throw new ProviderException(e);
        }
        return out;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int wrappedKeyType) throws InvalidKeyException, ProviderException {
        if (wrappedKeyType != 3) {
            throw new UnsupportedOperationException("wrappedKeyType == " + wrappedKeyType);
        }
        if (wrappedKey.length > MAX_ENC_SIZE) {
            throw new InvalidKeyException("CKKey is too long for unwrapping");
        }
        byte[] out = new byte[LIMACipher.getDecSize(wrappedKey.length)];
        try {
            this.prvKey.save();
            Session session = this.prvKey.pkcs11Key.decryptInit(new CK_MECHANISM(-2147451311));
            session.decrypt(wrappedKey, 0, wrappedKey.length, out, 0);
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
        catch (KeyStoreException e) {
            throw new ProviderException(e);
        }
        return new SecretKeySpec(out, "AES");
    }
}

