/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.provider.SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.spec.IvParameterSpec;

public class Mac
extends MacSpi {
    private SecretKey secretKey = null;
    private final int mechanism;
    private Session session = null;
    private AlgorithmParameterSpec paramSpec = null;
    private byte[] oneByte = null;

    Mac(int mechanism) {
        this.mechanism = mechanism;
    }

    @Override
    protected int engineGetMacLength() {
        switch (this.mechanism) {
            case 545: {
                return 20;
            }
            case 593: {
                return 32;
            }
            case 609: {
                return 48;
            }
            case 625: {
                return 64;
            }
            case 4234: {
                return 16;
            }
            case 4238: {
                return 16;
            }
        }
        return 0;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec paramSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new InvalidKeyException("Invalid key");
        }
        this.paramSpec = paramSpec;
        if (this.mechanism == 4238) {
            if (paramSpec != null && !(paramSpec instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("IvParameterSpec required");
            }
        } else if (paramSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.secretKey = (SecretKey)key;
        CK_MECHANISM m = null;
        byte[] iv = null;
        int keyType = -1;
        try {
            this.secretKey.save();
            keyType = this.secretKey.getKeyType();
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
        switch (this.mechanism) {
            case 545: 
            case 593: 
            case 609: 
            case 625: {
                if (keyType != 16) {
                    throw new InvalidKeyException("Invalid key type");
                }
                m = new CK_MECHANISM(this.mechanism);
                break;
            }
            case 4234: {
                if (keyType != 31) {
                    throw new InvalidKeyException("Invalid key type");
                }
                m = new CK_MECHANISM(this.mechanism);
                break;
            }
            case 4238: {
                if (keyType != 31) {
                    throw new InvalidKeyException("Invalid key type");
                }
                iv = paramSpec == null ? new byte[12] : ((IvParameterSpec)paramSpec).getIV();
                m = new CK_MECHANISM(this.mechanism, iv);
            }
        }
        try {
            this.session = this.secretKey.pkcs11Key.signInit(m);
        }
        catch (CKException e) {
            this.engineReset();
            if (e.getRV() == 7 || e.getRV() == 112 || e.getRV() == 113) {
                throw new InvalidAlgorithmParameterException(e);
            }
            throw new InvalidKeyException(e);
        }
    }

    @Override
    protected void engineUpdate(byte b) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = b;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    private void ensureInit() {
        if (this.session == null) {
            try {
                this.engineInit(this.secretKey, this.paramSpec);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new ProviderException(e);
            }
            catch (InvalidKeyException e) {
                throw new ProviderException(e);
            }
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int ofs, int len) {
        this.ensureInit();
        try {
            this.session.signUpdate(b, ofs, len);
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        this.ensureInit();
        int outLen = this.engineGetMacLength();
        try {
            byte[] byArray = this.session.signFinal(outLen);
            return byArray;
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected void engineReset() {
        if (this.session != null) {
            this.session.close();
        }
        this.session = null;
    }

    public static final class GMAC
    extends Mac {
        public GMAC() {
            super(4238);
        }
    }

    public static final class CMAC
    extends Mac {
        public CMAC() {
            super(4234);
        }
    }

    public static final class HmacSHA512
    extends Mac {
        public HmacSHA512() {
            super(625);
        }
    }

    public static final class HmacSHA384
    extends Mac {
        public HmacSHA384() {
            super(609);
        }
    }

    public static final class HmacSHA256
    extends Mac {
        public HmacSHA256() {
            super(593);
        }
    }

    public static final class HmacSHA1
    extends Mac {
        public HmacSHA1() {
            super(545);
        }
    }
}

