/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class MessageDigest
extends MessageDigestSpi {
    private java.security.MessageDigest sys;

    MessageDigest(String name) {
        try {
            this.sys = java.security.MessageDigest.getInstance(name, "SUN");
        }
        catch (NoSuchAlgorithmException e) {
            this.sys = null;
        }
        catch (NoSuchProviderException e) {
            this.sys = null;
        }
        if (this.sys == null) {
            try {
                this.sys = java.security.MessageDigest.getInstance(name);
            }
            catch (NoSuchAlgorithmException e) {
                this.sys = null;
            }
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        this.sys.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.sys.update(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        return this.sys.digest();
    }

    @Override
    protected void engineReset() {
        this.sys.reset();
    }

    public static final class SHA512
    extends MessageDigest {
        public SHA512() {
            super("SHA-512");
        }
    }

    public static final class SHA384
    extends MessageDigest {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA256
    extends MessageDigest {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA1
    extends MessageDigest {
        public SHA1() {
            super("SHA-1");
        }
    }
}

