/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKKey;
import com.dyadicsec.pkcs11.CKRSAPublicKey;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.CK_RSA_PKCS_OAEP_PARAMS;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import com.dyadicsec.provider.KeyGenSpec;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.RSAPrivateKey;
import com.dyadicsec.provider.RSAPublicKey;
import com.dyadicsec.provider.SecretKey;
import com.dyadicsec.provider.UnwrapInfo;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;

public final class RSACipher
extends CipherSpi {
    private RSAPrivateKey prvKey = null;
    private RSAPublicKey pubKey = null;
    private int mechanismType = 1;
    private int oaepHashType = 544;
    private int oaepMgfType = 1;
    private byte[] oaepSource = null;
    private static final byte[] B0 = new byte[0];
    private byte[] buffer = null;
    private int bufferOffset = 0;
    private int opmode = 0;
    private SecureRandom secureRandom = null;
    private OAEPParameterSpec oaepSpec = null;
    private Key wrappedKey = null;
    private KeyParameters unwrapKeyParams = null;

    private static int hashNameToType(String hashName) throws InvalidAlgorithmParameterException {
        if ((hashName = hashName.toUpperCase()).equals("SHA1")) {
            return 544;
        }
        if (hashName.equals("SHA-1")) {
            return 544;
        }
        if (hashName.equals("SHA-256")) {
            return 592;
        }
        if (hashName.equals("SHA-384")) {
            return 608;
        }
        if (hashName.equals("SHA-512")) {
            return 624;
        }
        throw new InvalidAlgorithmParameterException("OAEP hash algorithm not supported: " + hashName);
    }

    private static int hashTypeToMgfType(int hashType) throws InvalidAlgorithmParameterException {
        switch (hashType) {
            case 544: {
                return 1;
            }
            case 592: {
                return 2;
            }
            case 608: {
                return 3;
            }
            case 624: {
                return 4;
            }
        }
        throw new InvalidAlgorithmParameterException("OAEP MGF hash algorithm not supported: " + hashType);
    }

    private static String hashTypeToName(int mechanismType) throws InvalidAlgorithmParameterException {
        switch (mechanismType) {
            case 544: {
                return "SHA-1";
            }
            case 592: {
                return "SHA-256";
            }
            case 608: {
                return "SHA-384";
            }
            case 624: {
                return "SHA-512";
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported OAEP hash algorithm: " + mechanismType);
    }

    private static int paddingToMechanismType(String padding) throws NoSuchPaddingException {
        if ((padding = padding.toUpperCase()).equals("NOPADDING")) {
            return 3;
        }
        if (padding.equals("PKCS1PADDING")) {
            return 1;
        }
        if (padding.equals("OAEPPADDING")) {
            return 9;
        }
        if (padding.startsWith("OAEPWITH") && padding.endsWith("ANDMGF1PADDING")) {
            return 9;
        }
        throw new NoSuchPaddingException("Unsupported padding: " + padding);
    }

    private static int oaepPaddingToHashType(String padding) throws NoSuchPaddingException {
        if ((padding = padding.toUpperCase()).equals("OAEPPADDING")) {
            return 544;
        }
        if (padding.startsWith("OAEPWITH") && padding.endsWith("ANDMGF1PADDING")) {
            String hashName = padding.substring(8, padding.length() - 14);
            try {
                return RSACipher.hashNameToType(hashName);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new NoSuchPaddingException("padding not supported: " + padding);
            }
        }
        throw new NoSuchPaddingException("padding not supported: " + padding);
    }

    private static MGF1ParameterSpec mgfTypeToSpec(int mgfType) throws InvalidAlgorithmParameterException {
        switch (mgfType) {
            case 1: {
                return MGF1ParameterSpec.SHA1;
            }
            case 2: {
                return MGF1ParameterSpec.SHA256;
            }
            case 3: {
                return MGF1ParameterSpec.SHA384;
            }
            case 4: {
                return MGF1ParameterSpec.SHA512;
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported OAEP MGF hash algorithm: " + mgfType);
    }

    private static String paddingTypeToName(int mechanismType, int oaepHashType) throws NoSuchPaddingException, InvalidAlgorithmParameterException {
        switch (mechanismType) {
            case 3: {
                return "NOPadding";
            }
            case 1: {
                return "PKCS1Padding";
            }
            case 9: {
                return "OAEPWith" + RSACipher.hashTypeToName(oaepHashType) + "AndMGF1Padding";
            }
        }
        throw new NoSuchPaddingException("padding not supported");
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!(mode = mode.toUpperCase()).equals("NONE") && !mode.equals("ECB")) {
            throw new NoSuchAlgorithmException("Mode not supported: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        this.mechanismType = RSACipher.paddingToMechanismType(padding);
        if (this.mechanismType == 9) {
            this.oaepHashType = RSACipher.oaepPaddingToHashType(padding);
            this.oaepMgfType = 1;
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.buffer == null ? 0 : this.buffer.length;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    private AlgorithmParameterSpec getParameterSpec() throws InvalidAlgorithmParameterException {
        if (this.oaepSpec == null) {
            if (this.mechanismType != 9) {
                return null;
            }
            String oaepHashName = RSACipher.hashTypeToName(this.oaepHashType);
            MGF1ParameterSpec mgfSpec = RSACipher.mgfTypeToSpec(this.oaepMgfType);
            this.oaepSpec = new OAEPParameterSpec(oaepHashName, "MGF1", mgfSpec, PSource.PSpecified.DEFAULT);
        }
        return this.oaepSpec;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        try {
            AlgorithmParameterSpec spec = this.getParameterSpec();
            if (spec == null) {
                return null;
            }
            AlgorithmParameters params = AlgorithmParameters.getInstance("OAEP");
            params.init(spec);
            return params;
        }
        catch (Throwable e) {
            throw new RuntimeException("Invalid algorithm parameters not supported");
        }
    }

    void init(int opmode, Key key, AlgorithmParameterSpec paramSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int bufSize = 0;
        this.opmode = opmode;
        switch (opmode) {
            case 1: 
            case 3: {
                this.prvKey = null;
                if (key instanceof RSAPublicKey) {
                    this.pubKey = (RSAPublicKey)key;
                } else if (key instanceof java.security.interfaces.RSAPublicKey) {
                    this.pubKey = new RSAPublicKey((java.security.interfaces.RSAPublicKey)key);
                } else {
                    throw new InvalidKeyException("Invalid key type");
                }
                if (this.pubKey.prvKey != null) {
                    try {
                        this.pubKey.prvKey.save();
                    }
                    catch (KeyStoreException e) {
                        throw new InvalidKeyException(e);
                    }
                }
                bufSize = this.pubKey.getBitSize() / 8;
                break;
            }
            case 2: 
            case 4: {
                this.pubKey = null;
                if (!(key instanceof RSAPrivateKey)) {
                    throw new InvalidKeyException("Invalid key type");
                }
                this.prvKey = (RSAPrivateKey)key;
                try {
                    this.prvKey.save();
                }
                catch (KeyStoreException e) {
                    throw new InvalidKeyException(e);
                }
                try {
                    bufSize = this.prvKey.getBitSize() / 8;
                    break;
                }
                catch (KeyStoreException e) {
                    throw new InvalidKeyException(e);
                }
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + opmode);
            }
        }
        if (opmode == 4) {
            if (paramSpec instanceof KeyGenSpec) {
                this.unwrapKeyParams = ((KeyGenSpec)paramSpec).params;
                paramSpec = ((KeyGenSpec)paramSpec).original;
            } else if (System.getProperty("ukc.provider.fastUnwrap").equals("1")) {
                this.unwrapKeyParams = new KeyParameters();
                this.unwrapKeyParams.setToken(false);
            }
        }
        if (paramSpec != null) {
            if (this.mechanismType != 9) {
                throw new InvalidAlgorithmParameterException("Wrong padding parameter");
            }
            if (!(paramSpec instanceof OAEPParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Wrong Parameters for OAEP Padding");
            }
            this.oaepSpec = (OAEPParameterSpec)paramSpec;
            this.oaepHashType = RSACipher.hashNameToType(this.oaepSpec.getDigestAlgorithm());
            String mgfAlgName = this.oaepSpec.getMGFAlgorithm();
            if (!mgfAlgName.toUpperCase().equals("MGF1")) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF algorithm: " + mgfAlgName);
            }
            AlgorithmParameterSpec mgfParam = this.oaepSpec.getMGFParameters();
            if (!(mgfParam instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF hash");
            }
            String mgfHashName = ((MGF1ParameterSpec)mgfParam).getDigestAlgorithm();
            int mgfHashType = RSACipher.hashNameToType(mgfHashName);
            this.oaepMgfType = RSACipher.hashTypeToMgfType(mgfHashType);
            PSource s = this.oaepSpec.getPSource();
            if (s.getAlgorithm().equals("PSpecified")) {
                this.oaepSource = ((PSource.PSpecified)s).getValue();
            } else {
                throw new InvalidAlgorithmParameterException("Unsupported pSource " + s.getAlgorithm() + "; PSpecified only");
            }
        }
        this.buffer = new byte[bufSize];
        this.bufferOffset = 0;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.secureRandom = secureRandom;
        try {
            this.init(opmode, key, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("Wrong parameters", e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.secureRandom = secureRandom;
        this.init(opmode, key, algorithmParameterSpec);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.secureRandom = secureRandom;
        OAEPParameterSpec spec = null;
        if (algorithmParameters != null) {
            try {
                spec = algorithmParameters.getParameterSpec(OAEPParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidKeyException("Wrong parameters", e);
            }
        }
        this.init(opmode, key, spec);
    }

    private void update(byte[] in, int inOffset, int inLen) {
        if (inLen == 0 || in == null) {
            return;
        }
        if (this.bufferOffset + inLen <= this.buffer.length) {
            System.arraycopy(in, inOffset, this.buffer, this.bufferOffset, inLen);
        }
        this.bufferOffset += inLen;
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOffset, int inLen) {
        this.update(in, inOffset, inLen);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        this.update(in, inOffset, inLen);
        return 0;
    }

    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchProviderException {
        if (this.pubKey != null) {
            Cipher cipher = Cipher.getInstance("RSA/ECB/" + RSACipher.paddingTypeToName(this.mechanismType, this.oaepHashType), "SunJCE");
            cipher.init(this.opmode, (Key)this.pubKey.getSoftwareKey(), this.getParameterSpec(), this.secureRandom);
            if (this.opmode == 3) {
                return cipher.wrap(this.wrappedKey);
            }
            return cipher.doFinal(this.buffer, 0, this.bufferOffset);
        }
        CK_MECHANISM m = this.mechanismType == 9 ? new CK_RSA_PKCS_OAEP_PARAMS(this.oaepHashType, this.oaepMgfType, this.oaepSource) : new CK_MECHANISM(this.mechanismType);
        try (Session session = null;){
            session = this.prvKey.pkcs11Key.decryptInit(m);
            byte[] out = new byte[this.buffer.length];
            int outLen = session.decrypt(this.buffer, 0, this.bufferOffset, out, 0);
            byte[] byArray = outLen == this.buffer.length ? out : Arrays.copyOf(out, outLen);
            return byArray;
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOffset, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        this.update(in, inOffset, inLen);
        if (this.bufferOffset > this.buffer.length) {
            throw new IllegalBlockSizeException("Input must be under " + this.buffer.length + " bytes");
        }
        try {
            return this.doFinal();
        }
        catch (Exception e) {
            throw new BadPaddingException("engineDoFinal failed");
        }
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] b = this.engineDoFinal(in, inOffset, inLen);
        if (outOffset + b.length > out.length) {
            throw new ShortBufferException("Output buffer is too small");
        }
        System.arraycopy(b, 0, out, outOffset, b.length);
        return b.length;
    }

    private long getPubKeyUID() throws InvalidKeyException {
        MessageDigest sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256", "SUN");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException(e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidKeyException(e);
        }
        BigInteger N = this.pubKey.getModulus();
        int keyByteSize = Utils.bigIntByteSize(N);
        byte[] uid = Arrays.copyOf(sha256.digest(Utils.bigInt2Bytes(N, keyByteSize)), 8);
        return Utils.bytesToUID(uid) ^ 0xF0F0F0F0F0F0F0FL;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        if (this.pubKey != null && key instanceof SecretKey && this.mechanismType == 9) {
            try {
                ((SecretKey)key).save();
            }
            catch (KeyStoreException e) {
                throw new InvalidKeyException(e);
            }
            long pubKeyUID = this.getPubKeyUID();
            Slot slot = ((SecretKey)key).pkcs11Key.getSlot();
            CKRSAPublicKey pkcs11Key = slot.findObject(CKRSAPublicKey.class, pubKeyUID);
            if (pkcs11Key == null) {
                throw new InvalidKeyException("Public key not found");
            }
            CK_RSA_PKCS_OAEP_PARAMS m = new CK_RSA_PKCS_OAEP_PARAMS(this.oaepHashType, this.oaepMgfType, this.oaepSource);
            try {
                return pkcs11Key.wrap(m, (CKKey)((SecretKey)key).pkcs11Key);
            }
            catch (CKException e) {
                throw new InvalidKeyException(e);
            }
        }
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        if (encoded.length > this.buffer.length) {
            throw new InvalidKeyException("CKKey is too long for wrapping");
        }
        this.wrappedKey = key;
        try {
            return this.doFinal();
        }
        catch (Exception e) {
            throw new InvalidKeyException("Wrapping failed", e);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (wrappedKeyType != 3) {
            throw new UnsupportedOperationException("wrappedKeyType == " + wrappedKeyType);
        }
        if (wrappedKey.length > this.buffer.length) {
            throw new InvalidKeyException("CKKey is too long for unwrapping");
        }
        CK_MECHANISM m = null;
        m = this.mechanismType == 9 ? new CK_RSA_PKCS_OAEP_PARAMS(this.oaepHashType, this.oaepMgfType, this.oaepSource) : new CK_MECHANISM(this.mechanismType);
        boolean decrypt = false;
        if (this.unwrapKeyParams == null) {
            try {
                decrypt = this.prvKey.pkcs11Key.getPolicy().getDecrypt();
            }
            catch (CKException cKException) {
                // empty catch block
            }
        }
        int keyType = SecretKey.algToKeyType(algorithm);
        if (decrypt) {
            try {
                byte[] unwrappedData = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
                return new SecretKeySpec(unwrappedData, algorithm);
            }
            catch (IllegalBlockSizeException e) {
                throw new InvalidKeyException(e);
            }
            catch (BadPaddingException e) {
                throw new InvalidKeyException(e);
            }
        }
        UnwrapInfo unwrapInfo = new UnwrapInfo(m, this.prvKey.pkcs11Key, wrappedKey);
        return new SecretKey().initForUnwrap(unwrapInfo, keyType, this.unwrapKeyParams);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return Utils.bigIntByteSize(((RSAKey)((Object)key)).getModulus()) * 8;
    }
}

