/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.provider.KeyFactorySpec;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.RSAPrivateKey;
import com.dyadicsec.provider.RSAPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAKeyFactory
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        KeyParameters keyParams = null;
        KeyFactorySpec keyFactorySpec = null;
        if (keySpec instanceof KeyFactorySpec) {
            keyFactorySpec = (KeyFactorySpec)keySpec;
            keySpec = keyFactorySpec.original;
            keyParams = keyFactorySpec.params;
        }
        if (keySpec instanceof RSAPublicKeySpec || keySpec instanceof X509EncodedKeySpec) {
            try {
                return new RSAPublicKey(keySpec, keyParams);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeySpecException(e);
            }
            catch (NoSuchProviderException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        throw new InvalidKeySpecException("Must use RSAPublicKeySpec or X509EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        KeyParameters keyParams = null;
        KeyFactorySpec keyFactorySpec = null;
        if (keySpec instanceof KeyFactorySpec) {
            keyFactorySpec = (KeyFactorySpec)keySpec;
            keySpec = keyFactorySpec.original;
            keyParams = keyFactorySpec.params;
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec || keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return new RSAPrivateKey().initForImport(keyParams, keySpec);
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e);
            }
        }
        throw new InvalidKeySpecException("Must use RSAPrivateCrtKeySpec or PKCS8EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (key == null || keySpec == null) {
            throw new InvalidKeySpecException("key and keySpec must not be null");
        }
        if (key instanceof RSAPublicKey && X509EncodedKeySpec.class.isAssignableFrom(keySpec)) {
            try {
                return KeyFactory.getInstance("RSA", "SunRsaSign").getKeySpec(key, keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeySpecException("Could not encode key", e);
            }
            catch (NoSuchProviderException e) {
                throw new InvalidKeySpecException("Could not encode key", e);
            }
        }
        if (key instanceof RSAPublicKey && RSAPublicKeySpec.class.isAssignableFrom(keySpec)) {
            return (T)new RSAPublicKeySpec(((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent());
        }
        throw new InvalidKeySpecException("Could not encode key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("CKKey must not be null");
        }
        if (key instanceof RSAPrivateKey) {
            return key;
        }
        if (key instanceof RSAPublicKey) {
            return key;
        }
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            return new RSAPublicKey((java.security.interfaces.RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            try {
                return new RSAPrivateKey().initForImport((RSAPrivateCrtKey)key);
            }
            catch (Exception e) {
                throw new InvalidKeyException(e);
            }
        }
        throw new InvalidKeyException("CKKey must be instance of CKPublicKey or CKPrivateKey");
    }
}

