/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.CK_RSA_PKCS_PSS_PARAMS;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.provider.RSAPrivateKey;
import com.dyadicsec.provider.RSAPublicKey;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public class RSASignature
extends SignatureSpi {
    private int mechanismType;
    private RSAPrivateKey prvKey = null;
    private Signature pubSignature = null;
    private Session session = null;
    private ByteArrayOutputStream buffer = null;
    private PSSParameterSpec pss = null;
    private int pssSalt = 20;
    private int pssHash = 544;
    private int pssMgf = 1;

    static String getSunProvider(int mechanismType) throws InvalidAlgorithmParameterException {
        switch (mechanismType) {
            case 1: {
                return "SunJCE";
            }
            case 6: {
                return "SunRsaSign";
            }
            case 64: {
                return "SunRsaSign";
            }
            case 65: {
                return "SunRsaSign";
            }
            case 66: {
                return "SunRsaSign";
            }
            case 13: {
                return "SunRsaSign";
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported hash algorithm: " + mechanismType);
    }

    static String mechanismTypeToHashName(int mechanismType) throws InvalidAlgorithmParameterException {
        switch (mechanismType) {
            case 1: {
                return "NONE";
            }
            case 6: {
                return "SHA1";
            }
            case 64: {
                return "SHA256";
            }
            case 65: {
                return "SHA384";
            }
            case 66: {
                return "SHA512";
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported hash algorithm: " + mechanismType);
    }

    private static int hashNameToType(String hashName) throws InvalidAlgorithmParameterException {
        if ((hashName = hashName.toUpperCase()).equals("SHA1")) {
            return 544;
        }
        if (hashName.equals("SHA-1")) {
            return 544;
        }
        if (hashName.equals("SHA-256")) {
            return 592;
        }
        if (hashName.equals("SHA-384")) {
            return 608;
        }
        if (hashName.equals("SHA-512")) {
            return 624;
        }
        throw new InvalidAlgorithmParameterException("OAEP hash algorithm not supported: " + hashName);
    }

    private static int hashTypeToPssMechType(int hashType) {
        switch (hashType) {
            case 544: {
                return 14;
            }
            case 592: {
                return 67;
            }
            case 608: {
                return 68;
            }
            case 624: {
                return 69;
            }
        }
        return 0;
    }

    private static int hashTypeToMgfType(int hashType) throws InvalidAlgorithmParameterException {
        switch (hashType) {
            case 544: {
                return 1;
            }
            case 592: {
                return 2;
            }
            case 608: {
                return 3;
            }
            case 624: {
                return 4;
            }
        }
        throw new InvalidAlgorithmParameterException("OAEP MGF hash algorithm not supported: " + hashType);
    }

    RSASignature(int mechanismType) {
        this.mechanismType = mechanismType;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof RSAPublicKey) {
            publicKey = ((RSAPublicKey)publicKey).getSoftwareKey();
        } else if (!(publicKey instanceof java.security.interfaces.RSAPublicKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        try {
            Object name = this.mechanismType == 13 ? "RSASSA-PSS" : RSASignature.mechanismTypeToHashName(this.mechanismType) + "WithRSA";
            String sunProviderName = RSASignature.getSunProvider(this.mechanismType);
            Provider sunProvider = Security.getProvider(sunProviderName);
            this.pubSignature = Signature.getInstance((String)name, sunProviderName);
            if (this.mechanismType == 13) {
                if (this.pss == null) {
                    this.pss = new PSSParameterSpec("SHA-1", "MGF1", null, 20, 1);
                }
                this.pubSignature.setParameter(this.pss);
            }
        }
        catch (Throwable e) {
            throw new InvalidKeyException("engineInitVerify failed");
        }
        this.pubSignature.initVerify(publicKey);
    }

    private void checkInit() {
        if (this.session != null) {
            return;
        }
        try {
            CK_MECHANISM mech;
            if (this.mechanismType == 13) {
                int pssMechType = RSASignature.hashTypeToPssMechType(this.pssHash);
                CK_RSA_PKCS_PSS_PARAMS pssParams = new CK_RSA_PKCS_PSS_PARAMS(pssMechType, this.pssHash, this.pssMgf, this.pssSalt);
                mech = pssParams;
            } else {
                mech = new CK_MECHANISM(this.mechanismType);
            }
            this.session = this.prvKey.pkcs11Key.signInit(mech);
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
        if (this.mechanismType == 1) {
            if (this.buffer == null) {
                this.buffer = new ByteArrayOutputStream();
            }
            this.buffer.reset();
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.prvKey = (RSAPrivateKey)privateKey;
        try {
            this.prvKey.save();
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
        this.closeSession();
        this.checkInit();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(b);
            return;
        }
        byte[] in = new byte[]{b};
        this.engineUpdate(in, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int inOffset, int inLen) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(in, inOffset, inLen);
            return;
        }
        this.checkInit();
        if (this.mechanismType == 1) {
            this.buffer.write(in, inOffset, inLen);
        } else {
            try {
                this.session.signUpdate(in, inOffset, inLen);
            }
            catch (CKException e) {
                throw new SignatureException(e);
            }
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.checkInit();
        try {
            int size = this.prvKey.pkcs11Key.getBitSize();
            byte[] result = this.mechanismType == 1 ? this.session.sign(this.buffer.toByteArray(), size) : this.session.signFinal(size);
            byte[] byArray = result;
            return byArray;
        }
        catch (CKException e) {
            throw new SignatureException(e);
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.pubSignature.verify(sigBytes);
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            return;
        }
        if (!(params instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameters must be type PSSParameterSpec");
        }
        if (this.mechanismType != 13) {
            throw new InvalidAlgorithmParameterException("No parameters accepted");
        }
        PSSParameterSpec pss = (PSSParameterSpec)params;
        if (!pss.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
            throw new InvalidAlgorithmParameterException("Only supports MGF1");
        }
        if (pss.getTrailerField() != 1) {
            throw new InvalidAlgorithmParameterException("Only supports TrailerFieldBC(1)");
        }
        this.pssSalt = pss.getSaltLength();
        int hash = this.pssHash = RSASignature.hashNameToType(pss.getDigestAlgorithm());
        AlgorithmParameterSpec mgfParams = pss.getMGFParameters();
        if (mgfParams != null) {
            hash = RSASignature.hashNameToType(((MGF1ParameterSpec)mgfParams).getDigestAlgorithm());
        }
        this.pssMgf = RSASignature.hashTypeToMgfType(hash);
        this.pss = pss;
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.pss == null) {
            throw new ProviderException("Missing required PSS parameters");
        }
        try {
            AlgorithmParameters ap = AlgorithmParameters.getInstance("RSASSA-PSS");
            ap.init(this.pss);
            return ap;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.close();
        }
        this.session = null;
    }

    public static final class PSS
    extends RSASignature {
        public PSS() {
            super(13);
        }
    }

    public static final class SHA512withRSA
    extends RSASignature {
        public SHA512withRSA() {
            super(66);
        }
    }

    public static final class SHA384withRSA
    extends RSASignature {
        public SHA384withRSA() {
            super(65);
        }
    }

    public static final class SHA256withRSA
    extends RSASignature {
        public SHA256withRSA() {
            super(64);
        }
    }

    public static final class SHA1withRSA
    extends RSASignature {
        public SHA1withRSA() {
            super(6);
        }
    }

    public static final class NONEwithRSA
    extends RSASignature {
        public NONEwithRSA() {
            super(1);
        }
    }
}

