/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKSecretKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.provider.DYKey;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.KeyStore;
import com.dyadicsec.provider.UnwrapInfo;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import javax.crypto.spec.SecretKeySpec;

public class SecretKey
extends DYKey
implements javax.crypto.SecretKey {
    private static final long serialVersionUID = 1L;
    CKSecretKey pkcs11Key = null;
    int bitSize = 0;
    private int keyType = -1;
    private javax.crypto.SecretKey sw = null;
    private KeyParameters keyParams = null;
    private UnwrapInfo unwrapInfo = null;

    SecretKey() {
    }

    SecretKey(CKSecretKey pkcs11Key) {
        this.pkcs11Key = pkcs11Key;
    }

    @Override
    protected CKSecretKey getPkcs11Key() {
        return this.pkcs11Key;
    }

    @Override
    protected boolean swKeyPresent() {
        return this.sw != null;
    }

    @Override
    protected boolean unwrapInfoPresent() {
        return this.unwrapInfo != null;
    }

    @Override
    protected void unwrap(String alias) throws KeyStoreException {
        CK_ATTRIBUTE[] t = CKSecretKey.getUnwrapTemplate(alias, KeyParameters.toPolicy(this.keyParams), this.keyType);
        this.pkcs11Key = this.unwrapInfo.unwrap(CKSecretKey.class, t);
        this.unwrapInfo = null;
    }

    @Override
    protected void create(KeyStore store, String alias) throws KeyStoreException {
        try {
            this.pkcs11Key = CKSecretKey.create(store.slot, alias, KeyParameters.toPolicy(this.keyParams), this.keyType, this.sw.getEncoded());
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    protected void generate(KeyStore store, String alias) throws KeyStoreException {
        try {
            this.pkcs11Key = CKSecretKey.generate(store.slot, alias, KeyParameters.toPolicy(this.keyParams), this.keyType, this.bitSize);
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
    }

    SecretKey initForUnwrap(UnwrapInfo unwrapInfo, int keyType, KeyParameters keyParams) {
        this.keyParams = keyParams;
        this.unwrapInfo = unwrapInfo;
        this.keyType = keyType;
        return this;
    }

    SecretKey initForImport(KeyParameters keyParams, int keyType, SecretKeySpec keySpec) throws KeyStoreException {
        String alg = keySpec.getAlgorithm();
        int algKeyType = -1;
        if (alg.equals("AES")) {
            algKeyType = 31;
        } else if (alg.equals("DESede")) {
            algKeyType = 21;
        } else if (alg.equals("Hmac")) {
            algKeyType = 16;
        }
        if (keyType == -1) {
            keyType = algKeyType;
        } else if (algKeyType == -1) {
            throw new KeyStoreException("Unsupported key type");
        }
        this.sw = keySpec;
        this.keyType = keyType;
        this.keyParams = keyParams;
        this.bitSize = keySpec.getEncoded().length * 8;
        return this;
    }

    SecretKey initForGenerate(KeyParameters keyParams, int keyType, int genBitSize) {
        this.keyParams = keyParams;
        this.bitSize = genBitSize;
        this.keyType = keyType;
        return this;
    }

    int getBitSize() throws KeyStoreException {
        if (this.bitSize == 0) {
            try {
                this.bitSize = this.pkcs11Key.getBitSize();
            }
            catch (CKException e) {
                throw new KeyStoreException(e);
            }
        }
        return this.bitSize;
    }

    int getKeyType() throws KeyStoreException {
        if (this.keyType == -1) {
            try {
                this.keyType = this.pkcs11Key.getKeyType();
            }
            catch (CKException e) {
                throw new KeyStoreException(e);
            }
        }
        return this.keyType;
    }

    @Override
    public String getAlgorithm() {
        switch (this.keyType) {
            case 31: {
                return "AES";
            }
            case 21: {
                return "DESede";
            }
            case 16: {
                return "Hmac";
            }
            case -2147454715: {
                return "AESXTS";
            }
            case -2147454716: {
                return "AESSIV";
            }
        }
        return "Unknown";
    }

    @Override
    public String getFormat() {
        if (this.sw != null) {
            return this.sw.getFormat();
        }
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        if (this.sw != null) {
            return this.sw.getEncoded();
        }
        if (this.pkcs11Key != null) {
            try {
                return this.pkcs11Key.getValue();
            }
            catch (CKException e) {
                throw new ProviderException(e);
            }
        }
        return null;
    }

    static int algToKeyType(String alg) throws NoSuchAlgorithmException {
        if (alg.equalsIgnoreCase("AES")) {
            return 31;
        }
        if (alg.equalsIgnoreCase("DESede")) {
            return 21;
        }
        if (alg.equalsIgnoreCase("Hmac")) {
            return 16;
        }
        if (alg.equalsIgnoreCase("AESXTS")) {
            return -2147454715;
        }
        if (alg.equalsIgnoreCase("AESSIV")) {
            return -2147454716;
        }
        throw new NoSuchAlgorithmException("Unsupported algorithm " + alg);
    }
}

