/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.provider.KeyFactorySpec;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.SecretKey;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public class SecretKeyFactory
extends SecretKeyFactorySpi {
    private final int keyType;

    SecretKeyFactory(int keyType) {
        this.keyType = keyType;
    }

    @Override
    protected javax.crypto.SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        KeyParameters keyParams = null;
        KeyFactorySpec keyFactorySpec = null;
        if (keySpec instanceof KeyFactorySpec) {
            keyFactorySpec = (KeyFactorySpec)keySpec;
            keySpec = keyFactorySpec.original;
            keyParams = keyFactorySpec.params;
        }
        if (keySpec instanceof SecretKeySpec) {
            try {
                return new SecretKey().initForImport(keyParams, this.keyType, (SecretKeySpec)keySpec);
            }
            catch (KeyStoreException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        throw new InvalidKeySpecException("Must use SecretKeySpec or KeyFactorySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected KeySpec engineGetKeySpec(javax.crypto.SecretKey secretKey, Class<?> keySpec) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Could not encode key");
    }

    @Override
    protected javax.crypto.SecretKey engineTranslateKey(javax.crypto.SecretKey secretKey) throws InvalidKeyException {
        if (secretKey == null) {
            throw new InvalidKeyException("CKKey must not be null");
        }
        if (secretKey instanceof SecretKey) {
            return secretKey;
        }
        if (secretKey instanceof SecretKeySpec) {
            try {
                return new SecretKey().initForImport(null, this.keyType, (SecretKeySpec)secretKey);
            }
            catch (KeyStoreException e) {
                throw new InvalidKeyException(e);
            }
        }
        throw new InvalidKeyException("CKKey must be instance of CKSecretKey or SecretKeySpec");
    }

    public static final class Hmac
    extends SecretKeyFactory {
        public Hmac() {
            super(16);
        }
    }

    public static final class DES3
    extends SecretKeyFactory {
        public DES3() {
            super(21);
        }
    }

    public static final class AESSIV
    extends SecretKeyFactory {
        public AESSIV() {
            super(-2147454716);
        }
    }

    public static final class AESXTS
    extends SecretKeyFactory {
        public AESXTS() {
            super(-2147454715);
        }
    }

    public static final class AES
    extends SecretKeyFactory {
        public AES() {
            super(31);
        }
    }
}

