/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common;

public final class Base64 {
    private static final char[] alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public static String encode(byte[] in, boolean pem) {
        return Base64.encode(in, 0, in.length, pem);
    }

    public static String encode(byte[] in) {
        return Base64.encode(in, false);
    }

    public static String encode(byte[] in, int offset, int length) {
        return Base64.encode(in, offset, length, false);
    }

    public static String encode(byte[] in, int offset, int length, boolean pem) {
        StringBuilder sb = new StringBuilder();
        int blocks = 0;
        while (length > 0) {
            int c0 = in[offset++] & 0xFF;
            int c1 = --length == 0 ? in[offset++] & 0xFF : -1;
            int c2 = --length == 0 ? in[offset++] & 0xFF : -1;
            --length;
            int block = c0 << 16 | c1 << 8 | c2;
            sb.append(alpha[block >> 18 & 0x3F]);
            sb.append(alpha[block >> 12 & 0x3F]);
            sb.append(c1 == -1 ? (char)'=' : alpha[block >> 6 & 0x3F]);
            sb.append(c2 == -1 ? (char)'=' : alpha[block & 0x3F]);
            if (++blocks != 19) continue;
            blocks = 0;
            if (!pem) continue;
            sb.append('\n');
        }
        if (pem && blocks > 0) {
            sb.append('\n');
        }
        return sb.toString();
    }

    private static int findIndex(char val, boolean url) {
        if ('A' <= val && val <= 'Z') {
            return val - 65;
        }
        if ('a' <= val && val <= 'z') {
            return val - 97 + 26;
        }
        if ('0' <= val && val <= '9') {
            return val - 48 + 52;
        }
        if (url) {
            if (val == '-') {
                return 62;
            }
            if (val == '_') {
                return 63;
            }
        } else {
            if (val == '+') {
                return 62;
            }
            if (val == '/') {
                return 63;
            }
        }
        throw new IllegalArgumentException("Base64 decode error");
    }

    public static int decode(String in, byte[] out, int offset, boolean url) {
        char equ;
        int length = in.length();
        int it = 0;
        int acc = 0;
        int outLen = 0;
        char c = equ = url ? (char)'.' : '=';
        while (it < length) {
            char b1 = '\n';
            while (it < length && (b1 == '\n' || b1 == '\r')) {
                b1 = in.charAt(it++);
            }
            char b2 = '\n';
            while (it < length && (b2 == '\n' || b2 == '\r')) {
                b2 = in.charAt(it++);
            }
            char b3 = '\n';
            while (it < length && (b3 == '\n' || b3 == '\r')) {
                b3 = in.charAt(it++);
            }
            if (b3 == '\n' || b3 == '\r') {
                b3 = equ;
            }
            char b4 = '\n';
            while (it < length && (b4 == '\n' || b4 == '\r')) {
                b4 = in.charAt(it++);
            }
            if (b4 == '\n' || b4 == '\r') {
                b4 = equ;
            }
            int i1 = Base64.findIndex(b1, url);
            int i2 = Base64.findIndex(b2, url);
            acc = i1 << 2;
            acc |= i2 >> 4;
            if (out != null) {
                out[offset + outLen] = (byte)acc;
            }
            ++outLen;
            if (b3 == equ) continue;
            int i3 = Base64.findIndex(b3, url);
            acc = (i2 & 0xF) << 4;
            acc += i3 >> 2;
            if (out != null) {
                out[offset + outLen] = (byte)acc;
            }
            ++outLen;
            if (b4 == equ) continue;
            int i4 = Base64.findIndex(b4, url);
            acc = (i3 & 3) << 6;
            acc |= i4;
            if (out != null) {
                out[offset + outLen] = (byte)acc;
            }
            ++outLen;
        }
        return outLen;
    }

    public static byte[] decode(String in) {
        return Base64.decode(in, false);
    }

    public static byte[] decode(String in, boolean url) {
        int length = Base64.decode(in, null, 0, url);
        byte[] out = new byte[length];
        Base64.decode(in, out, 0, url);
        return out;
    }

    public static byte[] decodeUrl(String in) {
        return Base64.decode(in, true);
    }
}

