/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common;

import com.unbound.common.HEX;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;

public final class JSON {
    public static Object convert(String in) {
        Parser parser = new Parser(in);
        Object item = parser.parseAny();
        Parser.check(parser.token == '\u0000');
        return item;
    }

    public static String convert(Object in) {
        StringBuilder sb = new StringBuilder();
        JSON.build(in, sb);
        return sb.toString();
    }

    private static void build(Object in, StringBuilder sb) {
        if (in == null) {
            sb.append("null");
        } else if (in instanceof List) {
            JSON.buildList((List)in, sb);
        } else if (in instanceof Map) {
            JSON.buildMap((Map)in, sb);
        } else if (in instanceof Boolean) {
            sb.append((Boolean)in != false ? "true" : "false");
        } else if (in instanceof Long) {
            sb.append(((Long)in).toString());
        } else if (in instanceof Integer) {
            sb.append(((Integer)in).toString());
        } else if (in instanceof Short) {
            sb.append(((Short)in).toString());
        } else if (in instanceof Byte) {
            sb.append(((Byte)in).toString());
        } else if (in instanceof Double) {
            sb.append(((Double)in).toString());
        } else if (in instanceof Float) {
            sb.append(((Float)in).toString());
        } else if (in instanceof String) {
            JSON.buildString((String)in, sb);
        }
    }

    private static void buildString(String value, StringBuilder sb) {
        sb.append('\"');
        int length = value.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append('\\');
                    sb.append('\"');
                    continue block9;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block9;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block9;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block9;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block9;
                }
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block9;
                }
                case '\b': {
                    sb.append('\\');
                    sb.append('b');
                    continue block9;
                }
                default: {
                    if (c <= '\u001f') {
                        sb.append('\\');
                        sb.append('u');
                        sb.append('0');
                        sb.append('0');
                        sb.append(HEX.upChars[c >> 8 & 0xF]);
                        sb.append(HEX.upChars[c & 0xF]);
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
    }

    private static void buildMap(Map<String, Object> map, StringBuilder sb) {
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!first) {
                sb.append(',');
                first = false;
            }
            sb.append('\"');
            String key = entry.getKey();
            sb.append(key, 0, key.length());
            sb.append('\"');
            sb.append(':');
            JSON.build(entry.getValue(), sb);
        }
        sb.append('}');
    }

    private static void buildList(List<Object> array, StringBuilder sb) {
        sb.append('[');
        boolean first = true;
        for (Object item : array) {
            if (!first) {
                sb.append(',');
                first = false;
            }
            JSON.build(item, sb);
        }
        sb.append(']');
    }

    private static final class Parser {
        private String src;
        private int index;
        private char c;
        private char token;
        private String tokenValue;

        Parser(String src) {
            this.src = src;
            this.index = 0;
            this.c = (char)32;
            this.token = (char)32;
            this.getNextToken();
        }

        static void check(boolean ok) {
            if (!ok) {
                throw new InputMismatchException("JSON conversion error");
            }
        }

        private char currentChar() {
            return this.c;
        }

        private char currentToken() {
            Parser.check(this.token != '\u0000');
            return this.token;
        }

        private void getNextChar() {
            this.c = this.index >= this.src.length() ? (char)'\u0000' : this.src.charAt(this.index++);
        }

        private void readNumber() {
            char c;
            this.token = (char)48;
            StringBuilder sb = new StringBuilder();
            while ((c = this.currentChar()) >= '0' && c <= '9' || c == '.' || c == 'E' || c == 'e' || c == '+' || c == '-') {
                if (c == '.' || c == 'E' || c == 'e') {
                    this.token = (char)101;
                }
                sb.append(c);
                this.getNextChar();
            }
            this.tokenValue = sb.toString();
        }

        private void skipWhiteSpace() {
            while (true) {
                char c;
                if ((c = this.currentChar()) == '\u0000') {
                    this.token = '\u0000';
                    return;
                }
                if (!Character.isWhitespace(c)) break;
                this.getNextChar();
            }
        }

        private void skipLineComment() {
            while (true) {
                char c;
                if ((c = this.currentChar()) == '\u0000') {
                    this.token = '\u0000';
                    return;
                }
                if (c == '\n' || c == '\r') break;
                this.getNextChar();
            }
        }

        private void skipBlockComment() {
            this.getNextChar();
            while (true) {
                char c;
                if ((c = this.currentChar()) == '\u0000') {
                    this.token = '\u0000';
                    return;
                }
                if (c == '*') break;
                this.getNextChar();
            }
            this.getNextChar();
            Parser.check(this.currentChar() == '/');
            this.getNextChar();
        }

        private void skipComment() {
            Parser.check(this.currentChar() == '/');
            this.getNextChar();
            if (this.currentChar() == '*') {
                this.skipBlockComment();
            } else {
                Parser.check(this.currentChar() == '/');
                this.skipLineComment();
            }
        }

        private void readTokenValue() {
            StringBuilder sb = new StringBuilder();
            while (true) {
                char c;
                if ((c = this.currentChar()) == '\u0000') {
                    this.token = '\u0000';
                    return;
                }
                if (c < 'a' || c > 'z') break;
                sb.append(c);
                this.getNextChar();
            }
            this.tokenValue = sb.toString();
        }

        private void readString() {
            StringBuilder sb = new StringBuilder();
            this.getNextChar();
            while (this.currentChar() != '\"') {
                int c1 = this.currentChar();
                this.getNextChar();
                if (c1 == 92) {
                    int c2 = this.currentChar();
                    this.getNextChar();
                    switch (c2) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            c1 = c2;
                            break;
                        }
                        case 116: {
                            c1 = 9;
                            break;
                        }
                        case 110: {
                            c1 = 10;
                            break;
                        }
                        case 114: {
                            c1 = 13;
                            break;
                        }
                        case 102: {
                            c1 = 12;
                            break;
                        }
                        case 98: {
                            c1 = 8;
                            break;
                        }
                        case 117: {
                            int x1 = HEX.from(this.currentChar());
                            this.getNextChar();
                            int x2 = HEX.from(this.currentChar());
                            this.getNextChar();
                            int x3 = HEX.from(this.currentChar());
                            this.getNextChar();
                            int x4 = HEX.from(this.currentChar());
                            this.getNextChar();
                            c1 = (char)(x1 << 12 | x2 << 8 | x3 << 4 | x4);
                            break;
                        }
                        default: {
                            Parser.check(false);
                        }
                    }
                }
                sb.append((char)c1);
            }
            this.tokenValue = sb.toString();
            this.getNextChar();
        }

        private void getNextToken() {
            while (true) {
                this.skipWhiteSpace();
                if (this.currentChar() != '/') break;
                this.skipComment();
            }
            this.token = this.currentChar();
            if (this.currentChar() >= '0' && this.currentChar() <= '9') {
                this.readNumber();
            } else {
                switch (this.currentChar()) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case 'E': 
                    case 'e': {
                        this.readNumber();
                        break;
                    }
                    case 'f': 
                    case 'n': 
                    case 't': {
                        this.readTokenValue();
                        break;
                    }
                    case '\"': {
                        this.readString();
                        break;
                    }
                    default: {
                        this.getNextChar();
                    }
                }
            }
        }

        Object parseAny() {
            char token = this.currentToken();
            switch (token) {
                case '{': {
                    return this.parseObject();
                }
                case '[': {
                    return this.parseArray();
                }
                case '\"': {
                    return this.parseString();
                }
                case '0': 
                case 'e': {
                    return this.parseNumber();
                }
                case 'f': 
                case 't': {
                    return this.parseBoolean();
                }
                case 'n': {
                    return this.parseNull();
                }
            }
            Parser.check(false);
            return null;
        }

        private ArrayList<Object> parseArray() {
            ArrayList<Object> array = new ArrayList<Object>();
            this.getNextToken();
            while (true) {
                if (this.currentToken() == ']') {
                    this.getNextToken();
                    break;
                }
                Object item = this.parseAny();
                array.add(item);
                if (this.currentToken() == ']') {
                    this.getNextToken();
                    break;
                }
                Parser.check(this.currentToken() == ',');
                this.getNextToken();
            }
            return array;
        }

        Map<String, Object> parseObject() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.getNextToken();
            while (true) {
                if (this.currentToken() == '}') {
                    this.getNextToken();
                    break;
                }
                Parser.check(this.currentToken() == '\"');
                this.getNextToken();
                String name = this.tokenValue;
                Parser.check(this.currentToken() == ':');
                this.getNextToken();
                Object item = this.parseAny();
                map.put(name, item);
                if (this.currentToken() == '}') {
                    this.getNextToken();
                    break;
                }
                Parser.check(this.currentToken() == ',');
                this.getNextToken();
            }
            return map;
        }

        private String parseString() {
            String result = this.tokenValue;
            this.getNextToken();
            return result;
        }

        private Boolean parseBoolean() {
            boolean value = this.currentToken() == 't';
            Parser.check(this.tokenValue.equals(value ? "true" : "false"));
            this.getNextToken();
            return value;
        }

        private Object parseNull() {
            Parser.check(this.tokenValue.equals("null"));
            this.getNextToken();
            return null;
        }

        private Object parseNumber() {
            boolean isDouble = this.currentToken() == 'e';
            Number result = isDouble ? (Number)Double.valueOf(this.tokenValue) : (Number)Long.valueOf(this.tokenValue);
            this.getNextToken();
            return result;
        }
    }
}

