/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.Converter;
import com.unbound.common.crypto.SystemProvider;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AES {
    private Cipher cipher;
    byte[] key;

    public AES(byte[] key) {
        this.key = key;
        this.cipher = SystemProvider.Cipher.getInstance("AES/ECB/NoPadding");
    }

    private void checkInit(int mode) {
        try {
            if (this.key != null) {
                this.cipher.init(mode, new SecretKeySpec(this.key, "AES"));
                this.key = null;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] encrypt(byte[] in) {
        this.checkInit(1);
        return this.cipher.update(in);
    }

    public AES encrypt(byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        try {
            this.checkInit(1);
            this.cipher.update(in, inOffset, inLength, out, outOffset);
            return this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] decrypt(byte[] in) {
        this.checkInit(2);
        return this.cipher.update(in);
    }

    public AES decrypt(byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        try {
            this.checkInit(2);
            this.cipher.update(in, inOffset, inLength, out, outOffset);
            return this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static byte[] encrypt(byte[] key, byte[] in) {
        return new AES(key).encrypt(in);
    }

    static byte[] decrypt(byte[] key, byte[] in) {
        return new AES(key).decrypt(in);
    }

    public static final class XTS {
        private static void gfMulX128LE(byte[] ps) {
            long whiteningLo = Converter.getLE8(ps, 0);
            long whiteningHi = Converter.getLE8(ps, 8);
            int finalCarry = 0L == (whiteningHi & Long.MIN_VALUE) ? 0 : 135;
            whiteningHi <<= 1;
            whiteningHi |= whiteningLo >>> 63;
            whiteningLo <<= 1;
            Converter.setLE8(ps, 0, whiteningLo ^= (long)finalCarry);
            Converter.setLE8(ps, 8, whiteningHi);
        }

        private static void xor(byte[] dst, int dstOffset, byte[] src1, int srcOffset1, byte[] src2, int srcOffset2) {
            for (int i = 0; i < 16; ++i) {
                dst[dstOffset + i] = (byte)(src1[srcOffset1 + i] ^ src2[srcOffset2 + i]);
            }
        }

        static byte[] encrypt(byte[] key, byte[] plain) {
            byte[] encrypted = new byte[plain.length];
            try {
                byte[] k1 = Arrays.copyOfRange(key, 0, 16);
                byte[] k2 = Arrays.copyOfRange(key, 16, 32);
                byte[] iv = new byte[16];
                byte[] ps = new AES(k2).encrypt(iv);
                Cipher cipher = SystemProvider.Cipher.getInstance("AES/ECB/NoPadding");
                cipher.init(1, new SecretKeySpec(k1, "AES"));
                byte[] temp = new byte[16];
                int n = plain.length / 16;
                int offset = 0;
                int i = 0;
                while (i < n) {
                    XTS.xor(temp, 0, ps, 0, plain, offset);
                    cipher.update(temp, 0, 16, temp);
                    XTS.xor(encrypted, offset, temp, 0, ps, 0);
                    XTS.gfMulX128LE(ps);
                    ++i;
                    offset += 16;
                }
                if (offset < plain.length) {
                    int i2;
                    int tail = plain.length - offset;
                    for (i2 = 0; i2 < tail; ++i2) {
                        encrypted[offset + i2] = encrypted[offset + i2 - 16];
                    }
                    for (i2 = 0; i2 < tail; ++i2) {
                        temp[i2] = plain[offset + i2];
                    }
                    for (i2 = tail; i2 < 16; ++i2) {
                        temp[i2] = encrypted[offset + i2 - 16];
                    }
                    XTS.xor(temp, 0, temp, 0, ps, 0);
                    cipher.update(temp, 0, 16, temp);
                    XTS.xor(encrypted, offset - 16, temp, 0, ps, 0);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return encrypted;
        }

        static byte[] decrypt(byte[] key, byte[] encrypted) {
            byte[] plain = new byte[encrypted.length];
            try {
                byte[] k1 = Arrays.copyOfRange(key, 0, 16);
                byte[] k2 = Arrays.copyOfRange(key, 16, 32);
                byte[] iv = new byte[16];
                byte[] ps = new AES(k2).encrypt(iv);
                byte[] psSave = new byte[16];
                Cipher cipher = SystemProvider.Cipher.getInstance("AES/ECB/NoPadding");
                cipher.init(2, new SecretKeySpec(k1, "AES"));
                byte[] temp = new byte[16];
                int n = encrypted.length / 16;
                int tail = encrypted.length - n * 16;
                int offset = 0;
                int i = 0;
                while (i < n) {
                    if (tail > 0 && i == n - 1) {
                        System.arraycopy(ps, 0, psSave, 0, 16);
                        XTS.gfMulX128LE(ps);
                    }
                    XTS.xor(temp, 0, ps, 0, encrypted, offset);
                    cipher.update(temp, 0, 16, temp);
                    XTS.xor(plain, offset, temp, 0, ps, 0);
                    XTS.gfMulX128LE(ps);
                    ++i;
                    offset += 16;
                }
                if (tail > 0) {
                    for (i = 0; i < tail; ++i) {
                        plain[offset + i] = plain[offset + i - 16];
                    }
                    for (i = 0; i < tail; ++i) {
                        temp[i] = encrypted[offset + i];
                    }
                    for (i = tail; i < 16; ++i) {
                        temp[i] = plain[offset + i - 16];
                    }
                    XTS.xor(temp, 0, temp, 0, psSave, 0);
                    cipher.update(temp, 0, 16, temp);
                    XTS.xor(plain, offset - 16, temp, 0, psSave, 0);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return plain;
        }
    }

    public static final class GCM {
        public static byte[] encrypt(byte[] key, byte[] iv, int tagLen, byte[] in) {
            return GCM.encrypt(key, iv, null, tagLen, in);
        }

        public static byte[] encrypt(byte[] key, byte[] iv, byte[] aad, int tagLen, byte[] in) {
            try {
                byte[] out = new byte[in.length + tagLen];
                GCMParameterSpec params = new GCMParameterSpec(tagLen * 8, iv);
                Cipher cipher = SystemProvider.Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(1, (Key)new SecretKeySpec(key, "AES"), params);
                if (aad != null && aad.length > 0) {
                    cipher.updateAAD(aad);
                }
                int tempSize = cipher.update(in, 0, in.length, out, 0);
                cipher.doFinal(out, tempSize);
                return out;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        public static byte[] decrypt(byte[] key, byte[] iv, int tagLen, byte[] in) throws AEADBadTagException {
            return GCM.decrypt(key, iv, null, tagLen, in);
        }

        public static byte[] decrypt(byte[] key, byte[] iv, byte[] aad, int tagLen, byte[] in) throws AEADBadTagException {
            try {
                byte[] out = new byte[in.length - tagLen];
                GCMParameterSpec params = new GCMParameterSpec(tagLen * 8, iv);
                Cipher cipher = SystemProvider.Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(2, (Key)new SecretKeySpec(key, "AES"), params);
                if (aad != null && aad.length > 0) {
                    cipher.updateAAD(aad);
                }
                int tempSize = cipher.update(in, 0, in.length, out, 0);
                cipher.doFinal(out, tempSize);
                return out;
            }
            catch (AEADBadTagException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

