/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.Arithmetic;
import com.unbound.common.Converter;
import com.unbound.common.crypto.DER;
import com.unbound.common.crypto.SystemProvider;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

public final class EC {
    public static Curve P256 = null;
    public static Curve P256k = null;
    public static Curve P384 = null;
    public static Curve P521 = null;
    static Curve[] curves = new Curve[4];

    private EC() {
    }

    public static Curve getCurve(ECPublicKey key) {
        return EC.getCurve(key.getParams());
    }

    public static Curve getCurve(ECParameterSpec paramSpec) {
        for (Curve curve : curves) {
            if (!paramSpec.equals(curve.spec)) continue;
            return curve;
        }
        return null;
    }

    public static Curve getCurveBySize(int bitSize) {
        for (Curve curve : curves) {
            if (curve.bits != bitSize) continue;
            return curve;
        }
        return null;
    }

    public static Curve getCurveByKmipCode(int kmipCode) {
        for (Curve curve : curves) {
            if (curve.kmipCode != kmipCode) continue;
            return curve;
        }
        return null;
    }

    public static Curve getCurveByDyCode(int dyCode) {
        for (Curve curve : curves) {
            if (curve.dyCode != dyCode) continue;
            return curve;
        }
        return null;
    }

    public static byte[] ecdh(ECPrivateKey prv, ECPublicKey pub) {
        try {
            KeyAgreement ka = SystemProvider.KeyAgreement.getInstance("ECDH");
            ka.init(prv);
            ka.doPhase(pub, true);
            return ka.generateSecret();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ECPoint getPoint(ECPrivateKey prvKey) {
        Curve curve = EC.getCurve(prvKey.getParams());
        if (curve == null) {
            throw new IllegalArgumentException("Curve not supported");
        }
        ECPublicKey G = curve.getPublicKey(curve.generator);
        return curve.mul(prvKey, null, G, null);
    }

    public static ECPublicKey getPublicKey(ECPrivateKey prvKey) {
        Curve curve = EC.getCurve(prvKey.getParams());
        if (curve == null) {
            throw new IllegalArgumentException("Curve not supported");
        }
        return curve.getPublicKey(EC.getPoint(prvKey));
    }

    public static byte[] ecdsa(ECPrivateKey prv, String hashName, byte[] in) {
        try {
            Signature signature = SystemProvider.Signature.getInstance(hashName + "withECDSA");
            signature.initSign(prv);
            signature.update(in);
            return signature.sign();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean ecdsaVerify(ECPublicKey pub, String hashName, byte[] in, byte[] sig) {
        try {
            Signature signature = SystemProvider.Signature.getInstance(hashName + "withECDSA");
            signature.initVerify(pub);
            signature.update(in);
            return signature.verify(sig);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        EC.curves[0] = P256 = Curve.register("secp256r1", 7, 0);
        EC.curves[2] = P384 = Curve.register("secp384r1", 10, 1);
        EC.curves[3] = P521 = Curve.register("secp521r1", 13, 2);
        EC.curves[1] = P256k = Curve.register("secp256k1", 25, 3);
    }

    public static final class Curve {
        public String name;
        public int bits;
        public int size;
        public byte[] oid;
        public int kmipCode;
        public int dyCode;
        public ECGenParameterSpec genSpec;
        public ECParameterSpec spec;
        public AlgorithmParameters algParam;
        public BigInteger order;
        public ECPoint generator;
        public EllipticCurve ec;
        public ECFieldFp field;

        private Curve(String name, int kmipCode, int dyCode) {
            this.name = name;
            this.kmipCode = kmipCode;
            this.dyCode = dyCode;
        }

        private boolean register() {
            this.genSpec = new ECGenParameterSpec(this.name);
            try {
                this.algParam = AlgorithmParameters.getInstance("EC");
                this.algParam.init(this.genSpec);
                this.oid = this.algParam.getEncoded();
                this.spec = this.algParam.getParameterSpec(ECParameterSpec.class);
                this.order = this.spec.getOrder();
                this.generator = this.spec.getGenerator();
                this.bits = this.order.bitLength();
                this.size = (this.bits + 7) / 8;
                this.ec = this.spec.getCurve();
                this.field = (ECFieldFp)this.ec.getField();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        private static Curve register(String name, int kmipCode, int dyCode) {
            Curve curve = new Curve(name, kmipCode, dyCode);
            if (curve.register()) {
                return curve;
            }
            return null;
        }

        private static void invalidSignature() {
            throw new IllegalArgumentException("Invalid EC signature");
        }

        public byte[] toDer(ECPoint point) {
            return new DER.Builder().beginOctetString().add(this.toOct(point)).end().toByteArray();
        }

        public byte[] toOct(ECPoint point) {
            byte[] oct = new byte[1 + 2 * this.size];
            oct[0] = 4;
            Converter.bigNumToBin(point.getAffineX(), oct, 1, this.size);
            Converter.bigNumToBin(point.getAffineY(), oct, 1 + this.size, this.size);
            return oct;
        }

        public byte[] toCompressedOct(ECPoint point) {
            BigInteger x = point.getAffineX();
            BigInteger y = point.getAffineY();
            byte[] oct = new byte[1 + this.size];
            oct[0] = y.testBit(0) ? 3 : 2;
            Converter.bigNumToBin(x, oct, 1, this.size);
            return oct;
        }

        public ECPoint fromOct(byte[] oct) {
            return this.fromOct(oct, 0, oct.length);
        }

        public ECPoint add(ECPoint a, ECPoint b) {
            BigInteger p = this.field.getP();
            BigInteger x0 = a.getAffineX();
            BigInteger y0 = a.getAffineY();
            BigInteger x1 = b.getAffineX();
            BigInteger y1 = b.getAffineY();
            BigInteger s = Arithmetic.divP(Arithmetic.subP(y0, y1, p), Arithmetic.subP(x0, x1, p), p);
            BigInteger x2 = Arithmetic.subP(Arithmetic.subP(s.multiply(s).mod(p), x0, p), x1, p);
            BigInteger y2 = Arithmetic.subP(Arithmetic.subP(x0, x2, p).multiply(s).mod(p), y0, p);
            return new ECPoint(x2, y2);
        }

        private ECPoint mul(ECPrivateKey prvKey, BigInteger d, ECPublicKey pubKey, ECPoint p) {
            if (prvKey == null) {
                prvKey = this.getPrivateKey(d);
            }
            if (pubKey == null) {
                pubKey = this.getPublicKey(p);
            }
            if (p == null) {
                p = pubKey.getW();
            }
            BigInteger x = new BigInteger(1, EC.ecdh(prvKey, pubKey));
            BigInteger d1 = prvKey.getS().add(BigInteger.ONE);
            ECPrivateKey next = this.getPrivateKey(d1);
            BigInteger xNext = new BigInteger(1, EC.ecdh(next, pubKey));
            BigInteger y0 = this.recoverY(x, false);
            ECPoint point = new ECPoint(x, y0);
            BigInteger xTest = this.add(point, p).getAffineX();
            if (xTest.equals(xNext)) {
                return point;
            }
            BigInteger y1 = this.field.getP().subtract(y0);
            return new ECPoint(x, y1);
        }

        public ECPoint mul(BigInteger d, ECPoint p) {
            return this.mul(null, d, null, p);
        }

        public ECPrivateKey getPrivateKey(BigInteger d) {
            try {
                return (ECPrivateKey)SystemProvider.KeyFactory.getInstance("EC").generatePrivate(new ECPrivateKeySpec(d, this.spec));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        private BigInteger recoverY(BigInteger x, boolean bit0) {
            BigInteger a = this.ec.getA();
            BigInteger b = this.ec.getB();
            BigInteger p = this.field.getP();
            BigInteger y2 = x.multiply(x).add(a).multiply(x).add(b).mod(p);
            BigInteger y = Arithmetic.sqrtP(y2, p);
            if (bit0 != y.testBit(0)) {
                y = p.subtract(y).mod(p);
            }
            return y;
        }

        public ECPoint fromOct(byte[] oct, int offset, int length) {
            if (length < 0) {
                throw new IllegalArgumentException("Invalid OCT length");
            }
            if (oct[offset] == 4) {
                if (length != 1 + this.size * 2) {
                    throw new IllegalArgumentException("Invalid OCT length");
                }
                BigInteger x = new BigInteger(1, Arrays.copyOfRange(oct, offset + 1, offset + 1 + this.size));
                BigInteger y = new BigInteger(1, Arrays.copyOfRange(oct, offset + 1 + this.size, length));
                return new ECPoint(x, y);
            }
            if (oct[offset] == 2 || oct[offset] == 3) {
                if (length != 1 + this.size) {
                    throw new IllegalArgumentException("Invalid OCT length");
                }
                BigInteger x = new BigInteger(1, Arrays.copyOfRange(oct, offset + 1, offset + length));
                boolean bit0 = oct[offset] == 3;
                BigInteger y = this.recoverY(x, bit0);
                return new ECPoint(x, y);
            }
            throw new IllegalArgumentException("Invalid OCT data");
        }

        public byte[] sigDerToBin(byte[] bin) {
            DER.Parser parser = new DER.Parser(bin);
            parser.beginSequence();
            BigInteger r = parser.getBigInteger();
            BigInteger s = parser.getBigInteger();
            parser.end();
            byte[] out = new byte[this.size * 2];
            Converter.bigNumToBin(r, out, 0, this.size);
            Converter.bigNumToBin(s, out, this.size, this.size);
            return out;
        }

        public byte[] sigBinToDer(byte[] bin) {
            if (bin.length != 2 * this.size) {
                Curve.invalidSignature();
            }
            BigInteger r = Converter.binToBigNum(bin, 0, this.size);
            BigInteger s = Converter.binToBigNum(bin, this.size, this.size);
            return new DER.Builder().beginSequence().add(r).add(s).end().toByteArray();
        }

        ECPublicKey getPublicKey(ECPoint point) {
            try {
                return (ECPublicKey)SystemProvider.KeyFactory.getInstance("EC").generatePublic(new ECPublicKeySpec(point, this.spec));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

