/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.Bits;
import com.unbound.common.Converter;
import com.unbound.common.crypto.AES;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class FPE {
    static void aesFeistelEncrypt(AES aes, byte[] plain, byte[] encrypted, int bits) {
        assert ((bits + 7) / 8 == plain.length);
        int half = bits / 2;
        assert (half * 2 == bits);
        assert (half <= 64);
        byte[] left = new byte[8];
        byte[] right = new byte[8];
        Bits.copy(left, 0, plain, 0, half);
        Bits.copy(right, 0, plain, half, half);
        byte[] buf = new byte[16];
        int rounds = 36;
        if (bits >= 10) {
            rounds = 30;
        }
        if (bits >= 14) {
            rounds = 24;
        }
        if (bits >= 20) {
            rounds = 18;
        }
        if (bits >= 32) {
            rounds = 12;
        }
        for (int i = 0; i < rounds; ++i) {
            int j;
            buf[0] = (byte)bits;
            buf[1] = (byte)i;
            for (j = 2; j < 16; ++j) {
                buf[j] = 0;
            }
            Bits.copy(buf, 16, right, 0, half);
            aes.encrypt(buf, 0, 16, buf, 0);
            for (j = 0; j < 8; ++j) {
                int n = j;
                left[n] = (byte)(left[n] ^ buf[j]);
            }
            byte[] p = left;
            left = right;
            right = p;
        }
        Bits.copy(encrypted, 0, right, 0, half);
        Bits.copy(encrypted, half, left, 0, half);
    }

    static void aesFeistelDecrypt(AES aes, byte[] encrypted, byte[] plain, int bits) {
        assert ((bits + 7) / 8 == encrypted.length);
        int half = bits / 2;
        assert (half * 2 == bits);
        assert (half <= 64);
        byte[] left = new byte[8];
        byte[] right = new byte[8];
        Bits.copy(left, 0, encrypted, 0, half);
        Bits.copy(right, 0, encrypted, half, half);
        byte[] buf = new byte[16];
        int rounds = 36;
        if (bits >= 10) {
            rounds = 30;
        }
        if (bits >= 14) {
            rounds = 24;
        }
        if (bits >= 20) {
            rounds = 18;
        }
        if (bits >= 32) {
            rounds = 12;
        }
        for (int i = rounds - 1; i >= 0; --i) {
            int j;
            buf[0] = (byte)bits;
            buf[1] = (byte)i;
            for (j = 2; j < 16; ++j) {
                buf[j] = 0;
            }
            Bits.copy(buf, 16, right, 0, half);
            aes.encrypt(buf, 0, 16, buf, 0);
            for (j = 0; j < 8; ++j) {
                int n = j;
                left[n] = (byte)(left[n] ^ buf[j]);
            }
            byte[] p = left;
            left = right;
            right = p;
        }
        Bits.copy(plain, 0, right, 0, half);
        Bits.copy(plain, half, left, 0, half);
    }

    private static char[] digitsOnly(char[] in, boolean isFormat) {
        int len = in.length;
        char[] out = new char[len];
        int outLen = 0;
        for (int i = 0; i < len; ++i) {
            char c = in[i];
            if (c >= '0' && c <= '9') {
                out[outLen++] = c;
                continue;
            }
            if ((!isFormat || c != '#') && c != '?') continue;
            out[outLen++] = c;
        }
        return Arrays.copyOfRange(out, 0, outLen);
    }

    private static char[] applyFormat(char[] in, char[] format) {
        int inIndex = 0;
        int inLen = in.length;
        int formatLen = format.length;
        char[] out = new char[formatLen];
        for (int i = 0; i < formatLen; ++i) {
            char c = format[i];
            if ((c == '#' || c == '?') && inIndex < inLen) {
                c = in[inIndex++];
            }
            out[i] = c;
        }
        return out;
    }

    public static final class STR {
        private static final SymbolRange[] unicodeNonSymbols = new SymbolRange[]{new SymbolRange(55296, 57343), new SymbolRange(64976, 65007), new SymbolRange(65534, 65535), new SymbolRange(131070, 131071), new SymbolRange(196606, 196607), new SymbolRange(262142, 262143), new SymbolRange(327678, 327679), new SymbolRange(393214, 393215), new SymbolRange(458750, 458751), new SymbolRange(524286, 524287), new SymbolRange(589822, 589823), new SymbolRange(655358, 655359), new SymbolRange(720894, 720895), new SymbolRange(786430, 786431), new SymbolRange(851966, 851967), new SymbolRange(917502, 917503), new SymbolRange(983038, 983039), new SymbolRange(1048574, 1048575), new SymbolRange(1114110, 0x10FFFF)};
        private static final Encoding utf = new Encoding(0x110000, unicodeNonSymbols.length);
        private static final Encoding ucs = new Encoding(65536, 3);

        private static byte[] bnToBin(BigInteger bn) {
            byte[] out = bn.toByteArray();
            if (out.length > 0 && out[0] == 0) {
                return Arrays.copyOfRange(out, 1, out.length);
            }
            return out;
        }

        private static BigInteger binToBn(byte[] bytes) {
            if ((bytes[0] & 0x80) != 0) {
                byte[] temp = new byte[bytes.length + 1];
                temp[0] = 0;
                System.arraycopy(bytes, 0, temp, 1, bytes.length);
                bytes = temp;
            }
            return new BigInteger(1, bytes);
        }

        public static String encrypt(byte[] key, String plain, boolean BMPOnly) {
            byte[] key1 = Arrays.copyOfRange(key, 0, 16);
            Encoding encoding = BMPOnly ? ucs : utf;
            BigInteger bn = encoding.stringToBn(plain);
            if (bn == null) {
                return null;
            }
            byte[] plainBytes = STR.bnToBin(bn);
            int size = plainBytes.length;
            byte[] enc = null;
            AES aes = null;
            if (size < 16) {
                enc = new byte[size];
                aes = new AES(key1);
            }
            while (true) {
                if (size < 16) {
                    FPE.aesFeistelEncrypt(aes, plainBytes, enc, size * 8);
                } else {
                    enc = AES.XTS.encrypt(key, plainBytes);
                }
                if (enc[0] != 0) break;
                plainBytes = enc;
            }
            bn = STR.binToBn(enc);
            return encoding.bnToString(bn);
        }

        public static String decrypt(byte[] key, String encrypted, boolean BMPOnly) {
            byte[] key1 = Arrays.copyOfRange(key, 0, 16);
            Encoding encoding = BMPOnly ? ucs : utf;
            BigInteger bn = encoding.stringToBn(encrypted);
            byte[] encryptedBytes = STR.bnToBin(bn);
            int size = encryptedBytes.length;
            byte[] dec = null;
            AES aes = null;
            if (size < 16) {
                dec = new byte[size];
                aes = new AES(key1);
            }
            while (true) {
                if (size < 16) {
                    FPE.aesFeistelDecrypt(aes, encryptedBytes, dec, size * 8);
                } else {
                    dec = AES.XTS.decrypt(key, encryptedBytes);
                }
                if (dec[0] != 0) break;
                encryptedBytes = dec;
            }
            bn = STR.binToBn(dec);
            return encoding.bnToString(bn);
        }

        private static class Encoding {
            int rangesCount;
            int maxCode;
            int maxSymbol;

            Encoding(int maxSymbol, int count) {
                this.maxSymbol = maxSymbol;
                this.rangesCount = count;
                this.maxCode = maxSymbol;
                for (int i = 0; i < this.rangesCount; ++i) {
                    this.maxCode -= unicodeNonSymbols[i].to - unicodeNonSymbols[i].from + 1;
                }
            }

            int symbolToCode(int symbol) {
                if (symbol >= this.maxSymbol) {
                    return -1;
                }
                int code = symbol;
                for (int i = 0; i < this.rangesCount; ++i) {
                    int from = unicodeNonSymbols[i].from;
                    int to = unicodeNonSymbols[i].to;
                    if (symbol < from) break;
                    if (symbol <= to) {
                        return -1;
                    }
                    code -= to - from + 1;
                }
                return code;
            }

            int codeToSymbol(int code) {
                int symbol = code;
                for (int i = 0; i < this.rangesCount; ++i) {
                    int from = unicodeNonSymbols[i].from;
                    int to = unicodeNonSymbols[i].to;
                    if (symbol < from) break;
                    symbol += to - from + 1;
                }
                if (symbol >= this.maxSymbol) {
                    return -1;
                }
                return symbol;
            }

            private static void setBE2(byte[] pointer, int offset, short value) {
                pointer[offset + 0] = (byte)(value >> 8);
                pointer[offset + 1] = (byte)value;
            }

            private static short byteToUShort(byte b) {
                return (short)((short)b & 0xFF);
            }

            private static short getBE2(byte[] pointer, int offset) {
                return (short)(Encoding.byteToUShort(pointer[offset + 0]) << 8 | Encoding.byteToUShort(pointer[offset + 1]));
            }

            int getSymbolLen(byte[] src, int index, int size) {
                if (size < 2) {
                    return 0;
                }
                int w = Encoding.getBE2(src, index + 0) & 0xFFFF;
                if (w < 55296 || w > 56319) {
                    return 2;
                }
                if (this.rangesCount == 3) {
                    return 0;
                }
                if (size < 4) {
                    return 0;
                }
                short w2 = Encoding.getBE2(src, index + 2);
                if (w2 < 56320 || w2 > 57343) {
                    return 0;
                }
                return 4;
            }

            int getSymbol(byte[] src, int index, int size) {
                int w = Encoding.getBE2(src, index + 0) & 0xFFFF;
                if (w < 55296 || w > 56319) {
                    return w;
                }
                int w2 = Encoding.getBE2(src, index + 2) & 0xFFFF;
                return 65536 + (w - 55296 << 10) + (w2 - 56320);
            }

            int putSymbol(byte[] dst, int src) {
                if (this.rangesCount == 3 && src >= 65536) {
                    return 0;
                }
                if (src < 65536) {
                    Encoding.setBE2(dst, 0, (short)src);
                    return 2;
                }
                short w = (short)(55296 + ((src -= 65536) >> 10));
                Encoding.setBE2(dst, 0, w);
                w = (short)(56320 + (src & 0x3FF));
                Encoding.setBE2(dst, 2, w);
                return 4;
            }

            BigInteger stringToBn(String string) {
                int n;
                byte[] src;
                try {
                    src = string.getBytes("UTF-16BE");
                }
                catch (Exception e) {
                    return null;
                }
                BigInteger out = BigInteger.ZERO;
                int codesCount = this.maxCode - 1;
                int index = 0;
                for (int size = src.length; size > 0; size -= n) {
                    n = this.getSymbolLen(src, index, size);
                    if (n <= 0) {
                        return null;
                    }
                    int symbol = this.getSymbol(src, index, size);
                    int code = this.symbolToCode(symbol);
                    if (code <= 0) {
                        return null;
                    }
                    out = out.multiply(BigInteger.valueOf(codesCount));
                    out = out.add(BigInteger.valueOf(--code));
                    index += n;
                }
                return out;
            }

            String bnToString(BigInteger bn) {
                byte[] temp = new byte[16];
                byte[] bytes = new byte[]{};
                int codesCount = this.maxCode - 1;
                while (!bn.equals(BigInteger.ZERO)) {
                    BigInteger[] d = bn.divideAndRemainder(BigInteger.valueOf(codesCount));
                    int code = (int)d[1].longValue() + 1;
                    bn = d[0];
                    int symbol = this.codeToSymbol(code);
                    if (symbol < 0) {
                        return null;
                    }
                    int n = this.putSymbol(temp, symbol);
                    byte[] old = bytes;
                    bytes = new byte[n + old.length];
                    System.arraycopy(temp, 0, bytes, 0, n);
                    System.arraycopy(old, 0, bytes, n, old.length);
                }
                try {
                    return new String(bytes, "UTF-16BE");
                }
                catch (Exception e) {
                    return null;
                }
            }
        }

        private static class SymbolRange {
            int from;
            int to;

            SymbolRange(int from, int to) {
                this.from = from;
                this.to = to;
            }
        }
    }

    public static final class EMail {
        private static final BigInteger bn62 = new BigInteger("62");
        private static final String[] topDomains = new String[]{"ac", "ad", "ae", "af", "ag", "ai", "al", "am", "an", "ao", "aq", "ar", "as", "at", "au", "aw", "ax", "az", "ba", "bb", "bd", "be", "bf", "bg", "bh", "bi", "bj", "bm", "bn", "bo", "bq", "br", "bs", "bt", "bv", "bw", "by", "bz", "ca", "cc", "cd", "cf", "cg", "ch", "ci", "ck", "cl", "cm", "cn", "co", "cr", "cu", "cv", "cw", "cx", "cy", "cz", "de", "dj", "dk", "dm", "do", "dz", "ec", "ee", "eg", "eh", "er", "es", "et", "eu", "fi", "fj", "fk", "fm", "fo", "fr", "ga", "gb", "gd", "ge", "gf", "gg", "gh", "gi", "gl", "gm", "gn", "gp", "gq", "gr", "gs", "gt", "gu", "gw", "gy", "hk", "hm", "hn", "hr", "ht", "hu", "id", "ie", "il", "im", "in", "io", "iq", "ir", "is", "it", "je", "jm", "jo", "jp", "ke", "kg", "kh", "ki", "km", "kn", "kp", "kr", "kw", "ky", "kz", "la", "lb", "lc", "li", "lk", "lr", "ls", "lt", "lu", "lv", "ly", "ma", "mc", "md", "me", "mg", "mh", "mk", "ml", "mm", "mn", "mo", "mp", "mq", "mr", "ms", "mt", "mu", "mv", "mw", "mx", "my", "mz", "na", "nc", "ne", "nf", "ng", "ni", "nl", "no", "np", "nr", "nu", "nz", "om", "pa", "pe", "pf", "pg", "ph", "pk", "pl", "pm", "pn", "pr", "ps", "pt", "pw", "py", "qa", "re", "ro", "rs", "ru", "rw", "sa", "sb", "sc", "sd", "se", "sg", "sh", "si", "sj", "sk", "sl", "sm", "sn", "so", "sr", "ss", "st", "su", "sv", "sx", "sy", "sz", "tc", "td", "tf", "tg", "th", "tj", "tk", "tl", "tm", "tn", "to", "tp", "tr", "tt", "tv", "tw", "tz", "ua", "ug", "uk", "us", "uy", "uz", "va", "vc", "ve", "vg", "vi", "vn", "vu", "wf", "ws", "ye", "yt", "za", "zm", "zw"};

        private static int encodeEmailPlainChar(char src) {
            if (src >= 'a' && src <= 'z') {
                return src - 97;
            }
            if (src >= 'A' && src <= 'Z') {
                return src - 65;
            }
            if (src >= '0' && src <= '9') {
                return 26 + (src - 48);
            }
            switch (src) {
                case '.': {
                    return 36;
                }
                case '!': {
                    return 37;
                }
                case '#': {
                    return 38;
                }
                case '$': {
                    return 39;
                }
                case '%': {
                    return 40;
                }
                case '&': {
                    return 41;
                }
                case '*': {
                    return 42;
                }
                case '+': {
                    return 43;
                }
                case '-': {
                    return 44;
                }
                case '/': {
                    return 45;
                }
                case '=': {
                    return 46;
                }
                case '_': {
                    return 47;
                }
                case '{': {
                    return 48;
                }
                case '|': {
                    return 49;
                }
                case '}': {
                    return 50;
                }
                case '~': {
                    return 51;
                }
                case '(': {
                    return 52;
                }
                case ')': {
                    return 53;
                }
                case ',': {
                    return 54;
                }
                case ':': {
                    return 55;
                }
                case ';': {
                    return 56;
                }
                case '<': {
                    return 57;
                }
                case '>': {
                    return 58;
                }
                case '[': {
                    return 59;
                }
                case ']': {
                    return 60;
                }
                case '@': {
                    return 61;
                }
            }
            return -1;
        }

        private static char decodeEmailPlainChar(int src) {
            if (src < 26) {
                return (char)(97 + src);
            }
            if (src < 36) {
                return (char)(48 + src - 26);
            }
            switch (src) {
                case 36: {
                    return '.';
                }
                case 37: {
                    return '!';
                }
                case 38: {
                    return '#';
                }
                case 39: {
                    return '$';
                }
                case 40: {
                    return '%';
                }
                case 41: {
                    return '&';
                }
                case 42: {
                    return '*';
                }
                case 43: {
                    return '+';
                }
                case 44: {
                    return '-';
                }
                case 45: {
                    return '/';
                }
                case 46: {
                    return '=';
                }
                case 47: {
                    return '_';
                }
                case 48: {
                    return '{';
                }
                case 49: {
                    return '|';
                }
                case 50: {
                    return '}';
                }
                case 51: {
                    return '~';
                }
                case 52: {
                    return '(';
                }
                case 53: {
                    return ')';
                }
                case 54: {
                    return ',';
                }
                case 55: {
                    return ':';
                }
                case 56: {
                    return ';';
                }
                case 57: {
                    return '<';
                }
                case 58: {
                    return '>';
                }
                case 59: {
                    return '[';
                }
                case 60: {
                    return ']';
                }
                case 61: {
                    return '@';
                }
            }
            return '\uffff';
        }

        private static int encodeEmailEncryptedChar(char src) {
            if (src >= 'a' && src <= 'z') {
                return src - 97;
            }
            if (src >= 'A' && src <= 'Z') {
                return src - 65 + 26;
            }
            if (src >= '0' && src <= '9') {
                return 52 + (src - 48);
            }
            return -1;
        }

        private static char decodeEmailEncryptedChar(byte src) {
            if (src < 0) {
                return '\uffff';
            }
            if (src < 26) {
                return (char)(97 + src);
            }
            if (src < 52) {
                return (char)(65 + src - 26);
            }
            if (src < 62) {
                return (char)(48 + src - 52);
            }
            return '\uffff';
        }

        private static byte[] sha256(byte[] in1, byte in2) {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("SHA-256 is not available");
            }
            md.update(in1);
            md.update(in2);
            return md.digest();
        }

        public static String encrypt(byte[] key, String plain, int maxSize) {
            char c;
            byte[] encrypted;
            int encodedSize;
            if (maxSize <= 0) {
                maxSize = 254;
            }
            if (plain.length() + 6 > maxSize) {
                return null;
            }
            int nameSize = plain.indexOf(64);
            if (nameSize <= 0 || nameSize >= 63) {
                return null;
            }
            int domainSize = plain.length() - nameSize - 1;
            if (domainSize < 3) {
                return null;
            }
            int padLen = maxSize - 6 - plain.length();
            byte[] plainAscii = plain.getBytes(StandardCharsets.US_ASCII);
            byte[] padding = new byte[padLen];
            for (int i = 0; i < padLen; i += 32) {
                byte counter = (byte)(i / 32);
                byte[] h = EMail.sha256(plainAscii, counter);
                int n = padLen - i;
                if (n > 32) {
                    n = 32;
                }
                for (int j = 0; j < n; ++j) {
                    padding[i + j] = (byte)(1 + (h[j] & 0xFF) % 60);
                }
            }
            if (padLen > 0) {
                padding[padLen - 1] = 61;
            }
            BigInteger bn = BigInteger.ZERO;
            for (int i = 0; i < padLen; ++i) {
                bn = bn.multiply(bn62);
                bn = bn.add(BigInteger.valueOf(padding[i]));
            }
            int e_sum2 = 0;
            for (int i = 0; i < plain.length(); ++i) {
                int e = EMail.encodeEmailPlainChar(plain.charAt(i));
                if (e < 0) {
                    return null;
                }
                bn = bn.multiply(bn62);
                bn = bn.add(BigInteger.valueOf(e));
                e_sum2 += e;
            }
            byte[] encoded = bn.toByteArray();
            if (encoded[0] == 0) {
                encoded = Arrays.copyOfRange(encoded, 1, encoded.length);
            }
            if ((encodedSize = encoded.length) < 16) {
                return null;
            }
            while (true) {
                if ((encrypted = AES.XTS.encrypt(key, encoded))[0] != 0) break;
                encoded = encrypted;
            }
            bn = new BigInteger(1, encrypted);
            int n = maxSize - 4;
            char[] temp = new char[n];
            int e_sum = 0;
            for (int i = 0; i < n; ++i) {
                BigInteger[] m = bn.divideAndRemainder(bn62);
                bn = m[0];
                byte e = (byte)m[1].intValue();
                char c2 = EMail.decodeEmailEncryptedChar(e);
                if (c2 == '\uffff') {
                    return null;
                }
                temp[n - i - 1] = c2;
                e_sum += e;
            }
            int padNameSize = 5 + (e_sum + e_sum2) % maxSize / 3;
            if (padNameSize > 64) {
                padNameSize = 64;
            }
            if (padNameSize > n - 1) {
                padNameSize = n - 1;
            }
            int offset = 0;
            if (temp[0] == 'a' && ((c = temp[1]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                offset = 1;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(temp, offset, padNameSize - offset);
            sb.append('@');
            sb.append(temp, padNameSize, n - padNameSize);
            sb.append('.');
            sb.append(topDomains[e_sum % topDomains.length]);
            return sb.toString();
        }

        public static String decrypt(byte[] key, String enc) {
            byte[] decrypted;
            int nameSize = enc.indexOf(64);
            if (nameSize < 0 || nameSize > 64) {
                return null;
            }
            int dotSize = enc.lastIndexOf(46);
            if (dotSize != enc.length() - 3) {
                return null;
            }
            BigInteger bn = BigInteger.ZERO;
            for (int i = 0; i < dotSize; ++i) {
                char c = enc.charAt(i);
                if (c == '@') continue;
                int e = EMail.encodeEmailEncryptedChar(c);
                if (e < 0) {
                    return null;
                }
                bn = bn.multiply(bn62);
                bn = bn.add(BigInteger.valueOf(e));
            }
            byte[] encoded = bn.toByteArray();
            if (encoded[0] == 0) {
                encoded = Arrays.copyOfRange(encoded, 1, encoded.length);
            }
            while (true) {
                if ((decrypted = AES.XTS.decrypt(key, encoded))[0] != 0) break;
                encoded = decrypted;
            }
            bn = new BigInteger(1, decrypted);
            boolean padding = false;
            int n = enc.length();
            char[] temp = new char[n];
            int k = 0;
            for (int i = 0; i < n; ++i) {
                char c;
                BigInteger[] m = bn.divideAndRemainder(bn62);
                bn = m[0];
                byte e = (byte)m[1].intValue();
                if (e == 61) {
                    if (padding) break;
                    padding = true;
                }
                if ((c = EMail.decodeEmailPlainChar(e)) == '\uffff') {
                    return null;
                }
                temp[n - ++k] = c;
            }
            return new String(temp, n - k, k);
        }
    }

    public static final class CreditCard {
        static int lunhCheckSum(char[] s, int offset, int len) {
            if (len < 0) {
                len = s.length;
            }
            boolean odd = (len & 1) != 0;
            int sum = 0;
            for (int i = 0; i < len; ++i) {
                int digit = s[offset + i] - 48;
                if (odd && (digit *= 2) >= 10) {
                    digit = digit % 10 + 1;
                }
                sum += digit;
                odd = !odd;
            }
            return (sum %= 10) == 0 ? 0 : 10 - sum;
        }

        private static Rank rank(char[] in, char[] format) {
            Rank r = new Rank();
            r.format = (char[])format.clone();
            int len = in.length;
            if (len < 12 || len > 19) {
                return null;
            }
            if (format.length != len) {
                return null;
            }
            if (CreditCard.lunhCheckSum(in, 0, len - 1) != in[len - 1] - 48) {
                return null;
            }
            int count = len - 1;
            r.value = 0L;
            count = 0;
            for (int i = 0; i < len - 1; ++i) {
                if (r.format[i] == '#') {
                    r.value = r.value * 10L + (long)(in[i] - 48);
                    ++count;
                    continue;
                }
                r.format[i] = in[i];
            }
            if (r.format[len - 1] != '#') {
                r.format[len - 1] = in[len - 1];
            }
            switch (count) {
                case 1: {
                    r.max = 10L;
                    r.bits = 4;
                    break;
                }
                case 2: {
                    r.max = 100L;
                    r.bits = 8;
                    break;
                }
                case 3: {
                    r.max = 1000L;
                    r.bits = 10;
                    break;
                }
                case 4: {
                    r.max = 10000L;
                    r.bits = 14;
                    break;
                }
                case 5: {
                    r.max = 100000L;
                    r.bits = 18;
                    break;
                }
                case 6: {
                    r.max = 1000000L;
                    r.bits = 20;
                    break;
                }
                case 7: {
                    r.max = 10000000L;
                    r.bits = 24;
                    break;
                }
                case 8: {
                    r.max = 100000000L;
                    r.bits = 28;
                    break;
                }
                case 9: {
                    r.max = 1000000000L;
                    r.bits = 30;
                    break;
                }
                case 10: {
                    r.max = 10000000000L;
                    r.bits = 34;
                    break;
                }
                case 11: {
                    r.max = 100000000000L;
                    r.bits = 38;
                    break;
                }
                case 12: {
                    r.max = 1000000000000L;
                    r.bits = 40;
                    break;
                }
                case 13: {
                    r.max = 10000000000000L;
                    r.bits = 44;
                    break;
                }
                case 14: {
                    r.max = 100000000000000L;
                    r.bits = 48;
                    break;
                }
                case 15: {
                    r.max = 1000000000000000L;
                    r.bits = 50;
                    break;
                }
                case 16: {
                    r.max = 10000000000000000L;
                    r.bits = 54;
                    break;
                }
                case 17: {
                    r.max = 100000000000000000L;
                    r.bits = 58;
                    break;
                }
                case 18: {
                    r.max = 1000000000000000000L;
                    r.bits = 60;
                    break;
                }
                default: {
                    return null;
                }
            }
            r.mask = (1L << r.bits) - 1L;
            return r;
        }

        private static char[] unrank(long in, char[] format, int len) {
            assert (len >= 12 && len <= 19);
            if (len != format.length) {
                return null;
            }
            char[] out = new char[len];
            for (int i = len - 2; i >= 0; --i) {
                if (format[i] == '#') {
                    out[i] = (char)(in % 10L + 48L);
                    in /= 10L;
                    continue;
                }
                out[i] = format[i];
            }
            out[len - 1] = (char)(CreditCard.lunhCheckSum(out, 0, len - 1) + 48);
            if (format[len - 1] != '#' && format[len - 1] != out[len - 1]) {
                return null;
            }
            return out;
        }

        public static String encrypt(byte[] key, String plain, String format) {
            char[] temp;
            Rank rank;
            char[] f;
            char[] in = plain.toCharArray();
            char[] input = FPE.digitsOnly(in, false);
            char[] cArray = f = format == null ? null : FPE.digitsOnly(format.toCharArray(), true);
            if (f == null || f.length == 0) {
                f = new char[input.length];
                for (int i = 0; i < f.length; ++i) {
                    f[i] = 35;
                }
            }
            if ((rank = CreditCard.rank(in, f)) == null) {
                return null;
            }
            boolean checkLunh = format != null && format.length() > 0 && format.charAt(format.length() - 1) != '#';
            long v = rank.value;
            byte[] v_buf = new byte[8];
            byte[] enc = new byte[8];
            AES aes = new AES(key);
            do {
                Converter.setLE8(v_buf, 0, v);
                FPE.aesFeistelEncrypt(aes, v_buf, enc, rank.bits);
            } while ((v = Converter.getLE8(enc, 0) & rank.mask) >= rank.max || checkLunh && (temp = CreditCard.unrank(v, f, in.length)) == null);
            char[] out = CreditCard.unrank(v, f, in.length);
            if (out == null) {
                return null;
            }
            if (format != null && format.length() > 0) {
                out = FPE.applyFormat(out, format.toCharArray());
            }
            if (out == null) {
                return null;
            }
            return new String(out);
        }

        public static String decrypt(byte[] key, String enc, String format) {
            char[] temp;
            Rank rank;
            char[] f;
            char[] in = enc.toCharArray();
            char[] input = FPE.digitsOnly(in, false);
            char[] cArray = f = format == null ? null : FPE.digitsOnly(format.toCharArray(), true);
            if (f == null || f.length == 0) {
                f = new char[input.length];
                for (int i = 0; i < f.length; ++i) {
                    f[i] = 35;
                }
            }
            if ((rank = CreditCard.rank(in, f)) == null) {
                return null;
            }
            boolean checkLunh = format != null && format.length() > 0 && format.charAt(format.length() - 1) != '#';
            long v = rank.value;
            byte[] v_buf = new byte[8];
            byte[] dec = new byte[8];
            AES aes = new AES(key);
            do {
                Converter.setLE8(v_buf, 0, v);
                FPE.aesFeistelDecrypt(aes, v_buf, dec, rank.bits);
            } while ((v = Converter.getLE8(dec, 0) & rank.mask) >= rank.max || checkLunh && (temp = CreditCard.unrank(v, f, in.length)) == null);
            char[] out = CreditCard.unrank(v, f, in.length);
            if (out == null) {
                return null;
            }
            if (format != null && format.length() > 0) {
                out = FPE.applyFormat(out, format.toCharArray());
            }
            if (out == null) {
                return null;
            }
            return new String(out);
        }

        private static final class Rank {
            long value;
            long mask;
            long max;
            int bits;
            char[] format;

            private Rank() {
            }
        }
    }

    public static final class SSN {
        private static char[] f1 = "#########".toCharArray();
        private static char[] f2 = "#####????".toCharArray();

        private static Rank rank(char[] in, char[] format) {
            if (9 != in.length) {
                return null;
            }
            if (9 != format.length) {
                return null;
            }
            Rank r = new Rank();
            r.format = (char[])format.clone();
            int aaa = 0;
            int bb = 0;
            int cccc = 0;
            int n_digits = 0;
            boolean use_cccc = true;
            if (Arrays.equals(format, f1)) {
                r.bits = 30;
                r.max = 888931098;
            } else if (Arrays.equals(format, f2)) {
                use_cccc = false;
                r.bits = 18;
                r.max = 88902;
            } else {
                return null;
            }
            for (int i = 0; i < 9; ++i) {
                char c = format[i];
                if (c == '#') {
                    int d = in[i] - 48;
                    if (++n_digits <= 3) {
                        aaa *= 10;
                        aaa += d;
                        continue;
                    }
                    if (n_digits <= 5) {
                        bb *= 10;
                        bb += d;
                        continue;
                    }
                    if (n_digits <= 9) {
                        cccc *= 10;
                        cccc += d;
                        continue;
                    }
                    return null;
                }
                r.format[i] = in[i];
            }
            if (aaa == 0 || bb == 0 || aaa == 666 || aaa >= 900) {
                return null;
            }
            if (aaa > 666) {
                --aaa;
            }
            --aaa;
            --bb;
            aaa *= 99;
            if (use_cccc) {
                if (--cccc == 0) {
                    return null;
                }
                aaa *= 9999;
                bb *= 9999;
            }
            r.value = aaa + bb + cccc;
            return r;
        }

        static char[] unrank(int in, char[] format) {
            if (9 != format.length) {
                return null;
            }
            boolean use_cccc = format[8] == '#';
            int aaa = use_cccc ? in / 989901 : in / 99;
            int bb = use_cccc ? in % 989901 / 9999 : in % 99;
            int cccc = in % 9999;
            ++bb;
            ++cccc;
            if (++aaa >= 666) {
                ++aaa;
            }
            char[] out = new char[9];
            int n_digit = 0;
            for (int i = 0; i < 9; ++i) {
                char c = format[i];
                if (c == '#') {
                    int d = 0;
                    switch (++n_digit) {
                        case 1: {
                            d = aaa / 100;
                            break;
                        }
                        case 2: {
                            d = aaa % 100 / 10;
                            break;
                        }
                        case 3: {
                            d = aaa % 10;
                            break;
                        }
                        case 4: {
                            d = bb / 10;
                            break;
                        }
                        case 5: {
                            d = bb % 10;
                            break;
                        }
                        case 6: {
                            d = cccc / 1000;
                            break;
                        }
                        case 7: {
                            d = cccc % 1000 / 100;
                            break;
                        }
                        case 8: {
                            d = cccc % 100 / 10;
                            break;
                        }
                        case 9: {
                            d = cccc % 10;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    c = (char)(48 + d);
                }
                out[i] = c;
            }
            return out;
        }

        public static String encrypt(byte[] key, String plain, String format) {
            Rank r;
            char[] f;
            char[] in = plain.toCharArray();
            char[] input = FPE.digitsOnly(in, false);
            char[] cArray = f = format == null ? null : FPE.digitsOnly(format.toCharArray(), true);
            if (f == null || f.length == 0) {
                f = new char[input.length];
                for (int i = 0; i < f.length; ++i) {
                    f[i] = 35;
                }
            }
            if ((r = SSN.rank(input, f)) == null) {
                return null;
            }
            assert (r.value < r.max);
            int mask = (1 << r.bits) - 1;
            int v = r.value;
            byte[] v_buf = new byte[8];
            byte[] enc = new byte[8];
            AES aes = new AES(key);
            do {
                Converter.setLE4(v_buf, 0, v);
                FPE.aesFeistelEncrypt(aes, v_buf, enc, r.bits);
            } while ((v = Converter.getLE4(enc, 0) & mask) >= r.max);
            char[] out = SSN.unrank(v, r.format);
            if (out == null) {
                return null;
            }
            if (format != null && format.length() > 0) {
                out = FPE.applyFormat(out, format.toCharArray());
            }
            if (out == null) {
                return null;
            }
            return new String(out);
        }

        public static String decrypt(byte[] key, String enc, String format) {
            Rank r;
            char[] f;
            char[] in = enc.toCharArray();
            char[] input = FPE.digitsOnly(in, false);
            char[] cArray = f = format == null ? null : FPE.digitsOnly(format.toCharArray(), true);
            if (f == null || f.length == 0) {
                f = new char[input.length];
                for (int i = 0; i < f.length; ++i) {
                    f[i] = 35;
                }
            }
            if ((r = SSN.rank(input, f)) == null) {
                return null;
            }
            assert (r.value < r.max);
            int mask = (1 << r.bits) - 1;
            int v = r.value;
            byte[] v_buf = new byte[8];
            byte[] dec = new byte[8];
            AES aes = new AES(key);
            do {
                Converter.setLE4(v_buf, 0, v);
                FPE.aesFeistelDecrypt(aes, v_buf, dec, r.bits);
            } while ((v = Converter.getLE4(dec, 0) & mask) >= r.max);
            char[] out = SSN.unrank(v, r.format);
            if (out == null) {
                return null;
            }
            if (format != null && format.length() > 0) {
                out = FPE.applyFormat(out, format.toCharArray());
            }
            if (out == null) {
                return null;
            }
            return new String(out);
        }

        private static final class Rank {
            int value;
            int max;
            int bits;
            char[] format;

            private Rank() {
            }
        }
    }

    public static final class USPhone {
        private static char[] defaultFormat = "###-###-####".toCharArray();

        private static long rank(char[] in) {
            int aaa = 0;
            int b = 0;
            int cc = 0;
            int dddd = 0;
            int n_digits = 0;
            for (int i = 0; i < in.length; ++i) {
                char c = in[i];
                if (c >= '0' && c <= '9') {
                    int d = c - 48;
                    if (++n_digits <= 3) {
                        aaa = aaa * 10 + d;
                        continue;
                    }
                    if (n_digits == 4) {
                        b = d;
                        continue;
                    }
                    if (n_digits <= 6) {
                        cc = cc * 10 + d;
                        continue;
                    }
                    if (n_digits <= 10) {
                        dddd = dddd * 10 + d;
                        continue;
                    }
                    return -1L;
                }
                if (c == ' ' || c == '-' || c == '.' || c == ':' || c == '/' || c == '(' || c == ')' || c == '+') continue;
                return -1L;
            }
            if (n_digits != 10) {
                return -1L;
            }
            if (aaa < 200) {
                return -1L;
            }
            aaa -= 200;
            if (b < 2) {
                return -1L;
            }
            b -= 2;
            if (cc == 11) {
                return -1L;
            }
            if (cc > 11) {
                --cc;
            }
            return (long)aaa * 8L * 99L * 10000L + (long)b * 99L * 10000L + (long)cc * 10000L + (long)dddd;
        }

        private static char[] unrank(long in, char[] format) {
            int aaa = (int)(in / 7920000L);
            int b = (int)(in % 7920000L / 990000L);
            int cc = (int)(in % 990000L / 10000L);
            int dddd = (int)(in % 10000L);
            if (cc >= 11) {
                ++cc;
            }
            b += 2;
            aaa += 200;
            char[] f = format;
            if (f == null || f.length == 0) {
                f = defaultFormat;
            }
            char[] out = new char[f.length];
            int outIndex = 0;
            int n_digit = 0;
            for (int i = 0; i < f.length; ++i) {
                int d;
                char c = f[i];
                if (c != '#') {
                    out[outIndex++] = c;
                    continue;
                }
                switch (++n_digit) {
                    case 1: {
                        d = aaa / 100;
                        break;
                    }
                    case 2: {
                        d = aaa % 100 / 10;
                        break;
                    }
                    case 3: {
                        d = aaa % 10;
                        break;
                    }
                    case 4: {
                        d = b;
                        break;
                    }
                    case 5: {
                        d = cc / 10;
                        break;
                    }
                    case 6: {
                        d = cc % 10;
                        break;
                    }
                    case 7: {
                        d = dddd / 1000;
                        break;
                    }
                    case 8: {
                        d = dddd % 1000 / 100;
                        break;
                    }
                    case 9: {
                        d = dddd % 100 / 10;
                        break;
                    }
                    case 10: {
                        d = (int)(in % 10L);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                out[outIndex++] = (char)(48 + d);
            }
            if (n_digit != 10) {
                return null;
            }
            return out;
        }

        public static String encrypt(byte[] key, String plain, String format) {
            long v = USPhone.rank(plain.toCharArray());
            if (v < 0L) {
                return null;
            }
            assert (v < 6336000000L);
            byte[] v_buf = new byte[8];
            byte[] enc = new byte[8];
            AES aes = new AES(key);
            do {
                Converter.setLE8(v_buf, 0, v);
                FPE.aesFeistelEncrypt(aes, v_buf, enc, 34);
            } while ((v = Converter.getLE8(enc, 0) & 0x3FFFFFFFFL) >= 6336000000L);
            char[] out = USPhone.unrank(v, format.toCharArray());
            if (out == null) {
                return null;
            }
            return new String(out);
        }

        public static String decrypt(byte[] key, String enc, String format) {
            long v = USPhone.rank(enc.toCharArray());
            if (v < 0L) {
                return null;
            }
            assert (v < 6336000000L);
            byte[] v_buf = new byte[8];
            byte[] dec = new byte[8];
            AES aes = new AES(key);
            do {
                Converter.setLE8(v_buf, 0, v);
                FPE.aesFeistelDecrypt(aes, v_buf, dec, 34);
            } while ((v = Converter.getLE8(dec, 0) & 0x3FFFFFFFFL) >= 6336000000L);
            char[] out = USPhone.unrank(v, format.toCharArray());
            if (out == null) {
                return null;
            }
            return new String(out);
        }
    }
}

