/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.Base64;
import com.unbound.common.STR;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Scanner;

public class PEM {
    private Scanner reader;
    private StringBuilder writer;
    public static final int X509 = 1;
    public static final int PUBLIC_KEY = 2;
    public static final int RSA_PRIVATE_KEY = 3;
    public static final int RSA_PUBLIC_KEY = 4;
    public static final int PKCS8 = 5;
    public static final int PKCS8INF = 6;
    public static final int EC_PRIVATE_KEY = 7;
    public static final int PKCS10 = 8;
    private static final String PEM_STRING_X509_OLD = "X509 CERTIFICATE";
    private static final String PEM_STRING_X509 = "CERTIFICATE";
    private static final String PEM_STRING_X509_TRUSTED = "TRUSTED CERTIFICATE";
    private static final String PEM_STRING_PUBLIC = "PUBLIC KEY";
    private static final String PEM_STRING_RSA_PRIVATE_KEY = "RSA PRIVATE KEY";
    private static final String PEM_STRING_RSA_PUBLIC_KEY = "RSA PUBLIC KEY";
    private static final String PEM_STRING_PKCS8 = "ENCRYPTED PRIVATE KEY";
    private static final String PEM_STRING_PKCS8INF = "PRIVATE KEY";
    private static final String PEM_STRING_EC_PRIVATE_KEY = "EC PRIVATE KEY";
    private static final String PEM_STRING_X509_REQ = "CERTIFICATE REQUEST";

    private static String headerString(int code) {
        switch (code) {
            case 1: {
                return PEM_STRING_X509;
            }
            case 2: {
                return PEM_STRING_PUBLIC;
            }
            case 3: {
                return PEM_STRING_RSA_PRIVATE_KEY;
            }
            case 4: {
                return PEM_STRING_RSA_PUBLIC_KEY;
            }
            case 5: {
                return PEM_STRING_PKCS8;
            }
            case 6: {
                return PEM_STRING_PKCS8INF;
            }
            case 7: {
                return PEM_STRING_EC_PRIVATE_KEY;
            }
            case 8: {
                return PEM_STRING_X509_REQ;
            }
        }
        return null;
    }

    private int headerCode(String header) {
        if (header.equals(PEM_STRING_X509_OLD) || header.equals(PEM_STRING_X509) || header.equals(PEM_STRING_X509_TRUSTED)) {
            return 1;
        }
        if (header.equals(PEM_STRING_PUBLIC)) {
            return 2;
        }
        if (header.equals(PEM_STRING_RSA_PRIVATE_KEY)) {
            return 3;
        }
        if (header.equals(PEM_STRING_RSA_PUBLIC_KEY)) {
            return 4;
        }
        if (header.equals(PEM_STRING_PKCS8)) {
            return 5;
        }
        if (header.equals(PEM_STRING_PKCS8INF)) {
            return 6;
        }
        if (header.equals(PEM_STRING_EC_PRIVATE_KEY)) {
            return 7;
        }
        if (header.equals(PEM_STRING_X509_REQ)) {
            return 8;
        }
        throw new IllegalArgumentException("PEM header parser error");
    }

    public PEM(byte[] in) {
        String s = STR.utf8(in);
        this.reader = new Scanner(new ByteArrayInputStream(in));
    }

    public PEM() {
        this.writer = new StringBuilder();
    }

    public PEM append(int code, byte[] in) throws IOException {
        String header = PEM.headerString(code);
        this.writer.append("-----BEGIN ");
        this.writer.append(header);
        this.writer.append("-----\n");
        this.writer.append(Base64.encode(in, true));
        this.writer.append("-----END ");
        this.writer.append(header);
        this.writer.append("-----\n");
        return this;
    }

    public static byte[] create(int code, byte[] in) throws IOException {
        return new PEM().append(code, in).end();
    }

    byte[] end() {
        return STR.utf8(this.writer.toString());
    }

    public byte[] getNext() {
        String s;
        StringBuilder sb = new StringBuilder();
        while (!(s = this.reader.nextLine().trim()).startsWith("-----END ") || !s.endsWith("-----")) {
            sb.append(s);
        }
        return Base64.decode(sb.toString());
    }

    public int getNextHeader() {
        String header = "";
        while (header.isEmpty()) {
            header = this.reader.nextLine().trim();
        }
        if (header.startsWith("-----BEGIN ") && header.endsWith("-----")) {
            header = header.substring(11, header.length() - 5);
            return this.headerCode(header);
        }
        throw new IllegalArgumentException("PEM header parser error");
    }

    public static byte[] get(int code, byte[] in) {
        PEM pem = new PEM(in);
        if (code != pem.getNextHeader()) {
            throw new IllegalArgumentException("PEM header parser error");
        }
        return pem.getNext();
    }
}

