/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.crypto.DER;
import com.unbound.common.crypto.SystemProvider;
import com.unbound.common.crypto.X509;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public class PKCS10 {
    private PublicKey publicKey;
    private String[] dns;
    private InetAddress[] ip;
    private String challengePassword;
    private byte[] signature;
    private String signHashOid;
    private Map<String, String> subject = new HashMap<String, String>();

    public PKCS10(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PKCS10(byte[] der) throws InvalidKeySpecException, UnknownHostException {
        DER.Parser parser = new DER.Parser(der);
        parser.beginSequence();
        parser.beginSequence();
        parser.getBigInteger();
        parser.beginSequence();
        do {
            parser.beginSet();
            parser.beginSequence();
            String oid = parser.getOid();
            String value = parser.getString();
            this.subject.put(X509.getRdnFromOid(oid), value);
            parser.end();
            parser.end();
        } while (!parser.endOfBlock());
        parser.end();
        byte[] publicKeyEncoded = parser.getFullTag();
        if (parser.isTag((byte)-96)) {
            parser.begin((byte)-96);
            parser.beginSequence();
            parser.checkOid("1.2.840.113549.1.9.14");
            parser.beginSet();
            parser.beginSequence();
            parser.beginSequence();
            parser.checkOid("2.5.29.17");
            parser.beginOctetString();
            parser.beginSequence();
            ArrayList<String> dnsList = new ArrayList<String>();
            while (parser.isTag((byte)-126)) {
                dnsList.add(parser.getString((byte)-126));
            }
            if (!dnsList.isEmpty()) {
                this.dns = new String[dnsList.size()];
                dnsList.toArray(this.dns);
            }
            ArrayList<InetAddress> ipList = new ArrayList<InetAddress>();
            while (parser.isTag((byte)-121)) {
                ipList.add(InetAddress.getByAddress(parser.getTagBytes((byte)-121)));
            }
            if (!ipList.isEmpty()) {
                this.ip = new InetAddress[ipList.size()];
                ipList.toArray(this.ip);
            }
            parser.end();
            parser.end();
            parser.end();
            parser.end();
            parser.end();
            parser.end();
            if (parser.isTag((byte)48)) {
                parser.beginSequence();
                parser.checkOid("1.2.840.113549.1.9.7");
                parser.beginSet();
                this.challengePassword = parser.getString();
                parser.end();
                parser.end();
            }
            parser.end();
        }
        parser.end();
        parser.beginSequence();
        this.signHashOid = parser.getOid();
        parser.skipNull();
        parser.end();
        this.signature = parser.getBitString();
        parser.end();
        X509EncodedKeySpec spec = new X509EncodedKeySpec(publicKeyEncoded);
        KeyFactory kf = SystemProvider.KeyFactory.getInstance("RSA");
        try {
            this.publicKey = kf.generatePublic(spec);
        }
        catch (InvalidKeySpecException e) {
            kf = SystemProvider.KeyFactory.getInstance("ECDSA");
            this.publicKey = kf.generatePublic(spec);
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X500Principal getSubject() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.subject.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        return new X500Principal(sb.toString());
    }

    public void verifySignature() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String sigName;
        if (this.publicKey.getAlgorithm().equalsIgnoreCase("RSA")) {
            String hashType;
            if (this.signHashOid.equalsIgnoreCase(X509.OID_RSA_WITH_SHA256)) {
                hashType = "SHA256";
            } else if (this.signHashOid.equalsIgnoreCase(X509.OID_RSA_WITH_SHA1)) {
                hashType = "SHA1";
            } else {
                throw new IllegalArgumentException("Unsupported hash type");
            }
            sigName = hashType + "withRSA";
        } else {
            String hashType;
            if (this.signHashOid.equalsIgnoreCase(X509.OID_ECDSA_WITH_SHA256)) {
                hashType = "SHA256";
            } else if (this.signHashOid.equalsIgnoreCase(X509.OID_ECDSA_WITH_SHA1)) {
                hashType = "SHA1";
            } else {
                throw new IllegalArgumentException("Unsupported hash type");
            }
            sigName = hashType + "withECDSA";
        }
        Signature sig = Signature.getInstance(sigName);
        sig.initVerify(this.publicKey);
        sig.update(this.toBeSigned());
        boolean ok = sig.verify(this.signature);
        if (!ok) {
            throw new SignatureException("Verification failed");
        }
    }

    public void setAlternativeSubjectName(String[] dns, InetAddress[] ip) {
        this.dns = dns;
        this.ip = ip;
    }

    public void setSubjectName(String type, String name) {
        this.subject.put(type, name);
    }

    public void setChallengePassword(String challengePassword) {
        this.challengePassword = challengePassword;
    }

    public void sign(PrivateKey key, String hashType) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String sigName;
        if (key.getAlgorithm().equalsIgnoreCase("RSA")) {
            if (hashType.equals("SHA256")) {
                this.signHashOid = X509.OID_RSA_WITH_SHA256;
            } else if (hashType.equals("SHA1")) {
                this.signHashOid = X509.OID_RSA_WITH_SHA1;
            } else {
                throw new IllegalArgumentException("Unsupported hash type");
            }
            sigName = hashType + "withRSA";
        } else {
            if (hashType.equals("SHA256")) {
                this.signHashOid = X509.OID_ECDSA_WITH_SHA256;
            } else if (hashType.equals("SHA1")) {
                this.signHashOid = X509.OID_ECDSA_WITH_SHA1;
            } else {
                throw new IllegalArgumentException("Unsupported hash type");
            }
            sigName = hashType + "withECDSA";
        }
        Signature sig = Signature.getInstance(sigName);
        sig.initSign(key);
        sig.update(this.toBeSigned());
        this.signature = sig.sign();
    }

    private DER.Builder encodeCertificationRequestInfo(DER.Builder builder) {
        builder.beginSequence().addInteger(0L);
        X509.encode(builder, this.subject).add(this.publicKey.getEncoded());
        if (this.challengePassword != null || this.dns != null || this.ip != null) {
            builder.begin((byte)-96);
            if (this.dns != null || this.ip != null) {
                builder.beginSequence().addOid("1.2.840.113549.1.9.14").beginSet().beginSequence().beginSequence().addOid("2.5.29.17").beginOctetString().beginSequence();
                if (this.dns != null) {
                    for (String s : this.dns) {
                        builder.add((byte)-126, s);
                    }
                }
                if (this.ip != null) {
                    for (InetAddress i : this.ip) {
                        builder.add((byte)-121, i.getAddress());
                    }
                }
                builder.end().end().end().end().end().end();
            }
            if (this.challengePassword != null) {
                builder.beginSequence().addOid("1.2.840.113549.1.9.7").beginSet().add((byte)19, this.challengePassword).end().end();
            }
            builder.end();
        }
        return builder.end();
    }

    private byte[] toBeSigned() {
        return this.encodeCertificationRequestInfo(new DER.Builder()).toByteArray();
    }

    public byte[] exportDer() {
        DER.Builder builder = new DER.Builder();
        builder.beginSequence();
        this.encodeCertificationRequestInfo(builder).beginSequence().addOid(this.signHashOid).addNull().end().addBitString(this.signature).end();
        return builder.toByteArray();
    }
}

