/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import java.util.Arrays;

public class SHA3 {
    public static final byte NIST_PADDING = 6;
    public static final byte KECCAK_PADDING = 1;
    private long[] state = new long[25];
    private byte[] buf = new byte[200];
    private int offset = 0;
    private static final long[] rc = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};

    public void begin() {
        this.offset = 0;
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = 0;
        }
    }

    public void update(byte[] data) {
        this.update(data, 0, data.length);
    }

    public void update(byte[] data, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            this.update(data[offset + i]);
        }
    }

    public void update(byte b) {
        int n = this.offset++;
        this.buf[n] = (byte)(this.buf[n] ^ b);
        if (this.offset == 136) {
            this.transform();
        }
    }

    public byte[] end(byte padding) {
        int n = this.offset;
        this.buf[n] = (byte)(this.buf[n] ^ padding);
        this.buf[135] = (byte)(this.buf[135] ^ 0x80);
        this.transform();
        return Arrays.copyOfRange(this.buf, 0, 32);
    }

    public static byte[] sha3_256(byte[] data, byte padding) {
        return SHA3.calculate(data, padding);
    }

    public static byte[] calculate(byte[] data, byte padding) {
        SHA3 context = new SHA3();
        context.begin();
        context.update(data);
        return context.end(padding);
    }

    private void transform() {
        int i;
        for (i = 0; i < 25; ++i) {
            this.state[i] = (long)this.buf[i * 8 + 0] & 0xFFL | ((long)this.buf[i * 8 + 1] & 0xFFL) << 8 | ((long)this.buf[i * 8 + 2] & 0xFFL) << 16 | ((long)this.buf[i * 8 + 3] & 0xFFL) << 24 | ((long)this.buf[i * 8 + 4] & 0xFFL) << 32 | ((long)this.buf[i * 8 + 5] & 0xFFL) << 40 | ((long)this.buf[i * 8 + 6] & 0xFFL) << 48 | ((long)this.buf[i * 8 + 7] & 0xFFL) << 56;
        }
        SHA3.keccak(this.state);
        for (i = 0; i < 25; ++i) {
            this.buf[i * 8 + 0] = (byte)this.state[i];
            this.buf[i * 8 + 1] = (byte)(this.state[i] >> 8);
            this.buf[i * 8 + 2] = (byte)(this.state[i] >> 16);
            this.buf[i * 8 + 3] = (byte)(this.state[i] >> 24);
            this.buf[i * 8 + 4] = (byte)(this.state[i] >> 32);
            this.buf[i * 8 + 5] = (byte)(this.state[i] >> 40);
            this.buf[i * 8 + 6] = (byte)(this.state[i] >> 48);
            this.buf[i * 8 + 7] = (byte)(this.state[i] >> 56);
        }
        this.offset = 0;
    }

    private static void keccak(long[] a) {
        for (int i = 0; i < 24; ++i) {
            long c0 = a[0] ^ a[5] ^ a[10] ^ a[15] ^ a[20];
            long c1 = a[1] ^ a[6] ^ a[11] ^ a[16] ^ a[21];
            long c2 = a[2] ^ a[7] ^ a[12] ^ a[17] ^ a[22];
            long c3 = a[3] ^ a[8] ^ a[13] ^ a[18] ^ a[23];
            long c4 = a[4] ^ a[9] ^ a[14] ^ a[19] ^ a[24];
            long t0 = c0 << 1 ^ c0 >>> 63 ^ c3;
            long t1 = c1 << 1 ^ c1 >>> 63 ^ c4;
            long t2 = c2 << 1 ^ c2 >>> 63 ^ c0;
            long t3 = c3 << 1 ^ c3 >>> 63 ^ c1;
            long t4 = c4 << 1 ^ c4 >>> 63 ^ c2;
            a[0] = a[0] ^ t1;
            long x = a[1] ^ t2;
            long a_10_ = x << 1 | x >>> 63;
            x = a[6] ^ t2;
            a[1] = x << 44 | x >>> 20;
            x = a[9] ^ t0;
            a[6] = x << 20 | x >>> 44;
            x = a[22] ^ t3;
            a[9] = x << 61 | x >>> 3;
            x = a[14] ^ t0;
            a[22] = x << 39 | x >>> 25;
            x = a[20] ^ t1;
            a[14] = x << 18 | x >>> 46;
            x = a[2] ^ t3;
            a[20] = x << 62 | x >>> 2;
            x = a[12] ^ t3;
            a[2] = x << 43 | x >>> 21;
            x = a[13] ^ t4;
            a[12] = x << 25 | x >>> 39;
            x = a[19] ^ t0;
            a[13] = x << 8 | x >>> 56;
            x = a[23] ^ t4;
            a[19] = x << 56 | x >>> 8;
            x = a[15] ^ t1;
            a[23] = x << 41 | x >>> 23;
            x = a[4] ^ t0;
            a[15] = x << 27 | x >>> 37;
            x = a[24] ^ t0;
            a[4] = x << 14 | x >>> 50;
            x = a[21] ^ t2;
            a[24] = x << 2 | x >>> 62;
            x = a[8] ^ t4;
            a[21] = x << 55 | x >>> 9;
            x = a[16] ^ t2;
            a[8] = x << 45 | x >>> 19;
            x = a[5] ^ t1;
            a[16] = x << 36 | x >>> 28;
            x = a[3] ^ t4;
            a[5] = x << 28 | x >>> 36;
            x = a[18] ^ t4;
            a[3] = x << 21 | x >>> 43;
            x = a[17] ^ t3;
            a[18] = x << 15 | x >>> 49;
            x = a[11] ^ t2;
            a[17] = x << 10 | x >>> 54;
            x = a[7] ^ t3;
            a[11] = x << 6 | x >>> 58;
            x = a[10] ^ t1;
            a[7] = x << 3 | x >>> 61;
            a[10] = a_10_;
            for (int c = 0; c < 25; c += 5) {
                long x0 = a[c + 0];
                long x1 = a[c + 1];
                long x2 = a[c + 2];
                long x3 = a[c + 3];
                long x4 = a[c + 4];
                a[c + 0] = x0 ^ (x1 ^ 0xFFFFFFFFFFFFFFFFL) & x2;
                a[c + 1] = x1 ^ (x2 ^ 0xFFFFFFFFFFFFFFFFL) & x3;
                a[c + 2] = x2 ^ (x3 ^ 0xFFFFFFFFFFFFFFFFL) & x4;
                a[c + 3] = x3 ^ (x4 ^ 0xFFFFFFFFFFFFFFFFL) & x0;
                a[c + 4] = x4 ^ (x0 ^ 0xFFFFFFFFFFFFFFFFL) & x1;
            }
            a[0] = a[0] ^ rc[i];
        }
    }
}

