/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.crypto.AES;
import com.unbound.common.crypto.FPE;

public class SPE {
    private static final int SPE_NONE = 0;
    private static final int SPE_BIT = 1;
    private static final int SPE_FEISTEL = 2;
    private static final int SPE_XTS = 3;

    private static int getMode(int inSize, int bits) {
        if (bits == 0) {
            bits = inSize * 8;
        }
        if (bits == 1) {
            return 1;
        }
        if (inSize <= 16) {
            if ((bits & 1) != 0) {
                return 0;
            }
            return 2;
        }
        if ((bits & 7) != 0) {
            return 0;
        }
        return 3;
    }

    public static byte[] encrypt(byte[] key, byte[] in, int bits) {
        int mode;
        if (bits <= 0) {
            bits = in.length * 8;
        }
        if ((mode = SPE.getMode(in.length, bits)) == 0) {
            throw new IllegalArgumentException("Illegal data size for SPE");
        }
        if (mode == 1) {
            byte[] out = new byte[]{(byte)((in[0] ^ key[0]) & 1)};
            return out;
        }
        if (mode == 2) {
            byte[] out = new byte[in.length];
            FPE.aesFeistelEncrypt(new AES(key), in, out, bits);
            return out;
        }
        return AES.XTS.encrypt(key, in);
    }

    public static byte[] decrypt(byte[] key, byte[] in, int bits) {
        int mode;
        if (bits <= 0) {
            bits = in.length * 8;
        }
        if ((mode = SPE.getMode(in.length, bits)) == 0) {
            throw new IllegalArgumentException("Illegal data size for SPE");
        }
        if (mode == 1) {
            byte[] out = new byte[]{(byte)((in[0] ^ key[0]) & 1)};
            return out;
        }
        if (mode == 2) {
            byte[] out = new byte[in.length];
            FPE.aesFeistelDecrypt(new AES(key), in, out, bits);
            return out;
        }
        return AES.XTS.decrypt(key, in);
    }
}

