/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.crypto.DER;
import com.unbound.common.crypto.PKCS10;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public final class X509 {
    public static String OID_RSA_WITH_SHA1 = "1.2.840.113549.1.1.5";
    public static String OID_RSA_WITH_SHA256 = "1.2.840.113549.1.1.11";
    public static String OID_RSA_ENCRYPTION = "1.2.840.113549.1.1.1";
    public static String OID_ECDSA_WITH_SHA1 = "1.2.840.10045.4.1";
    public static String OID_ECDSA_WITH_SHA256 = "1.2.840.10045.4.3.2";
    public static String OID_ECC = "1.2.840.10045.2.1";

    private X509() {
    }

    public static X509Certificate get(byte[] value) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(value));
    }

    public static String getOidFromRdn(String type) {
        if (type.equals("CN")) {
            return "2.5.4.3";
        }
        if (type.equals("SN")) {
            return "2.5.4.4";
        }
        if (type.equals("SERIALNUMBER")) {
            return "2.5.4.5";
        }
        if (type.equals("C")) {
            return "2.5.4.6";
        }
        if (type.equals("L")) {
            return "2.5.4.7";
        }
        if (type.equals("ST") | type.equals("SP") | type.equals("S")) {
            return "2.5.4.8";
        }
        if (type.equals("STREET")) {
            return "2.5.4.9";
        }
        if (type.equals("O")) {
            return "2.5.4.10";
        }
        if (type.equals("OU")) {
            return "2.5.4.11";
        }
        if (type.equals("T") | type.equals("TITLE")) {
            return "2.5.4.12";
        }
        if (type.equals("G") | type.equals("GN")) {
            return "2.5.4.42";
        }
        if (type.equals("E") | type.equals("MAIL")) {
            return "1.2.840.113549.1.9.1";
        }
        if (type.equals("UNSTRUCTUREDNAME")) {
            return "1.2.840.113549.1.9.2";
        }
        if (type.equals("UNSTRUCTUREDADDRESS")) {
            return "1.2.840.113549.1.9.8";
        }
        if (type.equals("UID")) {
            return "0.9.2342.19200300.100.1.1";
        }
        if (type.equals("DC")) {
            return "0.9.2342.19200300.100.1.25";
        }
        return null;
    }

    public static String getRdnFromOid(String type) {
        if (type.equals("2.5.4.3")) {
            return "CN";
        }
        if (type.equals("2.5.4.4")) {
            return "SN";
        }
        if (type.equals("2.5.4.5")) {
            return "SERIALNUMBER";
        }
        if (type.equals("2.5.4.6")) {
            return "C";
        }
        if (type.equals("2.5.4.7")) {
            return "L";
        }
        if (type.equals("2.5.4.8")) {
            return "ST";
        }
        if (type.equals("2.5.4.9")) {
            return "STREET";
        }
        if (type.equals("2.5.4.10")) {
            return "O";
        }
        if (type.equals("2.5.4.11")) {
            return "OU";
        }
        if (type.equals("2.5.4.12")) {
            return "TITLE";
        }
        if (type.equals("2.5.4.42")) {
            return "GN";
        }
        if (type.equals("1.2.840.113549.1.9.1")) {
            return "MAIL";
        }
        if (type.equals("1.2.840.113549.1.9.2")) {
            return "UNSTRUCTUREDNAME";
        }
        if (type.equals("1.2.840.113549.1.9.8")) {
            return "UNSTRUCTUREDADDRESS";
        }
        if (type.equals("0.9.2342.19200300.100.1.1")) {
            return "UID";
        }
        if (type.equals("0.9.2342.19200300.100.1.25")) {
            return "DC";
        }
        return null;
    }

    public static String getName(X500Principal principal, String type) {
        String rdnOid = X509.getOidFromRdn(type);
        DER.Parser parser = new DER.Parser(principal.getEncoded());
        parser.beginSequence();
        do {
            parser.beginSet();
            parser.beginSequence();
            String oid = parser.getOid();
            String value = parser.getString();
            if (oid.equals(type) || oid.equals(rdnOid)) {
                return value;
            }
            parser.end();
            parser.end();
        } while (!parser.endOfBlock());
        return null;
    }

    public static DER.Builder encode(DER.Builder builder, Map<String, String> map) {
        builder.beginSequence();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.beginSet().beginSequence().addOid(X509.getOidFromRdn(entry.getKey())).add(entry.getValue()).end().end();
        }
        return builder.end();
    }

    private static byte[] buildToBeSignedDER(PublicKey publicKey, X500Principal subject, X500Principal issuer, int days) {
        BigInteger sn;
        long startTime = System.currentTimeMillis() / 1000L;
        long endTime = startTime + (long)(days * 24 * 60 * 60);
        String oid = publicKey.getAlgorithm().equalsIgnoreCase("RSA") ? OID_RSA_WITH_SHA256 : OID_ECDSA_WITH_SHA256;
        try {
            sn = new BigInteger(128, SecureRandom.getInstanceStrong());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        return new DER.Builder().beginSequence().begin((byte)-96).addInteger(1L).end().add(sn).beginSequence().addOid(oid).addNull().end().add(issuer.getEncoded()).beginSequence().addTime(startTime).addTime(endTime).end().add(subject.getEncoded()).add(publicKey.getEncoded()).end().toByteArray();
    }

    private static byte[] buildCertDER(byte[] toBeSigned, PublicKey publicKey, byte[] sig) {
        String oid = publicKey.getAlgorithm().equalsIgnoreCase("RSA") ? OID_RSA_WITH_SHA256 : OID_ECDSA_WITH_SHA256;
        return new DER.Builder().beginSequence().add(toBeSigned).beginSequence().addOid(oid).addNull().end().add((byte)3, sig).end().toByteArray();
    }

    public static X509Certificate getSelfSignCertificate(PrivateKey privateKey, PublicKey publicKey, X500Principal subject, int days) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateException {
        byte[] toBeSigned = X509.buildToBeSignedDER(publicKey, subject, subject, days);
        String keyType = privateKey.getAlgorithm();
        String sigAlg = "SHA256With" + (keyType.equalsIgnoreCase("RSA") ? "RSA" : "ECDSA");
        Signature signature = Signature.getInstance(sigAlg);
        signature.initSign(privateKey);
        signature.update(toBeSigned);
        byte[] sig = signature.sign();
        byte[] certEncoded = X509.buildCertDER(toBeSigned, publicKey, sig);
        return X509.get(certEncoded);
    }

    public static X509Certificate signCertificate(PrivateKey privateKey, X509Certificate ca, PKCS10 csr, int days) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateException {
        csr.verifySignature();
        byte[] toBeSigned = X509.buildToBeSignedDER(csr.getPublicKey(), csr.getSubject(), ca.getSubjectX500Principal(), days);
        String keyType = privateKey.getAlgorithm();
        String sigAlg = "SHA256With" + (keyType.equalsIgnoreCase("RSA") ? "RSA" : "ECDSA");
        Signature signature = Signature.getInstance(sigAlg);
        signature.initSign(privateKey);
        signature.update(toBeSigned);
        byte[] sig = signature.sign();
        byte[] certEncoded = X509.buildCertDER(toBeSigned, ca.getPublicKey(), sig);
        return X509.get(certEncoded);
    }
}

