/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.crypto.EC;
import com.unbound.provider.UBECPrivateKey;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class ECDHKeyAgreement
extends KeyAgreementSpi {
    UBECPrivateKey prvKey;
    ECPoint pub;

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof UBECPrivateKey)) {
            throw new InvalidKeyException("Key must be instance of UBECPrivateKey");
        }
        this.prvKey = (UBECPrivateKey)key;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, null);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.prvKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (this.pub != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a ECPublicKey");
        }
        ECPublicKey pubKey = (ECPublicKey)key;
        EC.Curve curve = this.prvKey.getCurve();
        if (!pubKey.getParams().equals(curve.spec)) {
            throw new InvalidKeyException("EC curve doesn't match");
        }
        this.pub = pubKey.getW();
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.prvKey == null || this.pub == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        try {
            return this.prvKey.ecdh(this.pub);
        }
        catch (IOException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected int engineGenerateSecret(byte[] out, int outOffset) throws IllegalStateException, ShortBufferException {
        EC.Curve curve = this.prvKey.getCurve();
        int secretLen = curve.size;
        if (outOffset + secretLen > out.length) {
            throw new ShortBufferException("Need " + secretLen + " bytes, only " + (out.length - outOffset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, out, outOffset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!algorithm.equals("TlsPremasterSecret")) {
            throw new NoSuchAlgorithmException("Only supported for algorithm TlsPremasterSecret");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), "TlsPremasterSecret");
    }
}

