/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyGenSpec;
import com.dyadicsec.provider.KeyParameters;
import com.unbound.common.crypto.EC;
import com.unbound.provider.Partition;
import com.unbound.provider.UBECPrivateKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private Partition partition;
    private EC.Curve curve;
    private KeyParameters keyParameter = null;

    ECKeyPairGenerator(Partition partition) {
        this.partition = partition;
    }

    @Override
    public void initialize(int bitSize, SecureRandom random) {
        this.curve = EC.getCurveBySize(bitSize);
        if (this.curve == null) {
            throw new InvalidParameterException("Unsupported EC key size " + bitSize);
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        ECParameterSpec spec;
        if (params instanceof KeyGenSpec) {
            this.keyParameter = ((KeyGenSpec)params).getKeyParams();
            params = ((KeyGenSpec)params).getOriginal();
        } else {
            this.keyParameter = null;
        }
        if (params instanceof ECParameterSpec) {
            spec = (ECParameterSpec)params;
        } else if (params instanceof ECGenParameterSpec) {
            try {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                parameters.init(params);
                spec = parameters.getParameterSpec(ECParameterSpec.class);
            }
            catch (Exception e) {
                throw new InvalidAlgorithmParameterException("Unsupported EC curve", e);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        this.curve = EC.getCurve(spec);
        if (this.curve == null) {
            throw new InvalidAlgorithmParameterException("Unsupported EC curve");
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        UBECPrivateKey key;
        try {
            key = new UBECPrivateKey(this.partition);
            key.generate(this.keyParameter, 0, this.curve);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return new KeyPair(key.pub, key);
    }
}

