/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.crypto.SystemProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;

public class HashType {
    int bitsize;
    String name;
    String mdName;
    int kmipCode;
    int kmipRsaSignatureCode;
    int kmipEcdsaSignatureCode;
    static HashType SHA1 = new HashType("SHA1", "SHA-1", 160, 4, 3, 12);
    static HashType SHA256 = new HashType("SHA256", "SHA-256", 256, 6, 5, 14);
    static HashType SHA384 = new HashType("SHA384", "SHA-384", 384, 7, 6, 15);
    static HashType SHA512 = new HashType("SHA512", "SHA-512", 512, 8, 7, 16);

    private HashType(String name, String mdName, int bitsize, int kmipCode, int kmipRsaSignatureCode, int kmipEcdsaSignatureCode) {
        this.name = name;
        this.mdName = mdName;
        this.bitsize = bitsize;
        this.kmipCode = kmipCode;
        this.kmipRsaSignatureCode = kmipRsaSignatureCode;
        this.kmipEcdsaSignatureCode = kmipEcdsaSignatureCode;
    }

    MessageDigest getMessageDigest() {
        return SystemProvider.MessageDigest.getInstance(this.mdName);
    }

    static HashType getFromName(String name) throws InvalidAlgorithmParameterException {
        if (name.equalsIgnoreCase("SHA1")) {
            return SHA1;
        }
        if (name.equalsIgnoreCase("SHA-1")) {
            return SHA1;
        }
        if (name.equalsIgnoreCase("SHA256")) {
            return SHA256;
        }
        if (name.equalsIgnoreCase("SHA-256")) {
            return SHA256;
        }
        if (name.equalsIgnoreCase("SHA384")) {
            return SHA384;
        }
        if (name.equalsIgnoreCase("SHA-384")) {
            return SHA384;
        }
        if (name.equalsIgnoreCase("SHA512")) {
            return SHA512;
        }
        if (name.equalsIgnoreCase("SHA-512")) {
            return SHA512;
        }
        throw new InvalidAlgorithmParameterException("Unsupported hash algorithm");
    }
}

