/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyGenSpec;
import com.dyadicsec.provider.KeyParameters;
import com.unbound.common.crypto.SystemProvider;
import com.unbound.provider.UBRSAPrivateKey;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;

public final class RSACipher
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private KeyParameters unwrapKeyParameter = null;
    private UBRSAPrivateKey prvKey = null;
    private RSAPublicKey pubKey = null;
    private SecureRandom secureRandom = null;
    private OAEPParameterSpec oaepSpec = null;
    private byte[] buffer = new byte[512];
    private int bufferSize = 0;
    private int bufferOffset = 0;
    private int opmode = 0;
    private boolean isOaep = false;
    private boolean isRaw = false;
    private int oaepHashBitSize = 0;
    private int oaepMgfBitSize = 0;
    private byte[] oaepSource = null;

    private static MGF1ParameterSpec mgfBitSizeToSpec(int bitSize) throws InvalidAlgorithmParameterException {
        switch (bitSize) {
            case 160: {
                return MGF1ParameterSpec.SHA1;
            }
            case 256: {
                return MGF1ParameterSpec.SHA256;
            }
            case 384: {
                return MGF1ParameterSpec.SHA384;
            }
            case 512: {
                return MGF1ParameterSpec.SHA512;
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported OAEP MGF hash algorithm");
    }

    private static String hashBitSizeToName(int bitSize) throws InvalidAlgorithmParameterException {
        switch (bitSize) {
            case 160: {
                return "SHA-1";
            }
            case 256: {
                return "SHA-256";
            }
            case 384: {
                return "SHA-384";
            }
            case 512: {
                return "SHA-512";
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported OAEP hash algorithm");
    }

    private static int hashBitSizeToKmipHashAlg(int bitSize) {
        switch (bitSize) {
            case 160: {
                return 4;
            }
            case 256: {
                return 6;
            }
            case 384: {
                return 7;
            }
            case 512: {
                return 8;
            }
        }
        return 0;
    }

    private static String paddingTypeToName(boolean isRaw, boolean isOaep, int oaepHashBitSize) throws InvalidAlgorithmParameterException {
        if (isRaw) {
            return "NOPadding";
        }
        if (!isOaep) {
            return "PKCS1Padding";
        }
        return "OAEPWith" + RSACipher.hashBitSizeToName(oaepHashBitSize) + "AndMGF1Padding";
    }

    private static int hashNameToBitSize(String hashName) throws InvalidAlgorithmParameterException {
        if ((hashName = hashName.toUpperCase()).equals("SHA1")) {
            return 160;
        }
        if (hashName.equals("SHA-1")) {
            return 160;
        }
        if (hashName.equals("SHA-256")) {
            return 256;
        }
        if (hashName.equals("SHA-384")) {
            return 384;
        }
        if (hashName.equals("SHA-512")) {
            return 512;
        }
        throw new InvalidAlgorithmParameterException("OAEP hash algorithm not supported: " + hashName);
    }

    private static int oaepPaddingToHashBitSize(String padding) throws NoSuchPaddingException {
        if ((padding = padding.toUpperCase()).equals("OAEPPADDING")) {
            return 160;
        }
        if (padding.startsWith("OAEPWITH") && padding.endsWith("ANDMGF1PADDING")) {
            String hashName = padding.substring(8, padding.length() - 14);
            try {
                return RSACipher.hashNameToBitSize(hashName);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new NoSuchPaddingException("padding not supported: " + padding);
            }
        }
        throw new NoSuchPaddingException("padding not supported: " + padding);
    }

    private AlgorithmParameterSpec getParameterSpec() throws InvalidAlgorithmParameterException {
        if (this.oaepSpec == null) {
            if (!this.isOaep) {
                return null;
            }
            String oaepHashName = RSACipher.hashBitSizeToName(this.oaepHashBitSize);
            MGF1ParameterSpec mgfSpec = RSACipher.mgfBitSizeToSpec(this.oaepMgfBitSize);
            this.oaepSpec = new OAEPParameterSpec(oaepHashName, "MGF1", mgfSpec, PSource.PSpecified.DEFAULT);
        }
        return this.oaepSpec;
    }

    private void init(int opmode, Key key, AlgorithmParameterSpec paramSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.opmode = opmode;
        this.bufferOffset = 0;
        switch (opmode) {
            case 1: 
            case 3: {
                this.prvKey = null;
                if (!(key instanceof RSAPublicKey)) {
                    throw new InvalidKeyException("Invalid key type");
                }
                this.pubKey = (RSAPublicKey)key;
                this.bufferSize = (this.pubKey.getModulus().bitLength() + 7) / 8;
                break;
            }
            case 2: 
            case 4: {
                this.pubKey = null;
                if (!(key instanceof UBRSAPrivateKey)) {
                    throw new InvalidKeyException("Invalid key type");
                }
                this.prvKey = (UBRSAPrivateKey)key;
                this.bufferSize = (this.prvKey.getBitSize() + 7) / 8;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + opmode);
            }
        }
        if (paramSpec != null) {
            if (!this.isOaep) {
                throw new InvalidAlgorithmParameterException("Wrong padding parameter");
            }
            if (!(paramSpec instanceof OAEPParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Wrong Parameters for OAEP Padding");
            }
            this.oaepSpec = (OAEPParameterSpec)paramSpec;
            this.oaepHashBitSize = RSACipher.hashNameToBitSize(this.oaepSpec.getDigestAlgorithm());
            String mgfAlgName = this.oaepSpec.getMGFAlgorithm();
            if (!mgfAlgName.toUpperCase().equals("MGF1")) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF algorithm: " + mgfAlgName);
            }
            AlgorithmParameterSpec mgfParam = this.oaepSpec.getMGFParameters();
            if (!(mgfParam instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF hash");
            }
            String mgfHashName = ((MGF1ParameterSpec)mgfParam).getDigestAlgorithm();
            this.oaepMgfBitSize = RSACipher.hashNameToBitSize(mgfHashName);
            PSource s = this.oaepSpec.getPSource();
            if (s.getAlgorithm().equals("PSpecified")) {
                this.oaepSource = ((PSource.PSpecified)s).getValue();
            } else {
                throw new InvalidAlgorithmParameterException("Unsupported pSource " + s.getAlgorithm() + "; PSpecified only");
            }
        }
    }

    private void update(byte[] in, int inOffset, int inLen) {
        if (inLen == 0 || in == null) {
            return;
        }
        if (this.bufferOffset + inLen <= this.buffer.length) {
            System.arraycopy(in, inOffset, this.buffer, this.bufferOffset, inLen);
        }
        this.bufferOffset += inLen;
    }

    private byte[] doFinal(Key wrappedKey) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, IOException {
        int kmipPadding;
        if (this.pubKey != null) {
            Cipher cipher = SystemProvider.Cipher.getInstance("RSA/ECB/" + RSACipher.paddingTypeToName(this.isRaw, this.isOaep, this.oaepHashBitSize));
            cipher.init(this.opmode, (Key)this.pubKey, this.getParameterSpec(), this.secureRandom);
            if (this.opmode == 3) {
                return cipher.wrap(wrappedKey);
            }
            return cipher.doFinal(this.buffer, 0, this.bufferOffset);
        }
        byte[] in = Arrays.copyOfRange(this.buffer, 0, this.bufferOffset);
        int kmipHashAlg = 0;
        int kmipMgfAlg = 0;
        int n = kmipPadding = this.isOaep ? 2 : 8;
        if (this.isOaep) {
            kmipHashAlg = RSACipher.hashBitSizeToKmipHashAlg(this.oaepHashBitSize);
            kmipMgfAlg = RSACipher.hashBitSizeToKmipHashAlg(this.oaepMgfBitSize);
        }
        return this.prvKey.decrypt(in, kmipPadding, kmipHashAlg, kmipMgfAlg, this.oaepSource);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!(mode = mode.toUpperCase()).equals("NONE") && !mode.equals("ECB")) {
            throw new NoSuchAlgorithmException("Mode not supported: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if ((padding = padding.toUpperCase()).equals("NOPADDING")) {
            this.isRaw = true;
            this.isOaep = false;
        } else if (padding.equals("PKCS1PADDING")) {
            this.isRaw = false;
            this.isOaep = false;
        } else if (padding.equals("OAEPPADDING")) {
            this.isRaw = false;
            this.isOaep = true;
        } else if (padding.startsWith("OAEPWITH") && padding.endsWith("ANDMGF1PADDING")) {
            this.isRaw = false;
            this.isOaep = true;
        } else {
            throw new NoSuchPaddingException("Unsupported padding: " + padding);
        }
        if (this.isOaep) {
            this.oaepHashBitSize = RSACipher.oaepPaddingToHashBitSize(padding);
            this.oaepMgfBitSize = 160;
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.bufferSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        try {
            AlgorithmParameterSpec spec = this.getParameterSpec();
            if (spec == null) {
                return null;
            }
            AlgorithmParameters params = AlgorithmParameters.getInstance("OAEP");
            params.init(spec);
            return params;
        }
        catch (Throwable e) {
            throw new RuntimeException("Invalid algorithm parameters not supported");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.secureRandom = secureRandom;
        try {
            this.init(opmode, key, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("Wrong parameters", e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof KeyGenSpec) {
            if (opmode != 4) {
                throw new InvalidAlgorithmParameterException("KeyParameter is supported only in UNWRAP_MODE");
            }
            this.unwrapKeyParameter = ((KeyGenSpec)algorithmParameterSpec).getKeyParams();
            algorithmParameterSpec = ((KeyGenSpec)algorithmParameterSpec).getOriginal();
        } else {
            this.unwrapKeyParameter = null;
        }
        this.secureRandom = secureRandom;
        this.init(opmode, key, algorithmParameterSpec);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.secureRandom = secureRandom;
        OAEPParameterSpec spec = null;
        if (algorithmParameters != null) {
            try {
                spec = algorithmParameters.getParameterSpec(OAEPParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidKeyException("Wrong parameters", e);
            }
        }
        this.init(opmode, key, spec);
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOffset, int inLen) {
        this.update(in, inOffset, inLen);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        this.update(in, inOffset, inLen);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOffset, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        this.update(in, inOffset, inLen);
        if (this.bufferOffset > this.buffer.length) {
            throw new IllegalBlockSizeException("Input must be under " + this.buffer.length + " bytes");
        }
        try {
            return this.doFinal(null);
        }
        catch (Exception e) {
            throw new BadPaddingException("engineDoFinal failed");
        }
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] b = this.engineDoFinal(in, inOffset, inLen);
        if (outOffset + b.length > out.length) {
            throw new ShortBufferException("Output buffer is too small");
        }
        System.arraycopy(b, 0, out, outOffset, b.length);
        return b.length;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        if (encoded.length > this.buffer.length) {
            throw new InvalidKeyException("CKKey is too long for wrapping");
        }
        try {
            return this.doFinal(key);
        }
        catch (Exception e) {
            throw new InvalidKeyException("Wrapping failed", e);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] key;
        if (wrappedKeyType != 3) {
            throw new UnsupportedOperationException("wrappedKeyType == " + wrappedKeyType);
        }
        if (wrappedKey.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        try {
            key = this.doFinal(null);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return new SecretKeySpec(key, algorithm);
    }
}

