/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyFactorySpec;
import com.dyadicsec.provider.KeyParameters;
import com.unbound.common.crypto.SystemProvider;
import com.unbound.provider.Partition;
import com.unbound.provider.UBRSAPrivateKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAKeyFactory
extends KeyFactorySpi {
    private Partition partition;
    private KeyParameters keyParameter = null;

    RSAKeyFactory(Partition partition) {
        this.partition = partition;
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return SystemProvider.KeyFactory.getInstance("RSA").generatePublic(keySpec);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof KeyFactorySpec) {
            this.keyParameter = ((KeyFactorySpec)keySpec).getKeyParams();
            keySpec = ((KeyFactorySpec)keySpec).getOriginal();
        }
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec || keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                UBRSAPrivateKey key = new UBRSAPrivateKey(this.partition);
                key.register(this.keyParameter, keySpec);
                return key;
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e);
            }
        }
        throw new InvalidKeySpecException("Must use RSAPrivateCrtKeySpec or PKCS8EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (key == null || keySpec == null) {
            throw new InvalidKeySpecException("key and keySpec must not be null");
        }
        if (key instanceof RSAPublicKey && X509EncodedKeySpec.class.isAssignableFrom(keySpec)) {
            return SystemProvider.KeyFactory.getInstance("RSA").getKeySpec(key, keySpec);
        }
        if (key instanceof RSAPublicKey && RSAPublicKeySpec.class.isAssignableFrom(keySpec)) {
            return (T)new RSAPublicKeySpec(((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent());
        }
        throw new InvalidKeySpecException("Could not encode key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return key;
    }
}

