/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyGenSpec;
import com.dyadicsec.provider.KeyParameters;
import com.unbound.provider.Partition;
import com.unbound.provider.UBRSAPrivateKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private Partition partition;
    private int bitSize;
    private KeyParameters keyParameter = null;

    RSAKeyPairGenerator(Partition partition) {
        this.partition = partition;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof KeyGenSpec)) {
            throw new InvalidAlgorithmParameterException("Not supported algorithm parameter spec");
        }
        this.keyParameter = ((KeyGenSpec)params).getKeyParams();
        this.initialize(((KeyGenSpec)params).getBitSize(), random);
    }

    @Override
    public void initialize(int bitSize, SecureRandom random) {
        this.bitSize = bitSize;
        if (bitSize != 2048 && bitSize != 3072 && bitSize != 4096) {
            throw new InvalidParameterException("Unsupported RSA key size " + bitSize);
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        UBRSAPrivateKey key = new UBRSAPrivateKey(this.partition);
        try {
            key.generate(this.keyParameter, this.bitSize, null);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return new KeyPair(key.pub, key);
    }
}

