/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.crypto.SystemProvider;
import com.unbound.provider.HashType;
import com.unbound.provider.UBRSAPrivateKey;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public class RSASignaturePSS
extends SignatureSpi {
    private Signature pubSignature = null;
    private UBRSAPrivateKey prvKey = null;
    private MessageDigest md = null;
    private PSSParameterSpec pss = null;
    private int saltLen = 20;
    private HashType hash = HashType.SHA1;
    private HashType mgfHash = HashType.SHA1;

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        try {
            this.pubSignature = SystemProvider.Signature.getInstance("RSASSA-PSS");
            if (this.pss == null) {
                this.pss = new PSSParameterSpec("SHA-1", "MGF1", null, 20, 1);
            }
            this.pubSignature.setParameter(this.pss);
        }
        catch (Throwable e) {
            throw new InvalidKeyException("engineInitVerify failed");
        }
        this.pubSignature.initVerify(publicKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof UBRSAPrivateKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.prvKey = (UBRSAPrivateKey)privateKey;
        this.md = this.hash.getMessageDigest();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(b);
            return;
        }
        byte[] in = new byte[]{b};
        this.engineUpdate(in, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int inOffset, int inLen) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(in, inOffset, inLen);
            return;
        }
        this.md.update(in, inOffset, inLen);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] in = this.md.digest();
        try {
            return this.prvKey.signPss(in, this.hash.kmipCode, this.mgfHash.kmipCode, this.saltLen);
        }
        catch (IOException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.pubSignature.verify(sigBytes);
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            throw new InvalidAlgorithmParameterException("Parameters cannot be null");
        }
        if (!(params instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameters must be type PSSParameterSpec");
        }
        PSSParameterSpec pss = (PSSParameterSpec)params;
        if (!pss.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
            throw new InvalidAlgorithmParameterException("Only supports MGF1");
        }
        if (pss.getTrailerField() != 1) {
            throw new InvalidAlgorithmParameterException("Only supports TrailerFieldBC(1)");
        }
        this.saltLen = pss.getSaltLength();
        this.mgfHash = this.hash = HashType.getFromName(pss.getDigestAlgorithm());
        AlgorithmParameterSpec mgfParams = pss.getMGFParameters();
        if (mgfParams != null) {
            this.mgfHash = HashType.getFromName(((MGF1ParameterSpec)mgfParams).getDigestAlgorithm());
        }
        this.pss = pss;
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.pss == null) {
            throw new ProviderException("Missing required PSS parameters");
        }
        try {
            AlgorithmParameters ap = AlgorithmParameters.getInstance("RSASSA-PSS");
            ap.init(this.pss);
            return ap;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
    }
}

