/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyGenSpec;
import com.dyadicsec.provider.KeyParameters;
import com.unbound.common.Log;
import com.unbound.provider.UBECPrivateKey;
import com.unbound.provider.UBObject;
import com.unbound.provider.UBPrivateKey;
import com.unbound.provider.UBRSAPrivateKey;
import com.unbound.provider.UBSecretKey;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.attribute.KeyWrappingSpec;
import com.unbound.provider.kmip.attribute.MessageExt;
import com.unbound.provider.kmip.object.PrivateKey;
import com.unbound.provider.kmip.object.SymmetricKey;
import com.unbound.provider.kmip.request.DecryptRequest;
import com.unbound.provider.kmip.request.EncryptRequest;
import com.unbound.provider.kmip.request.GetRequest;
import com.unbound.provider.kmip.request.RegisterRequest;
import com.unbound.provider.kmip.request.RequestItem;
import com.unbound.provider.kmip.response.DecryptResponse;
import com.unbound.provider.kmip.response.EncryptResponse;
import com.unbound.provider.kmip.response.GetResponse;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class SecretKeyCipher
extends CipherSpi {
    private KeyParameters unwrapKeyParameter = null;
    private int kmipAlg;
    private boolean aad = false;
    private boolean wrap = false;
    private boolean encrypt = false;
    private boolean padding = false;
    private int kmipMode = 0;
    private AlgorithmParameterSpec paramSpec = null;
    private byte[] auth = null;
    private byte[] corr = null;
    private UBSecretKey secretKey = null;
    private CryptoParams kmipParams = new CryptoParams();
    private MessageExt kmipExt = null;

    SecretKeyCipher(int kmipAlg) {
        this.kmipAlg = kmipAlg;
    }

    private void init() {
        this.auth = null;
        this.corr = null;
    }

    private void setKmipIV(SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (this.paramSpec == null && this.encrypt) {
            if (secureRandom == null) {
                throw new InvalidAlgorithmParameterException("Can't generate IV");
            }
            int size = this.engineGetBlockSize();
            byte[] ivData = new byte[size];
            secureRandom.nextBytes(ivData);
            this.paramSpec = new IvParameterSpec(ivData);
        }
        if (this.paramSpec == null || !(this.paramSpec instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("IvParameterSpec required");
        }
        IvParameterSpec ivSpec = (IvParameterSpec)this.paramSpec;
        this.kmipExt = new MessageExt();
        this.kmipExt.iv = ivSpec.getIV();
    }

    private ArrayList getAuthParam() {
        if (!this.aad) {
            return null;
        }
        if (this.auth == null) {
            this.auth = new byte[0];
        }
        ArrayList<byte[]> a = new ArrayList<byte[]>();
        a.add(this.auth);
        return a;
    }

    private int execEncDec(byte[] in, int inOffset, int inLen, byte[] out, int outOffset, boolean doFinal) throws ShortBufferException {
        int outLen = -1;
        Log log = Log.func("SecretKeyCipher.execEncDec").log("encrypt", this.encrypt).log("doFinal", doFinal).log("inOffset", inOffset).log("inLen", inLen).end();
        try {
            byte[] result;
            RequestItem req;
            if (this.secretKey == null) {
                throw new ProviderException("Not initialized");
            }
            if (this.encrypt) {
                EncryptResponse resp;
                req = new EncryptRequest();
                req.corr = this.corr;
                if (inLen > 0) {
                    req.data = Arrays.copyOfRange(in, inOffset, inOffset + inLen);
                }
                req.initInd = this.corr == null;
                req.finalInd = doFinal;
                req.uid = UBObject.uidToStr(this.secretKey.uid);
                req.params = this.kmipParams;
                req.ext = this.kmipExt;
                if (this.kmipExt != null) {
                    req.ext.auth = this.getAuthParam();
                    req.iv = this.kmipExt.iv;
                }
                try {
                    resp = (EncryptResponse)this.secretKey.partition.transmit(req);
                }
                catch (IOException e) {
                    throw new ProviderException(e);
                }
                this.corr = resp.corr;
                result = resp.data;
            } else {
                DecryptResponse resp;
                req = new DecryptRequest();
                ((DecryptRequest)req).corr = this.corr;
                if (inLen > 0) {
                    ((DecryptRequest)req).data = Arrays.copyOfRange(in, inOffset, inOffset + inLen);
                }
                ((DecryptRequest)req).initInd = this.corr == null;
                ((DecryptRequest)req).finalInd = doFinal;
                ((DecryptRequest)req).uid = UBObject.uidToStr(this.secretKey.uid);
                ((DecryptRequest)req).params = this.kmipParams;
                ((DecryptRequest)req).ext = this.kmipExt;
                if (this.kmipExt != null) {
                    ((DecryptRequest)req).ext.auth = this.getAuthParam();
                    ((DecryptRequest)req).iv = this.kmipExt.iv;
                }
                try {
                    resp = (DecryptResponse)this.secretKey.partition.transmit(req);
                }
                catch (IOException e) {
                    this.init();
                    throw new ProviderException(e);
                }
                this.corr = resp.corr;
                result = resp.data;
            }
            if (result.length > out.length - outOffset) {
                this.init();
                throw new ShortBufferException();
            }
            System.arraycopy(result, 0, out, outOffset, result.length);
            int n = outLen = result.length;
            return n;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().log("outLen", outLen).end();
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.aad = false;
        if ((mode = mode.toUpperCase()).equalsIgnoreCase("GCM")) {
            this.kmipMode = 9;
            this.aad = true;
        } else if (mode.equalsIgnoreCase("ECB")) {
            this.kmipMode = 2;
        } else if (mode.equalsIgnoreCase("CBC")) {
            this.kmipMode = 1;
        } else if (mode.equalsIgnoreCase("CTR")) {
            this.kmipMode = 6;
        } else if (mode.equalsIgnoreCase("OFB128")) {
            this.kmipMode = 5;
        } else if (mode.equalsIgnoreCase("CFB128")) {
            this.kmipMode = 4;
        } else {
            throw new NoSuchAlgorithmException("Mode not supported: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (padding.equalsIgnoreCase("NOPADDING")) {
            this.padding = false;
        } else if (padding.equalsIgnoreCase("PKCS5PADDING")) {
            if (this.kmipMode != 1) {
                throw new NoSuchPaddingException("padding not supported");
            }
            this.padding = true;
        } else {
            throw new NoSuchPaddingException("padding not supported");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (this.kmipMode == 9) {
            int tlen = ((GCMParameterSpec)this.paramSpec).getTLen() / 8;
            return this.encrypt ? inputLen + tlen : inputLen - tlen;
        }
        return inputLen;
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.paramSpec == null) {
            return null;
        }
        if (this.paramSpec instanceof IvParameterSpec) {
            return ((IvParameterSpec)this.paramSpec).getIV();
        }
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.paramSpec == null) {
            return null;
        }
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance("AES", "SunJCE");
            params.init(this.paramSpec);
            return params;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException("Could not encode parameters", e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof KeyGenSpec) {
            if (opmode != 4) {
                throw new InvalidAlgorithmParameterException("KeyParameter is supported only in UNWRAP_MODE");
            }
            this.unwrapKeyParameter = ((KeyGenSpec)algorithmParameterSpec).getKeyParams();
            algorithmParameterSpec = ((KeyGenSpec)algorithmParameterSpec).getOriginal();
        } else {
            this.unwrapKeyParameter = null;
        }
        this.secretKey = null;
        this.init();
        if (opmode != 3 && opmode != 4 && opmode != 1 && opmode != 2) {
            throw new InvalidParameterException("Invalid mode");
        }
        if (!(key instanceof UBSecretKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        UBSecretKey secretKey = (UBSecretKey)key;
        if (secretKey.getKmipAlg() != 3) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.wrap = opmode == 3 || opmode == 4;
        this.encrypt = opmode == 1 || opmode == 3;
        this.paramSpec = algorithmParameterSpec;
        this.kmipParams.mode = this.kmipMode;
        this.kmipParams.padding = this.padding ? 3 : 1;
        switch (this.kmipMode) {
            case 9: {
                if (!(this.paramSpec instanceof GCMParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("GCMParameterSpec required");
                }
                GCMParameterSpec gcm = (GCMParameterSpec)this.paramSpec;
                this.kmipExt = new MessageExt();
                this.kmipExt.iv = gcm.getIV();
                int tagBits = gcm.getTLen();
                if (tagBits % 8 != 0) {
                    throw new InvalidAlgorithmParameterException("Invalid tag length");
                }
                this.kmipParams.tagLength = tagBits / 8;
                if (this.kmipParams.tagLength < 1 || this.kmipParams.tagLength > 16) {
                    throw new InvalidAlgorithmParameterException("Invalid tag length");
                }
                if (this.kmipExt.iv.length == 12) break;
                throw new InvalidAlgorithmParameterException("Invalid IV length");
            }
            case 6: {
                this.setKmipIV(secureRandom);
                if (this.kmipExt.iv.length != 16) {
                    throw new InvalidAlgorithmParameterException("Invalid IV length");
                }
                this.kmipParams.counterLength = 32;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                this.setKmipIV(secureRandom);
                if (this.kmipExt.iv.length == 16) break;
                throw new InvalidAlgorithmParameterException("Invalid IV length");
            }
        }
        this.secretKey = secretKey;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec = null;
        Class clazz = IvParameterSpec.class;
        if (this.kmipMode == 9) {
            clazz = GCMParameterSpec.class;
        }
        if (algorithmParameters != null) {
            try {
                spec = algorithmParameters.getParameterSpec(clazz);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter");
            }
        }
        this.engineInit(opmode, key, spec, secureRandom);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] in, int inOffset, int inLen) throws IllegalStateException, UnsupportedOperationException {
        if (!this.aad) {
            throw new IllegalStateException("Cipher does not accept AAD");
        }
        if (this.auth == null) {
            this.auth = Arrays.copyOfRange(in, inOffset, inOffset + inLen);
        } else {
            int oldSize = this.auth.length;
            byte[] newBuffer = new byte[oldSize + inLen];
            if (oldSize > 0) {
                System.arraycopy(this.auth, 0, newBuffer, 0, oldSize);
            }
            System.arraycopy(in, inOffset, newBuffer, oldSize, inLen);
            this.auth = newBuffer;
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOffset, int inLen) {
        byte[] out = new byte[inLen + 32];
        int outLen = 0;
        try {
            outLen = this.engineUpdate(in, inOffset, inLen, out, 0);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
        return Arrays.copyOf(out, outLen);
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOffset, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out = new byte[inLen + 32];
        int outLen = 0;
        try {
            outLen = this.engineDoFinal(in, inOffset, inLen, out, 0);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
        return Arrays.copyOf(out, outLen);
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        if (inLen == 0) {
            return 0;
        }
        return this.execEncDec(in, inOffset, inLen, out, outOffset, false);
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (inLen == 0) {
            switch (this.kmipMode) {
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    return 0;
                }
                case 1: {
                    if (this.padding) break;
                    return 0;
                }
            }
        }
        int outLen = this.execEncDec(in, inOffset, inLen, out, outOffset, true);
        this.init();
        return outLen;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        GetResponse resp;
        GetRequest req;
        UBObject ubObject;
        Log log = Log.func("SecretKeyCipher.engineWrap").end();
        try {
            if (this.secretKey == null) {
                throw new ProviderException("Not initialized");
            }
            if (key == null) {
                throw new ProviderException("key is null");
            }
            if (this.corr != null) {
                throw new ProviderException("engineUpdate called");
            }
            if (!(key instanceof UBSecretKey) && !(key instanceof UBRSAPrivateKey)) {
                byte[] encoded = key.getEncoded();
                try {
                    byte[] byArray = this.engineDoFinal(encoded, 0, encoded.length);
                    return byArray;
                }
                catch (BadPaddingException e) {
                    throw new ProviderException(e);
                }
            }
            ubObject = (UBObject)((Object)key);
            req = new GetRequest();
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        req.uid = UBObject.uidToStr(ubObject.uid);
        req.formatType = 1;
        req.keyWrap = new KeyWrappingSpec();
        req.keyWrap.encKey.uid = UBObject.uidToStr(this.secretKey.uid);
        req.keyWrap.encKey.params = this.kmipParams;
        req.ext = this.kmipExt;
        if (this.kmipExt != null) {
            req.ext.auth = this.getAuthParam();
        }
        try {
            resp = (GetResponse)this.secretKey.partition.transmit(req);
        }
        catch (IOException e) {
            throw new ProviderException(e);
        }
        this.init();
        if (resp.object instanceof PrivateKey) {
            return ((PrivateKey)resp.object).keyBlock.buf;
        }
        if (!(resp.object instanceof SymmetricKey)) throw new ProviderException("Invalid managed object returned");
        return ((SymmetricKey)resp.object).keyBlock.buf;
        finally {
            log.leave();
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Log log = Log.func("SecretKeyCipher.engineUnwrap").log("wrappedKey.length", wrappedKey.length).log("wrappedKeyAlgorithm", wrappedKeyAlgorithm).log("wrappedKeyType", wrappedKeyType).end();
        try {
            if (this.secretKey == null) {
                throw new ProviderException("Not initialized");
            }
            if (this.corr != null) {
                throw new ProviderException("engineUpdate called");
            }
            int kmipAlg = 0;
            RegisterRequest registerRequest = new RegisterRequest();
            registerRequest.ext = this.kmipExt;
            if (this.kmipExt != null) {
                registerRequest.ext.auth = this.getAuthParam();
            }
            switch (wrappedKeyType) {
                case 2: {
                    UBPrivateKey newPrivateKey;
                    if (wrappedKeyAlgorithm.equalsIgnoreCase("RSA")) {
                        newPrivateKey = new UBRSAPrivateKey(this.secretKey.partition);
                    } else if (wrappedKeyAlgorithm.equalsIgnoreCase("EC")) {
                        newPrivateKey = new UBECPrivateKey(this.secretKey.partition);
                    } else {
                        throw new InvalidKeyException("Unsupported wrappedKeyAlgorithm " + wrappedKeyAlgorithm);
                    }
                    try {
                        newPrivateKey.unwrap(this.unwrapKeyParameter, registerRequest, this.secretKey.uid, this.kmipParams, wrappedKey);
                    }
                    catch (IOException | InvalidKeySpecException e) {
                        throw new ProviderException(e);
                    }
                    UBPrivateKey e = newPrivateKey;
                    return e;
                }
                case 3: {
                    if (wrappedKeyAlgorithm.equalsIgnoreCase("AES")) {
                        kmipAlg = 3;
                    } else if (wrappedKeyAlgorithm.equalsIgnoreCase("HMAC")) {
                        kmipAlg = 9;
                    } else {
                        throw new InvalidKeyException("Unsupported wrappedKeyAlgorithm " + wrappedKeyAlgorithm);
                    }
                    UBSecretKey newSecretKey = new UBSecretKey(this.secretKey.partition, kmipAlg);
                    try {
                        newSecretKey.unwrap(this.unwrapKeyParameter, registerRequest, this.secretKey.uid, this.kmipParams, wrappedKey);
                    }
                    catch (IOException e) {
                        throw new ProviderException(e);
                    }
                    UBSecretKey uBSecretKey = newSecretKey;
                    return uBSecretKey;
                }
            }
            try {
                throw new InvalidKeyException("Unsupported wrappedKeyType");
            }
            catch (Exception e) {
                log.failed(e);
                throw e;
            }
        }
        finally {
            log.leave();
        }
    }

    public static final class AES
    extends SecretKeyCipher {
        public AES() {
            super(3);
        }
    }
}

