/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyFactorySpec;
import com.dyadicsec.provider.KeyParameters;
import com.unbound.provider.Partition;
import com.unbound.provider.UBSecretKey;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public class SecretKeyFactory
extends SecretKeyFactorySpi {
    private int kmipAlg;
    private Partition partition;
    private KeyParameters keyParameter = null;

    SecretKeyFactory(Partition partition, int kmipAlg) {
        this.partition = partition;
        this.kmipAlg = kmipAlg;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof KeyFactorySpec) {
            this.keyParameter = ((KeyFactorySpec)keySpec).getKeyParams();
            keySpec = ((KeyFactorySpec)keySpec).getOriginal();
        } else {
            this.keyParameter = null;
        }
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (keySpec instanceof SecretKeySpec) {
            byte[] keyValue = ((SecretKeySpec)keySpec).getEncoded();
            int bitSize = keyValue.length * 8;
            if (this.kmipAlg == 3) {
                if (bitSize != 128 && bitSize != 192 && bitSize != 256) {
                    throw new InvalidKeySpecException("Wrong key size: must be equal to 128, 192 or 256");
                }
            } else if (bitSize < 8 || bitSize > 2048 || bitSize % 8 != 0) {
                throw new InvalidKeySpecException("Wrong key size");
            }
            try {
                UBSecretKey secretKey = new UBSecretKey(this.partition, this.kmipAlg);
                secretKey.register(this.keyParameter, keyValue, null);
                return secretKey;
            }
            catch (Exception e) {
                throw new ProviderException(e);
            }
        }
        throw new InvalidKeySpecException("Must use SecretKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class<?> aClass) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Could not encode key");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey instanceof UBSecretKey) {
            return secretKey;
        }
        throw new InvalidKeyException("secretKey must be instance of UBSecretKey");
    }

    public static final class Hmac
    extends SecretKeyFactory {
        public Hmac(Partition partition) {
            super(partition, 9);
        }
    }

    public static final class AES
    extends SecretKeyFactory {
        public AES(Partition partition) {
            super(partition, 3);
        }
    }
}

