/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyGenSpec;
import com.dyadicsec.provider.KeyParameters;
import com.unbound.provider.Partition;
import com.unbound.provider.UBSecretKey;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class SecretKeyGenerator
extends KeyGeneratorSpi {
    private int bitSize;
    private int kmipAlg;
    private Partition partition;
    private KeyParameters keyParameter = null;

    SecretKeyGenerator(Partition partition, int kmipAlg) {
        this.partition = partition;
        this.kmipAlg = kmipAlg;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof KeyGenSpec)) {
            throw new InvalidAlgorithmParameterException("Secret key generation does not take any parameters");
        }
        this.keyParameter = ((KeyGenSpec)algorithmParameterSpec).getKeyParams();
        this.engineInit(((KeyGenSpec)algorithmParameterSpec).getBitSize(), secureRandom);
    }

    @Override
    protected void engineInit(int bitSize, SecureRandom secureRandom) {
        if (this.kmipAlg == 3) {
            if (bitSize != 128 && bitSize != 192 && bitSize != 256) {
                throw new InvalidParameterException("Wrong key size: must be equal to 128, 192 or 256");
            }
        } else if (bitSize < 8 || bitSize > 2048 || bitSize % 8 != 0) {
            throw new InvalidParameterException("Wrong key size");
        }
        this.bitSize = bitSize;
    }

    @Override
    protected SecretKey engineGenerateKey() {
        UBSecretKey secretKey = new UBSecretKey(this.partition, this.kmipAlg);
        try {
            secretKey.generate(this.keyParameter, this.bitSize);
        }
        catch (IOException e) {
            throw new ProviderException(e);
        }
        return secretKey;
    }

    public static final class Hmac
    extends SecretKeyGenerator {
        public Hmac(Partition partition) {
            super(partition, 9);
        }
    }

    public static final class AES
    extends SecretKeyGenerator {
        public AES(Partition partition) {
            super(partition, 3);
        }
    }
}

