/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Log;
import com.unbound.provider.UBObject;
import com.unbound.provider.UBSecretKey;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.request.MACRequest;
import com.unbound.provider.kmip.response.MACResponse;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;

public class SecretKeyMac
extends MacSpi {
    private int kmipAlg;
    private byte[] oneByte = null;
    private byte[] corr = null;
    private UBSecretKey secretKey = null;

    SecretKeyMac(int kmipAlg) {
        this.kmipAlg = kmipAlg;
    }

    @Override
    protected int engineGetMacLength() {
        switch (this.kmipAlg) {
            case 7: {
                return 20;
            }
            case 9: {
                return 32;
            }
            case 10: {
                return 48;
            }
            case 11: {
                return 64;
            }
        }
        return 0;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new InvalidKeyException("Invalid key");
        }
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        if (!(key instanceof UBSecretKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        UBSecretKey secretKey = (UBSecretKey)key;
        switch (secretKey.getKmipAlg()) {
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid key type");
            }
        }
        this.secretKey = secretKey;
    }

    @Override
    protected void engineUpdate(byte b) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = b;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int length) {
        int tagLen = this.engineGetMacLength();
        Log log = Log.func("SecretKeyMac.engineUpdate").log("kmipAlg", this.kmipAlg).log("tagLen", tagLen).log("offset", offset).log("length", length).end();
        try {
            MACResponse resp;
            if (this.secretKey == null) {
                throw new ProviderException("Key not initialized");
            }
            MACRequest req = new MACRequest();
            req.corr = this.corr;
            req.data = Arrays.copyOfRange(input, offset, offset + length);
            req.initInd = this.corr == null;
            req.finalInd = false;
            req.uid = UBObject.uidToStr(this.secretKey.uid);
            req.params = new CryptoParams();
            req.params.cryptoAlg = this.kmipAlg;
            req.params.tagLength = tagLen;
            try {
                resp = (MACResponse)this.secretKey.partition.transmit(req);
            }
            catch (IOException e) {
                throw new ProviderException(e);
            }
            this.corr = resp.corr;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        int tagLen = this.engineGetMacLength();
        Log log = Log.func("SecretKeyMac.engineUpdate").log("kmipAlg", this.kmipAlg).log("tagLen", tagLen).end();
        try {
            MACResponse resp;
            if (this.secretKey == null) {
                throw new ProviderException("Key not initialized");
            }
            MACRequest req = new MACRequest();
            req.corr = this.corr;
            req.initInd = this.corr == null;
            req.finalInd = true;
            req.uid = UBObject.uidToStr(this.secretKey.uid);
            req.params = new CryptoParams();
            req.params.cryptoAlg = this.kmipAlg;
            req.params.tagLength = tagLen;
            try {
                resp = (MACResponse)this.secretKey.partition.transmit(req);
            }
            catch (IOException e) {
                throw new ProviderException(e);
            }
            this.engineReset();
            byte[] byArray = resp.data;
            return byArray;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    @Override
    protected void engineReset() {
        this.corr = null;
    }

    public static final class HmacSHA512
    extends SecretKeyMac {
        public HmacSHA512() {
            super(11);
        }
    }

    public static final class HmacSHA384
    extends SecretKeyMac {
        public HmacSHA384() {
            super(10);
        }
    }

    public static final class HmacSHA256
    extends SecretKeyMac {
        public HmacSHA256() {
            super(9);
        }
    }

    public static final class HmacSHA1
    extends SecretKeyMac {
        public HmacSHA1() {
            super(7);
        }
    }
}

