/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Log;
import com.unbound.common.crypto.X509;
import com.unbound.provider.Partition;
import com.unbound.provider.UBECPrivateKey;
import com.unbound.provider.UBObject;
import com.unbound.provider.UBRSAPrivateKey;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.attribute.BytesAttribute;
import com.unbound.provider.kmip.attribute.DateAttribute;
import com.unbound.provider.kmip.attribute.Link;
import com.unbound.provider.kmip.attribute.Name;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.object.Certificate;
import com.unbound.provider.kmip.request.ActivateRequest;
import com.unbound.provider.kmip.request.GetAttributesRequest;
import com.unbound.provider.kmip.request.LocateRequest;
import com.unbound.provider.kmip.request.RegisterRequest;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.response.GetAttributesResponse;
import com.unbound.provider.kmip.response.GetResponse;
import com.unbound.provider.kmip.response.RegisterResponse;
import com.unbound.provider.kmip.response.ResponseMessage;
import java.io.IOException;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

class UBCertificate
extends UBObject {
    X509Certificate x509;

    UBCertificate(Partition partition, long uid, GetAttributesResponse getAttrResp, GetResponse get) throws CertificateException {
        super(partition, uid, getAttrResp);
        Log log = Log.func("UBCertificate").logHex("uid", uid).end();
        try {
            Certificate kmipManagedObject = (Certificate)get.object;
            this.x509 = X509.get(kmipManagedObject.value);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    UBCertificate(Partition partition, String alias, X509Certificate x509) throws IOException, CertificateEncodingException {
        super(partition);
        Log log = Log.func("UBCertificate").log("alias", alias).end();
        try {
            RequestMessage reqMsg = new RequestMessage();
            RegisterRequest reqRegister = new RegisterRequest();
            reqMsg.batch.add(reqRegister);
            reqRegister.objectType = 1;
            if (alias != null) {
                reqRegister.template = new TemplateAttribute();
                reqRegister.template.attrs.add(new Name(alias));
            }
            Certificate managedObject = new Certificate();
            managedObject.type = 1;
            managedObject.value = x509.getEncoded();
            reqRegister.object = managedObject;
            ActivateRequest reqActivate = new ActivateRequest();
            reqMsg.batch.add(reqActivate);
            GetAttributesRequest reqGetAttr = new GetAttributesRequest();
            reqMsg.batch.add(reqGetAttr);
            reqGetAttr.names.add("Name");
            reqGetAttr.names.add("Initial Date");
            ResponseMessage respMsg = partition.transmit(reqMsg);
            RegisterResponse respRegister = (RegisterResponse)respMsg.batch.get(0);
            GetAttributesResponse respGetAttr = (GetAttributesResponse)respMsg.batch.get(2);
            this.uid = UBCertificate.strToUid(respRegister.uid);
            this.name = ((Name)respGetAttr.attrs.get((int)0)).value;
            this.initialDate = ((DateAttribute)respGetAttr.attrs.get((int)1)).value;
            this.x509 = x509;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    boolean match(PublicKey key) {
        return this.x509.getPublicKey().equals(key);
    }

    static UBCertificate locate(Partition partition, String alias) throws CertificateException, InvalidKeySpecException, IOException {
        long uid = 0L;
        Log log = Log.func("UBCertificate.locate").log("alias", alias).end();
        try {
            uid = partition.locate(1, 0, alias);
            if (uid == 0L) {
                UBCertificate uBCertificate = null;
                return uBCertificate;
            }
            UBCertificate uBCertificate = (UBCertificate)UBObject.read(partition, uid, true);
            return uBCertificate;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("uid", uid).end();
        }
    }

    static UBCertificate locate(Partition partition, X509Certificate cert) throws CertificateException, InvalidKeySpecException, IOException {
        long uid = 0L;
        Log log = Log.func("UBCertificate.locateByValue").end();
        try {
            LocateRequest req = UBCertificate.locateRequest(1, 0, null);
            req.attrs.add(new BytesAttribute(KMIP.Tag.CKA_VALUE, cert.getEncoded()));
            uid = partition.locate(req);
            if (uid == 0L) {
                UBCertificate uBCertificate = null;
                return uBCertificate;
            }
            UBCertificate uBCertificate = (UBCertificate)UBObject.read(partition, uid, true);
            return uBCertificate;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("uid", uid).end();
        }
    }

    static UBCertificate locateByKeyUid(Partition partition, long keyUid) throws CertificateException, InvalidKeySpecException, IOException {
        long uid = 0L;
        Log log = Log.func("UBCertificate.locateByKeyUid").logHex("keyUid", keyUid).end();
        try {
            LocateRequest req = UBCertificate.locateRequest(1, 0, null);
            req.attrs.add(new Link(259, UBCertificate.uidToStr(keyUid)));
            uid = partition.locate(req);
            if (uid == 0L) {
                UBCertificate uBCertificate = null;
                return uBCertificate;
            }
            UBCertificate uBCertificate = (UBCertificate)UBObject.read(partition, uid, true);
            return uBCertificate;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("uid", uid).end();
        }
    }

    private static UBCertificate findBySubject(X500Principal subject, UBObject[] certs) {
        for (UBObject object : certs) {
            if (object == null) continue;
            UBCertificate cert = (UBCertificate)object;
            if (!subject.equals(cert.x509.getSubjectX500Principal())) continue;
            return cert;
        }
        return null;
    }

    java.security.cert.Certificate[] getChain(UBObject[] certs) {
        X500Principal issuer;
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        chain.add(this.x509);
        UBCertificate next = this;
        X500Principal subject = this.x509.getSubjectX500Principal();
        while (!subject.equals(issuer = next.x509.getIssuerX500Principal()) && (next = UBCertificate.findBySubject(subject = issuer, certs)) != null) {
            chain.add(next.x509);
        }
        return chain.toArray(new X509Certificate[0]);
    }

    private static UBCertificate findBySubject(Partition partition, X500Principal subject) throws CertificateException, InvalidKeySpecException, IOException {
        LocateRequest req = UBCertificate.locateRequest(1, 0, null);
        req.attrs.add(new BytesAttribute(KMIP.Tag.CKA_SUBJECT, subject.getEncoded()));
        long uid = partition.locate(req);
        if (uid == 0L) {
            return null;
        }
        return (UBCertificate)UBObject.read(partition, uid, true);
    }

    java.security.cert.Certificate[] getChain() throws CertificateException, InvalidKeySpecException, IOException {
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        Log log = Log.func("UBCertificate.getChain").logHex("uid", this.uid).end();
        try {
            chain.add(this.x509);
            UBCertificate next = this;
            X500Principal subject = this.x509.getSubjectX500Principal();
            while (true) {
                X500Principal issuer = next.x509.getIssuerX500Principal();
                String subj = subject.toString();
                String issu = issuer.toString();
                Log.print("Info").log("subj", subj).log("issu", issu).end();
                if (subject.equals(issuer)) break;
                subject = issuer;
                next = UBCertificate.findBySubject(this.partition, issuer);
                if (next == null) break;
                chain.add(next.x509);
            }
            java.security.cert.Certificate[] certificateArray = chain.toArray(new X509Certificate[0]);
            return certificateArray;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    @Override
    int kmipObjectType() {
        return 1;
    }

    static long getKeyUid(X509Certificate x509) {
        PublicKey pub = x509.getPublicKey();
        if (pub instanceof RSAPublicKey) {
            return UBRSAPrivateKey.getKeyUid((RSAPublicKey)pub);
        }
        if (pub instanceof ECPublicKey) {
            return UBECPrivateKey.getKeyUid((ECPublicKey)pub);
        }
        throw new ProviderException("Unsupported certificate type");
    }
}

