/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyParameters;
import com.unbound.common.Converter;
import com.unbound.common.Log;
import com.unbound.common.crypto.EC;
import com.unbound.provider.Partition;
import com.unbound.provider.UBObject;
import com.unbound.provider.UBPrivateKey;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.object.ManagedObject;
import com.unbound.provider.kmip.request.dy.DyDeriveRequest;
import com.unbound.provider.kmip.response.GetAttributesResponse;
import com.unbound.provider.kmip.response.GetResponse;
import com.unbound.provider.kmip.response.dy.DyDeriveResponse;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class UBECPRFKey
extends UBPrivateKey {
    UBECPRFKey(Partition partition) {
        super(partition);
    }

    UBECPRFKey(Partition partition, long uid, GetAttributesResponse getAttrResp) {
        super(partition, uid, getAttrResp);
    }

    public static UBECPRFKey find(String partitionName, long uid) throws CertificateException, InvalidKeySpecException, IOException {
        Partition partition = Partition.get(partitionName);
        if (partition == null) {
            return null;
        }
        return (UBECPRFKey)UBObject.read(partition, uid, false);
    }

    public static UBECPRFKey find(String partitionName, String keyName) throws IOException, InvalidKeySpecException, CertificateException {
        Partition partition = Partition.get(partitionName);
        if (partition == null) {
            return null;
        }
        return (UBECPRFKey)UBPrivateKey.locate(partition, -2147483647, keyName);
    }

    public String getPartitionName() {
        return this.partition.name;
    }

    public long getUid() {
        return this.uid;
    }

    public byte[] derive(int purpose, byte[] tweak, int size) throws IOException {
        Log log = Log.func("UBECPRFKey.derive").log("purpose", purpose).log("size", size).logLen("tweakLen", tweak).end();
        try {
            DyDeriveRequest req = new DyDeriveRequest();
            req.uid = UBECPRFKey.uidToStr(this.uid);
            req.secretSize = size;
            req.params = new CryptoParams();
            req.params.cryptoAlg = -2147483647;
            req.data = new byte[4 + tweak.length];
            Converter.setBE4(req.data, 0, purpose);
            System.arraycopy(tweak, 0, req.data, 4, tweak.length);
            DyDeriveResponse resp = (DyDeriveResponse)this.partition.transmit(req);
            byte[] byArray = resp.data;
            return byArray;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    @Override
    int getKmipAlg() {
        return 0;
    }

    @Override
    int getDefaultUsageMask() {
        return 0;
    }

    @Override
    ManagedObject prepareManagedObject(KeySpec keySpec) throws InvalidKeySpecException {
        return null;
    }

    @Override
    ManagedObject prepareManagedObject(PrivateKey key) throws InvalidKeySpecException {
        return null;
    }

    @Override
    PublicKey convertResponseToPublicKey(GetResponse resp) throws InvalidKeySpecException {
        return null;
    }

    @Override
    TemplateAttribute prepareGenerateTemplate(KeyParameters keyParameter, int bitSize, EC.Curve curve) {
        return null;
    }

    @Override
    public String getAlgorithm() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }
}

