/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.DYCryptoProvider;
import com.unbound.common.Log;
import com.unbound.provider.Partition;
import com.unbound.provider.UBCertificate;
import com.unbound.provider.UBCryptoProvider;
import com.unbound.provider.UBObject;
import com.unbound.provider.UBPrivateKey;
import com.unbound.provider.UBSecretKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.time.Clock;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class UBKeyStore
extends KeyStoreSpi {
    private static final int CACHE_TIMEOUT = 30000;
    private static final Clock clock = Clock.systemUTC();
    private Partition partition;
    private Map<String, Entry> cache = new HashMap<String, Entry>();
    private long lastCacheClock = 0L;

    UBKeyStore(Partition partition) {
        this.partition = partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry findEntry(String alias) throws InvalidKeySpecException, CertificateException, IOException {
        Entry entry = null;
        Log log = Log.func("UBKeyStore.findEntry").log("alias", alias).end();
        try {
            UBCertificate cert;
            Object object = this;
            synchronized (object) {
                entry = this.cache.get(alias.toUpperCase());
            }
            if (entry != null) {
                object = entry;
                return object;
            }
            UBPrivateKey key = UBPrivateKey.locate(this.partition, 0, alias);
            if (key == null) {
                cert = UBCertificate.locate(this.partition, alias);
                if (cert != null) {
                    entry = new Entry(cert);
                } else {
                    UBSecretKey secret = UBSecretKey.locate(this.partition, alias);
                    if (secret == null) {
                        Entry entry2 = null;
                        return entry2;
                    }
                    entry = new Entry(secret);
                }
            } else {
                cert = UBCertificate.locateByKeyUid(this.partition, key.uid);
                entry = cert == null ? new Entry(key) : new Entry(key, cert, null);
            }
            Object object2 = this;
            synchronized (object2) {
                this.cache.put(entry.getName().toUpperCase(), entry);
            }
            if (!UBCryptoProvider.allowedPrivateKeyWithoutCertificate && entry != null && entry.isOrphanPrvKey()) {
                entry = null;
            }
            object2 = entry;
            return object2;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log = log.leavePrint();
            if (entry != null) {
                log.log("entry", entry.getName());
            }
            log.end();
        }
    }

    private Enumeration<String> getAliases() {
        if (UBCryptoProvider.allowedPrivateKeyWithoutCertificate) {
            return Collections.enumeration(this.cache.keySet());
        }
        return new FilteredAliases(this.cache);
    }

    static void setKeyAlias(Key key, String alias) throws KeyStoreException {
        if (!(key instanceof UBPrivateKey) && !(key instanceof UBSecretKey)) {
            throw new KeyStoreException("Key type is not supported");
        }
        ((UBObject)((Object)key)).partition.keyStore.engineSetKeyEntry(alias, key, null, null);
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Entry entry;
        try {
            if (password != null && password.length != 0) {
                this.partition.login(new String(password));
            }
            entry = this.findEntry(alias);
        }
        catch (IOException | CertificateException | InvalidKeySpecException e) {
            throw new ProviderException(e);
        }
        if (entry == null) {
            return null;
        }
        if (entry.secretKey != null) {
            return entry.secretKey;
        }
        return entry.prvKey;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Entry entry;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        if (entry == null) {
            return null;
        }
        return entry.chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Entry entry;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        if (entry == null) {
            return null;
        }
        if (entry.cert == null) {
            return null;
        }
        return entry.cert.x509;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Entry entry;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        if (entry == null) {
            return null;
        }
        long initialDate = -1L;
        initialDate = entry.secretKey != null ? entry.secretKey.initialDate : (entry.prvKey != null ? entry.prvKey.initialDate : entry.cert.initialDate);
        if (initialDate < 0L) {
            return null;
        }
        return new Date(initialDate * 1000L);
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        char[] password = null;
        if (protParam != null && protParam instanceof KeyStore.PasswordProtection) {
            password = ((KeyStore.PasswordProtection)protParam).getPassword();
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)entry;
            this.engineSetKeyEntry(alias, keyEntry.getPrivateKey(), password, keyEntry.getCertificateChain());
            return;
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
            this.engineSetKeyEntry(alias, secretKeyEntry.getSecretKey(), password, null);
            return;
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(alias, certEntry.getTrustedCertificate());
            return;
        }
        if (entry instanceof DYCryptoProvider.KeyEntry) {
            DYCryptoProvider.KeyEntry keyEntry = (DYCryptoProvider.KeyEntry)entry;
            this.engineSetKeyEntry(alias, keyEntry.getPrivateKey(), password, null);
            return;
        }
        throw new KeyStoreException(new UnsupportedOperationException("unsupported entry type: " + entry.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        try {
            if (password != null && password.length != 0) {
                this.partition.login(new String(password));
            }
            UBSecretKey secretKey = key instanceof UBSecretKey ? (UBSecretKey)key : null;
            UBPrivateKey privateKey = key instanceof UBPrivateKey ? (UBPrivateKey)key : null;
            Entry entry = this.findEntry(alias);
            if (entry != null) {
                if (entry.isTrustedCert()) {
                    throw new KeyStoreException("Trusted certificate entry present");
                }
                if (privateKey == null && secretKey == null) {
                    this.engineDeleteEntry(alias);
                }
            }
            if (chain != null) {
                if (privateKey == null) {
                    privateKey = UBPrivateKey.newPrivateKey(null, this.partition, alias, key);
                } else {
                    privateKey.setName(alias);
                }
                X509Certificate x509 = (X509Certificate)chain[0];
                UBCertificate cert = UBCertificate.locate(this.partition, x509);
                if (cert == null) {
                    cert = new UBCertificate(this.partition, alias, x509);
                } else {
                    cert.setName(alias);
                }
                for (int i = 1; i < chain.length; ++i) {
                    x509 = (X509Certificate)chain[1];
                    UBCertificate chainCert = UBCertificate.locate(this.partition, x509);
                    if (chainCert != null) continue;
                    new UBCertificate(this.partition, alias, x509);
                }
                entry = new Entry(privateKey, cert, chain);
            } else if (UBCryptoProvider.allowedPrivateKeyWithoutCertificate && privateKey != null) {
                privateKey.setName(alias);
                entry = new Entry(privateKey);
            } else {
                if (secretKey == null) {
                    secretKey = UBSecretKey.newSecretKey(null, this.partition, alias, key);
                } else {
                    secretKey.setName(alias);
                }
                entry = new Entry(secretKey);
            }
            UBKeyStore uBKeyStore = this;
            synchronized (uBKeyStore) {
                this.cache.put(alias, entry);
            }
        }
        catch (IOException | CertificateException | InvalidKeySpecException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        try {
            Entry entry = this.findEntry(alias);
            if (entry != null) {
                if (!entry.isTrustedCert()) {
                    throw new KeyStoreException("Private or secret key entry present");
                }
                this.engineDeleteEntry(alias);
            }
            UBCertificate c = new UBCertificate(this.partition, alias, (X509Certificate)cert);
            entry = new Entry(c);
            UBKeyStore uBKeyStore = this;
            synchronized (uBKeyStore) {
                this.cache.put(alias, entry);
            }
        }
        catch (IOException | CertificateException | InvalidKeySpecException e) {
            throw new KeyStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        try {
            Entry entry = this.findEntry(alias);
            if (entry == null) {
                return;
            }
            if (entry.secretKey != null) {
                UBObject.delete(this.partition, entry.secretKey);
            } else {
                UBObject.delete(this.partition, entry.cert, entry.prvKey);
            }
            UBKeyStore uBKeyStore = this;
            synchronized (uBKeyStore) {
                this.cache.remove(alias);
            }
        }
        catch (IOException | CertificateException | InvalidKeySpecException e) {
            throw new KeyStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Enumeration<String> engineAliases() {
        UBKeyStore uBKeyStore = this;
        synchronized (uBKeyStore) {
            long now = clock.millis();
            if (now < this.lastCacheClock + 30000L) {
                return this.getAliases();
            }
        }
        try {
            UBObject[] symKeys;
            void var10_17;
            UBObject object;
            void object2;
            long[] rsaIds = this.partition.locate(4, 4);
            long[] eccIds = this.partition.locate(4, 26);
            long[] prvKeyIds = new long[rsaIds.length + eccIds.length];
            System.arraycopy(rsaIds, 0, prvKeyIds, 0, rsaIds.length);
            System.arraycopy(eccIds, 0, prvKeyIds, rsaIds.length, eccIds.length);
            long[] certIds = this.partition.locate(1, 0);
            UBObject[] prvKeys = UBObject.read(this.partition, prvKeyIds, true);
            UBObject[] certs = UBObject.read(this.partition, certIds, true);
            HashMap<String, Entry> cache = new HashMap<String, Entry>();
            UBObject[] uBObjectArray = prvKeys;
            int n = uBObjectArray.length;
            boolean bl = false;
            while (object2 < n) {
                object = uBObjectArray[object2];
                UBPrivateKey key = (UBPrivateKey)object;
                UBCertificate found = null;
                for (int i = 0; i < certs.length; ++i) {
                    UBCertificate cert = (UBCertificate)certs[i];
                    if (cert == null || !cert.match(key.pub)) continue;
                    found = cert;
                    certs[i] = null;
                    break;
                }
                Entry entry = null;
                entry = found == null ? new Entry(key) : new Entry(key, found, found.getChain(certs));
                cache.put(key.name.toUpperCase(), entry);
                ++object2;
            }
            uBObjectArray = certs;
            n = uBObjectArray.length;
            boolean bl2 = false;
            while (var10_17 < n) {
                object = uBObjectArray[var10_17];
                UBCertificate cert = (UBCertificate)object;
                if (cert != null) {
                    Entry entry = new Entry(cert);
                    cache.put(cert.name.toUpperCase(), entry);
                }
                ++var10_17;
            }
            long[] symIds = this.partition.locate(2, 0);
            for (UBObject object3 : symKeys = UBObject.read(this.partition, symIds, false)) {
                UBSecretKey key = (UBSecretKey)object3;
                Entry entry = new Entry(key);
                cache.put(key.name.toUpperCase(), entry);
            }
            UBKeyStore uBKeyStore2 = this;
            synchronized (uBKeyStore2) {
                this.cache = cache;
                this.lastCacheClock = clock.millis();
            }
            return this.getAliases();
        }
        catch (IOException | CertificateException | InvalidKeySpecException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        Entry entry = null;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry != null;
    }

    @Override
    public int engineSize() {
        return 0;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Entry entry = null;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry != null && (entry.secretKey != null || entry.prvKey != null);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        Entry entry = null;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry != null && entry.isTrustedCert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        X509Certificate x509 = (X509Certificate)cert;
        UBKeyStore uBKeyStore = this;
        synchronized (uBKeyStore) {
            for (Entry entry : this.cache.values()) {
                if (entry.cert == null || !entry.cert.x509.equals(cert)) continue;
                return entry.getName();
            }
        }
        try {
            UBCertificate certificate = UBCertificate.locate(this.partition, x509);
            if (certificate == null) {
                return null;
            }
            long keyUid = UBCertificate.getKeyUid(x509);
            UBPrivateKey key = null;
            try {
                key = (UBPrivateKey)UBObject.read(this.partition, keyUid, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Entry entry = key == null ? new Entry(certificate) : new Entry(key, certificate, null);
            UBKeyStore uBKeyStore2 = this;
            synchronized (uBKeyStore2) {
                this.cache.put(entry.getName().toUpperCase(), entry);
            }
            return entry.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (password != null && password.length != 0) {
            this.partition.login(new String(password));
        }
    }

    private static final class FilteredAliases
    implements Enumeration {
        private Iterator<Map.Entry<String, Entry>> it;
        private Map.Entry<String, Entry> next = null;

        FilteredAliases(Map<String, Entry> map) {
            this.it = map.entrySet().iterator();
        }

        private void findNext() {
            if (this.next != null) {
                return;
            }
            while (this.it.hasNext()) {
                Map.Entry<String, Entry> element = this.it.next();
                if (element.getValue().isOrphanPrvKey()) continue;
                this.next = element;
                break;
            }
        }

        @Override
        public boolean hasMoreElements() {
            this.findNext();
            return this.next != null;
        }

        public String nextElement() throws NoSuchElementException {
            this.findNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            String result = this.next.getKey();
            this.next = null;
            return result;
        }
    }

    static final class Entry {
        UBPrivateKey prvKey = null;
        UBCertificate cert = null;
        Certificate[] chain = null;
        UBSecretKey secretKey = null;

        Entry(UBPrivateKey key, UBCertificate cert, Certificate[] chain) throws InvalidKeySpecException, CertificateException, IOException {
            this.prvKey = key;
            this.cert = cert;
            if (chain == null) {
                chain = cert.getChain();
            }
            this.chain = chain;
        }

        Entry(UBPrivateKey key) {
            this.prvKey = key;
        }

        Entry(UBCertificate cert) {
            this.cert = cert;
        }

        Entry(UBSecretKey secret) {
            this.secretKey = secret;
        }

        String getName() {
            if (this.secretKey != null) {
                return this.secretKey.name;
            }
            return this.isTrustedCert() ? this.cert.name : this.prvKey.name;
        }

        boolean isTrustedCert() {
            return this.prvKey == null && this.secretKey == null;
        }

        boolean isOrphanPrvKey() {
            return this.prvKey != null && this.cert == null;
        }
    }
}

