/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyParameters;
import com.unbound.common.Converter;
import com.unbound.common.HEX;
import com.unbound.common.Log;
import com.unbound.provider.Partition;
import com.unbound.provider.UBCertificate;
import com.unbound.provider.UBPrivateKey;
import com.unbound.provider.UBSecretKey;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.attribute.Attributes;
import com.unbound.provider.kmip.attribute.BoolAttribute;
import com.unbound.provider.kmip.attribute.DateAttribute;
import com.unbound.provider.kmip.attribute.EnumAttribute;
import com.unbound.provider.kmip.attribute.Name;
import com.unbound.provider.kmip.request.DestroyRequest;
import com.unbound.provider.kmip.request.LocateRequest;
import com.unbound.provider.kmip.request.ModifyAttributeRequest;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.request.RevokeRequest;
import com.unbound.provider.kmip.response.GetAttributesResponse;
import com.unbound.provider.kmip.response.GetResponse;
import com.unbound.provider.kmip.response.ResponseMessage;
import java.io.IOException;
import java.security.ProviderException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;

abstract class UBObject {
    Partition partition;
    long uid;
    String name;
    long initialDate;

    abstract int kmipObjectType();

    static long strToUid(String str) {
        if (((String)str).length() == 16) {
            str = "0x00" + (String)str;
        }
        if (((String)str).length() == 20 && ((String)str).charAt(0) == '0' && ((String)str).charAt(1) == 'x' && ((String)str).charAt(2) == '0' && ((String)str).charAt(3) == '0') {
            long uid = 0L;
            for (int i = 4; i < 20; i += 2) {
                int hi = HEX.from(((String)str).charAt(i));
                int lo = HEX.from(((String)str).charAt(i + 1));
                if (lo < 0 || hi < 0) {
                    return 0L;
                }
                uid = uid << 8 | (long)(hi << 4) | (long)lo;
            }
            return uid;
        }
        return 0L;
    }

    static String uidToStr(long uid) {
        byte[] cka_id = new byte[9];
        cka_id[0] = 0;
        Converter.setBE8(cka_id, 1, uid);
        char[] out = new char[20];
        out[0] = 48;
        out[1] = 120;
        for (int i = 0; i < cka_id.length; ++i) {
            out[2 + i * 2 + 0] = HEX.chars[cka_id[i] >> 4 & 0xF];
            out[2 + i * 2 + 1] = HEX.chars[cka_id[i] & 0xF];
        }
        return new String(out);
    }

    UBObject(Partition partition) {
        this.partition = partition;
    }

    UBObject(Partition partition, long uid, GetAttributesResponse getAttrResp) {
        this.partition = partition;
        this.uid = uid;
        this.name = ((Name)getAttrResp.attrs.get((int)2)).value;
        this.initialDate = ((DateAttribute)getAttrResp.attrs.get((int)3)).value;
    }

    static UBObject[] read(Partition partition, long[] uids, boolean get) throws CertificateException, InvalidKeySpecException, IOException {
        if (uids.length == 0) {
            return new UBObject[0];
        }
        ResponseMessage respMsg = partition.read(uids, get);
        UBObject[] list = new UBObject[uids.length];
        int n = 0;
        for (int i = 0; i < uids.length; ++i) {
            GetAttributesResponse getAttrResp = (GetAttributesResponse)respMsg.batch.get(n++);
            GetResponse getResp = null;
            if (get) {
                getResp = (GetResponse)respMsg.batch.get(n++);
            }
            list[i] = UBObject.newObject(partition, uids[i], getAttrResp, getResp);
        }
        return list;
    }

    static UBObject read(Partition partition, long uid, boolean get) throws CertificateException, InvalidKeySpecException, IOException {
        Log log = Log.func("UBObject.read").logHex("uid", uid).log("get", get).end();
        try {
            ResponseMessage respMsg = partition.read(uid, get);
            GetAttributesResponse getAttrResp = (GetAttributesResponse)respMsg.batch.get(0);
            GetResponse getResp = get ? (GetResponse)respMsg.batch.get(1) : null;
            UBObject uBObject = UBObject.newObject(partition, uid, getAttrResp, getResp);
            return uBObject;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    private static UBObject newObject(Partition partition, long uid, GetAttributesResponse getAttrResp, GetResponse getResp) throws CertificateException, InvalidKeySpecException {
        int objectType = ((EnumAttribute)getAttrResp.attrs.get((int)0)).value;
        switch (objectType) {
            case 4: {
                return UBPrivateKey.newPrivateKey(partition, uid, getAttrResp, getResp);
            }
            case 1: {
                return new UBCertificate(partition, uid, getAttrResp, getResp);
            }
            case 2: {
                return new UBSecretKey(partition, uid, getAttrResp);
            }
        }
        throw new ProviderException("Unsupported object type");
    }

    static LocateRequest locateRequest(int objectType, int kmipAlg, String alias) {
        LocateRequest req = new LocateRequest();
        req.maxItems = 1;
        req.attrs.add(new EnumAttribute(KMIP.Tag.State, 2));
        req.attrs.add(new EnumAttribute(KMIP.Tag.ObjectType, objectType));
        if (kmipAlg != 0) {
            req.attrs.add(new EnumAttribute(KMIP.Tag.CryptographicAlgorithm, kmipAlg));
        }
        if (alias != null) {
            req.attrs.add(new Name(alias));
        }
        return req;
    }

    static void delete(Partition partition, UBObject obj1) throws IOException {
        UBObject.delete(partition, obj1, null, null);
    }

    static void delete(Partition partition, UBObject obj1, UBObject obj2) throws IOException {
        UBObject.delete(partition, obj1, obj2, null);
    }

    static void delete(Partition partition, UBObject obj1, UBObject obj2, UBObject obj3) throws IOException {
        long uid1 = obj1 == null ? 0L : obj1.uid;
        long uid2 = obj2 == null ? 0L : obj2.uid;
        long uid3 = obj3 == null ? 0L : obj3.uid;
        Log log = Log.func("UBObject.delete").logHex("uid1", uid1).logHex("uid2", uid2).logHex("uid3", uid3).end();
        try {
            DestroyRequest d;
            RevokeRequest r;
            RequestMessage reqMsg = new RequestMessage();
            if (obj1 != null) {
                r = new RevokeRequest();
                r.uid = UBObject.uidToStr(obj1.uid);
                d = new DestroyRequest();
                reqMsg.batch.add(r);
                reqMsg.batch.add(d);
            }
            if (obj2 != null) {
                r = new RevokeRequest();
                r.uid = UBObject.uidToStr(obj2.uid);
                d = new DestroyRequest();
                reqMsg.batch.add(r);
                reqMsg.batch.add(d);
            }
            if (obj3 != null) {
                r = new RevokeRequest();
                r.uid = UBObject.uidToStr(obj3.uid);
                d = new DestroyRequest();
                reqMsg.batch.add(r);
                reqMsg.batch.add(d);
            }
            partition.transmit(reqMsg);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    void setName(String name) throws IOException {
        Log log = Log.func("UBObject.setName").logHex("uid", this.uid).log("name", name).end();
        try {
            if (this.name.equals(name)) {
                return;
            }
            ModifyAttributeRequest req = new ModifyAttributeRequest();
            req.uid = UBObject.uidToStr(this.uid);
            req.attribute = new Name(name);
            this.partition.transmit(req);
            this.name = name;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    static int updateKmipKeyUsageMask(KeyParameters kp, int mask, boolean symmetric) {
        int m;
        if (kp == null) {
            return mask;
        }
        if (kp.isSetSign()) {
            int n = m = symmetric ? 128 : 1;
            mask = kp.isAllowSign() ? (mask |= m) : (mask &= ~m);
        }
        if (kp.isSetVerify()) {
            int n = m = symmetric ? 256 : 2;
            mask = kp.isAllowVerify() ? (mask |= m) : (mask &= ~m);
        }
        if (kp.isSetEncrypt()) {
            m = 4;
            mask = kp.isAllowEncrypt() ? (mask |= m) : (mask &= ~m);
        }
        if (kp.isSetDecrypt()) {
            m = 8;
            mask = kp.isAllowDecrypt() ? (mask |= m) : (mask &= ~m);
        }
        if (kp.isSetWrap()) {
            m = 16;
            mask = kp.isAllowWrap() ? (mask |= m) : (mask &= ~m);
        }
        if (kp.isSetUnwrap()) {
            m = 32;
            mask = kp.isAllowUnwrap() ? (mask |= m) : (mask &= ~m);
        }
        if (kp.isSetDerive()) {
            m = 512;
            mask = kp.isAllowDerive() ? (mask |= m) : (mask &= ~m);
        }
        return mask;
    }

    static void updateAttrs(KeyParameters kp, Attributes attrs) {
        if (kp == null) {
            return;
        }
        if (kp.isTrusted()) {
            attrs.add(new BoolAttribute(KMIP.Tag.CKA_TRUSTED, true));
        }
        switch (kp.getExportProtection()) {
            case 3: {
                break;
            }
            case 2: {
                attrs.add(new BoolAttribute(KMIP.Tag.CKA_EXTRACTABLE, true));
                attrs.add(new BoolAttribute(KMIP.Tag.CKA_WRAP_WITH_TRUSTED, true));
                break;
            }
            case 1: {
                attrs.add(new BoolAttribute(KMIP.Tag.CKA_EXTRACTABLE, true));
                break;
            }
            case 0: {
                attrs.add(new BoolAttribute(KMIP.Tag.CKA_SENSITIVE, false));
            }
        }
    }
}

