/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyParameters;
import com.unbound.common.Log;
import com.unbound.common.crypto.EC;
import com.unbound.provider.Partition;
import com.unbound.provider.UBECPrivateKey;
import com.unbound.provider.UBObject;
import com.unbound.provider.UBRSAPrivateKey;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.attribute.DateAttribute;
import com.unbound.provider.kmip.attribute.EnumAttribute;
import com.unbound.provider.kmip.attribute.IntAttribute;
import com.unbound.provider.kmip.attribute.KeyWrappingData;
import com.unbound.provider.kmip.attribute.KeyWrappingInfo;
import com.unbound.provider.kmip.attribute.Name;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.object.ManagedObject;
import com.unbound.provider.kmip.object.PrivateKey;
import com.unbound.provider.kmip.request.ActivateRequest;
import com.unbound.provider.kmip.request.CreateKeyPairRequest;
import com.unbound.provider.kmip.request.GetAttributesRequest;
import com.unbound.provider.kmip.request.GetRequest;
import com.unbound.provider.kmip.request.RegisterRequest;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.request.SignRequest;
import com.unbound.provider.kmip.response.CreateKeyPairResponse;
import com.unbound.provider.kmip.response.GetAttributesResponse;
import com.unbound.provider.kmip.response.GetResponse;
import com.unbound.provider.kmip.response.RegisterResponse;
import com.unbound.provider.kmip.response.ResponseMessage;
import com.unbound.provider.kmip.response.SignResponse;
import java.io.IOException;
import java.security.Key;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

abstract class UBPrivateKey
extends UBObject
implements java.security.PrivateKey {
    PublicKey pub = null;

    UBPrivateKey(Partition partition) {
        super(partition);
    }

    @Override
    int kmipObjectType() {
        return 4;
    }

    abstract int getKmipAlg();

    abstract int getDefaultUsageMask();

    abstract ManagedObject prepareManagedObject(KeySpec var1) throws InvalidKeySpecException;

    abstract ManagedObject prepareManagedObject(java.security.PrivateKey var1) throws InvalidKeySpecException;

    abstract PublicKey convertResponseToPublicKey(GetResponse var1) throws InvalidKeySpecException;

    abstract TemplateAttribute prepareGenerateTemplate(KeyParameters var1, int var2, EC.Curve var3);

    UBPrivateKey(Partition partition, long uid, GetAttributesResponse getAttrResp) {
        super(partition, uid, getAttrResp);
    }

    static UBPrivateKey newPrivateKey(Partition partition, long uid, GetAttributesResponse getAttrResp, GetResponse getResp) throws InvalidKeySpecException {
        UBPrivateKey key;
        int keyType = ((EnumAttribute)getAttrResp.attrs.get((int)1)).value;
        switch (keyType) {
            case -2147483647: {
                key = new UBECPrivateKey(partition, uid, getAttrResp);
                break;
            }
            case 26: {
                key = new UBECPrivateKey(partition, uid, getAttrResp);
                break;
            }
            case 4: {
                key = new UBRSAPrivateKey(partition, uid, getAttrResp);
                break;
            }
            default: {
                throw new ProviderException("Unsupported key type");
            }
        }
        key.pub = key.convertResponseToPublicKey(getResp);
        return key;
    }

    static UBPrivateKey newPrivateKey(KeyParameters keyParameter, Partition partition, String alias, Key key) throws InvalidKeySpecException, IOException {
        if (key instanceof RSAPrivateCrtKey) {
            UBRSAPrivateKey rsa = new UBRSAPrivateKey(partition);
            rsa.register(keyParameter, alias, (java.security.PrivateKey)key);
            return rsa;
        }
        if (key instanceof ECPrivateKey) {
            UBECPrivateKey ecc = new UBECPrivateKey(partition);
            ecc.register(keyParameter, alias, (java.security.PrivateKey)key);
            return ecc;
        }
        throw new ProviderException("Unsupported key type");
    }

    void generate(KeyParameters keyParameter, int bitSize, EC.Curve curve) throws InvalidKeySpecException, IOException {
        Log log = Log.func("UBPrivateKey.generate").log("bitSize", bitSize).end();
        try {
            RequestMessage reqMsg = new RequestMessage();
            CreateKeyPairRequest reqCreateKeyPair = new CreateKeyPairRequest();
            reqMsg.batch.add(reqCreateKeyPair);
            reqCreateKeyPair.prv = this.prepareGenerateTemplate(keyParameter, bitSize, curve);
            ActivateRequest reqActivate = new ActivateRequest();
            reqMsg.batch.add(reqActivate);
            GetAttributesRequest reqGetAttr = new GetAttributesRequest();
            reqMsg.batch.add(reqGetAttr);
            reqGetAttr.names.add("Name");
            reqGetAttr.names.add("Initial Date");
            GetRequest reqGet = new GetRequest();
            reqMsg.batch.add(reqGet);
            reqGet.formatType = 5;
            ResponseMessage respMsg = this.partition.transmit(reqMsg);
            CreateKeyPairResponse respCreateKeyPair = (CreateKeyPairResponse)respMsg.batch.get(0);
            GetAttributesResponse respGetAttr = (GetAttributesResponse)respMsg.batch.get(2);
            GetResponse respGet = (GetResponse)respMsg.batch.get(3);
            this.uid = UBPrivateKey.strToUid(respCreateKeyPair.prvUID);
            this.name = ((Name)respGetAttr.attrs.get((int)0)).value;
            this.initialDate = ((DateAttribute)respGetAttr.attrs.get((int)1)).value;
            this.pub = this.convertResponseToPublicKey(respGet);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("UID", this.uid).end();
        }
    }

    void register(KeyParameters keyParameter, String alias, int kmipAlg, int kmipUsage, RegisterRequest reqRegister, ManagedObject managedObject) throws InvalidKeySpecException, IOException {
        Log log = Log.func("UBPrivateKey.register").log("kmipAlg", kmipAlg).end();
        try {
            RequestMessage reqMsg = new RequestMessage();
            if (reqRegister == null) {
                reqRegister = new RegisterRequest();
            }
            reqMsg.batch.add(reqRegister);
            reqRegister.objectType = 4;
            reqRegister.template = new TemplateAttribute();
            if (keyParameter != null) {
                kmipUsage = UBPrivateKey.updateKmipKeyUsageMask(keyParameter, kmipUsage, false);
                UBPrivateKey.updateAttrs(keyParameter, reqRegister.template.attrs);
            }
            reqRegister.template.attrs.add(new EnumAttribute(KMIP.Tag.CryptographicAlgorithm, kmipAlg));
            reqRegister.template.attrs.add(new IntAttribute(KMIP.Tag.CryptographicUsageMask, kmipUsage));
            if (alias != null) {
                reqRegister.template.attrs.add(new Name(alias));
            }
            reqRegister.object = managedObject;
            ActivateRequest reqActivate = new ActivateRequest();
            reqMsg.batch.add(reqActivate);
            GetAttributesRequest reqGetAttr = new GetAttributesRequest();
            reqMsg.batch.add(reqGetAttr);
            reqGetAttr.names.add("Name");
            reqGetAttr.names.add("Initial Date");
            GetRequest reqGet = new GetRequest();
            reqMsg.batch.add(reqGet);
            reqGet.formatType = 5;
            ResponseMessage respMsg = this.partition.transmit(reqMsg);
            RegisterResponse respRegister = (RegisterResponse)respMsg.batch.get(0);
            GetAttributesResponse respGetAttr = (GetAttributesResponse)respMsg.batch.get(2);
            GetResponse respGet = (GetResponse)respMsg.batch.get(3);
            this.uid = UBPrivateKey.strToUid(respRegister.uid);
            this.name = alias == null ? ((Name)respGetAttr.attrs.get((int)0)).value : alias;
            this.initialDate = ((DateAttribute)respGetAttr.attrs.get((int)1)).value;
            this.pub = this.convertResponseToPublicKey(respGet);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("uid", this.uid).end();
        }
    }

    static UBPrivateKey locate(Partition partition, int kmipAlgType, String alias) throws InvalidKeySpecException, CertificateException, IOException {
        long uid = 0L;
        Log log = Log.func("UBPrivateKey.locate").log("kmipAlgType", kmipAlgType).log("alias", alias).end();
        try {
            uid = partition.locate(4, 0, alias);
            if (uid == 0L) {
                UBPrivateKey uBPrivateKey = null;
                return uBPrivateKey;
            }
            UBPrivateKey uBPrivateKey = (UBPrivateKey)UBObject.read(partition, uid, true);
            return uBPrivateKey;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("uid", uid).end();
        }
    }

    byte[] sign(byte[] in, int kmipAlg, int kmipSigAlg) throws IOException {
        Log log = Log.func("UBPrivateKey.sign").log("kmipAlg", kmipAlg).log("kmipSigAlg", kmipSigAlg).log("in.length", in.length).end();
        try {
            SignRequest req = new SignRequest();
            req.uid = UBPrivateKey.uidToStr(this.uid);
            req.data = in;
            req.params = new CryptoParams();
            req.params.cryptoAlg = kmipAlg;
            if (kmipAlg == 4) {
                req.params.padding = 8;
            }
            if (kmipSigAlg != 0) {
                req.params.signingAlg = kmipSigAlg;
            }
            SignResponse resp = (SignResponse)this.partition.transmit(req);
            byte[] byArray = resp.data;
            return byArray;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    void register(KeyParameters keyParameter, String alias, java.security.PrivateKey key) throws InvalidKeySpecException, IOException {
        Log log = Log.func("UBPrivateKey.register").log("alias", alias).end();
        try {
            this.register(keyParameter, alias, this.getKmipAlg(), this.getDefaultUsageMask(), null, this.prepareManagedObject(key));
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    void register(KeyParameters keyParameter, KeySpec keySpec) throws InvalidKeySpecException, IOException {
        this.register(keyParameter, null, this.getKmipAlg(), this.getDefaultUsageMask(), null, this.prepareManagedObject(keySpec));
    }

    void unwrap(KeyParameters keyParameter, RegisterRequest req, long unwrappingKeyUid, CryptoParams kmipParams, byte[] wrapped) throws IOException, InvalidKeySpecException {
        Log log = Log.func("UBPrivateKey.unwrap").end();
        try {
            PrivateKey managedObject = new PrivateKey();
            req.objectType = 4;
            req.object = managedObject;
            managedObject.keyBlock.buf = wrapped;
            managedObject.keyBlock.formatType = 1;
            managedObject.keyBlock.keyWrap = new KeyWrappingData();
            managedObject.keyBlock.keyWrap.encKey = new KeyWrappingInfo();
            managedObject.keyBlock.keyWrap.encKey.uid = UBPrivateKey.uidToStr(unwrappingKeyUid);
            managedObject.keyBlock.keyWrap.encKey.params = kmipParams;
            this.register(keyParameter, null, this.getKmipAlg(), this.getDefaultUsageMask(), req, managedObject);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("UID", this.uid).end();
        }
    }
}

