/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.dyadicsec.provider.KeyParameters;
import com.unbound.common.Log;
import com.unbound.provider.Partition;
import com.unbound.provider.UBObject;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.attribute.DateAttribute;
import com.unbound.provider.kmip.attribute.EnumAttribute;
import com.unbound.provider.kmip.attribute.IntAttribute;
import com.unbound.provider.kmip.attribute.KeyWrappingData;
import com.unbound.provider.kmip.attribute.KeyWrappingInfo;
import com.unbound.provider.kmip.attribute.Name;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.object.SymmetricKey;
import com.unbound.provider.kmip.request.ActivateRequest;
import com.unbound.provider.kmip.request.CreateRequest;
import com.unbound.provider.kmip.request.GetAttributesRequest;
import com.unbound.provider.kmip.request.RegisterRequest;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.response.CreateResponse;
import com.unbound.provider.kmip.response.GetAttributesResponse;
import com.unbound.provider.kmip.response.RegisterResponse;
import com.unbound.provider.kmip.response.ResponseMessage;
import java.io.IOException;
import java.security.Key;
import java.security.ProviderException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;

public class UBSecretKey
extends UBObject
implements SecretKey {
    int kmipAlg;

    UBSecretKey(Partition partition, int kmipAlg) {
        super(partition);
        this.kmipAlg = kmipAlg;
    }

    int getKmipAlg() {
        return this.kmipAlg;
    }

    UBSecretKey(Partition partition, long uid, GetAttributesResponse getAttrResp) {
        super(partition, uid, getAttrResp);
    }

    static UBSecretKey newSecretKey(KeyParameters keyParameter, Partition partition, String alias, Key key) throws IOException {
        if (!(key instanceof SecretKey)) {
            throw new ProviderException("Unsupported key type");
        }
        String alg = key.getAlgorithm();
        int kmipAlg = 0;
        if (alg.equalsIgnoreCase("AES")) {
            kmipAlg = 3;
        } else if (alg.equalsIgnoreCase("HMAC")) {
            kmipAlg = 9;
        } else {
            throw new ProviderException("Unsupported algorithm");
        }
        UBSecretKey secret = new UBSecretKey(partition, kmipAlg);
        secret.register(keyParameter, ((SecretKey)key).getEncoded(), alias);
        return secret;
    }

    static UBSecretKey locate(Partition partition, String alias) throws CertificateException, InvalidKeySpecException, IOException {
        long uid = 0L;
        Log log = Log.func("UBSecretKey.locate").log("alias", alias).end();
        try {
            uid = partition.locate(2, 0, alias);
            if (uid == 0L) {
                UBSecretKey uBSecretKey = null;
                return uBSecretKey;
            }
            UBSecretKey uBSecretKey = (UBSecretKey)UBObject.read(partition, uid, false);
            return uBSecretKey;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("uid", uid).end();
        }
    }

    static UBSecretKey read(Partition partition, long uid) throws IOException {
        ResponseMessage resp = partition.read(uid, false);
        GetAttributesResponse getAttrResp = (GetAttributesResponse)resp.batch.get(0);
        return new UBSecretKey(partition, uid, getAttrResp);
    }

    private void register(KeyParameters keyParameter, RegisterRequest reqRegister, String alias) throws IOException {
        Log log = Log.func("UBSecretKey.register").log("alias", alias).end();
        try {
            int kmipUsage = 384;
            if (this.kmipAlg == 3) {
                kmipUsage |= 0xC;
            }
            RequestMessage reqMsg = new RequestMessage();
            reqRegister.template = new TemplateAttribute();
            if (keyParameter != null) {
                kmipUsage = UBSecretKey.updateKmipKeyUsageMask(keyParameter, kmipUsage, true);
                UBSecretKey.updateAttrs(keyParameter, reqRegister.template.attrs);
            }
            reqRegister.template.attrs.add(new EnumAttribute(KMIP.Tag.CryptographicAlgorithm, this.kmipAlg));
            reqRegister.template.attrs.add(new IntAttribute(KMIP.Tag.CryptographicUsageMask, kmipUsage));
            if (alias != null) {
                reqRegister.template.attrs.add(new Name(alias));
            }
            reqMsg.batch.add(reqRegister);
            ActivateRequest reqActivate = new ActivateRequest();
            reqMsg.batch.add(reqActivate);
            GetAttributesRequest reqGetAttr = new GetAttributesRequest();
            reqMsg.batch.add(reqGetAttr);
            reqGetAttr.names.add("Name");
            reqGetAttr.names.add("Initial Date");
            ResponseMessage respMsg = this.partition.transmit(reqMsg);
            RegisterResponse respRegister = (RegisterResponse)respMsg.batch.get(0);
            GetAttributesResponse respGetAttr = (GetAttributesResponse)respMsg.batch.get(2);
            this.uid = UBSecretKey.strToUid(respRegister.uid);
            this.name = alias == null ? ((Name)respGetAttr.attrs.get((int)0)).value : alias;
            this.initialDate = ((DateAttribute)respGetAttr.attrs.get((int)1)).value;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("UID", this.uid).end();
        }
    }

    void register(KeyParameters keyParameter, byte[] keyValue, String alias) throws IOException {
        Log log = Log.func("UBSecretKey.register").log("bitSize", keyValue.length * 8).end();
        try {
            RegisterRequest reqRegister = new RegisterRequest();
            SymmetricKey symmetricKey = new SymmetricKey();
            symmetricKey.keyBlock.formatType = 1;
            symmetricKey.keyBlock.buf = keyValue;
            reqRegister.objectType = 2;
            reqRegister.object = symmetricKey;
            this.register(keyParameter, reqRegister, alias);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("UID", this.uid).end();
        }
    }

    void generate(KeyParameters keyParameter, int bitSize) throws IOException {
        Log log = Log.func("UBSecretKey.generate").log("bitSize", bitSize).end();
        try {
            RequestMessage reqMsg = new RequestMessage();
            CreateRequest reqCreate = new CreateRequest();
            reqMsg.batch.add(reqCreate);
            reqCreate.template = new TemplateAttribute();
            reqCreate.objectType = 2;
            int kmipUsage = 384;
            if (this.kmipAlg == 3) {
                kmipUsage |= 0xC;
            }
            if (keyParameter != null) {
                kmipUsage = UBSecretKey.updateKmipKeyUsageMask(keyParameter, kmipUsage, true);
                UBSecretKey.updateAttrs(keyParameter, reqCreate.template.attrs);
            }
            reqCreate.template.attrs.add(new EnumAttribute(KMIP.Tag.CryptographicAlgorithm, this.kmipAlg));
            reqCreate.template.attrs.add(new IntAttribute(KMIP.Tag.CryptographicLength, bitSize));
            reqCreate.template.attrs.add(new IntAttribute(KMIP.Tag.CryptographicUsageMask, kmipUsage));
            ActivateRequest reqActivate = new ActivateRequest();
            reqMsg.batch.add(reqActivate);
            GetAttributesRequest reqGetAttr = new GetAttributesRequest();
            reqMsg.batch.add(reqGetAttr);
            reqGetAttr.names.add("Name");
            reqGetAttr.names.add("Initial Date");
            ResponseMessage respMsg = this.partition.transmit(reqMsg);
            CreateResponse respCreate = (CreateResponse)respMsg.batch.get(0);
            GetAttributesResponse respGetAttr = (GetAttributesResponse)respMsg.batch.get(2);
            this.uid = UBSecretKey.strToUid(respCreate.uid);
            this.name = ((Name)respGetAttr.attrs.get((int)0)).value;
            this.initialDate = ((DateAttribute)respGetAttr.attrs.get((int)1)).value;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("UID", this.uid).end();
        }
    }

    void unwrap(KeyParameters keyParameter, RegisterRequest req, long unwrappingKeyUid, CryptoParams kmipParams, byte[] wrapped) throws IOException {
        Log log = Log.func("UBSecretKey.unwrap").end();
        try {
            SymmetricKey managedObject = new SymmetricKey();
            req.objectType = 2;
            req.object = managedObject;
            managedObject.keyBlock.buf = wrapped;
            managedObject.keyBlock.formatType = 1;
            managedObject.keyBlock.keyWrap = new KeyWrappingData();
            managedObject.keyBlock.keyWrap.encKey = new KeyWrappingInfo();
            managedObject.keyBlock.keyWrap.encKey.uid = UBSecretKey.uidToStr(unwrappingKeyUid);
            managedObject.keyBlock.keyWrap.encKey.params = kmipParams;
            this.register(keyParameter, req, null);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("UID", this.uid).end();
        }
    }

    @Override
    int kmipObjectType() {
        return 2;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        throw new ProviderException("Function not supported");
    }

    @Override
    public String getAlgorithm() {
        if (this.kmipAlg == 3) {
            return "AES";
        }
        return "Hmac";
    }
}

