/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip;

import com.unbound.common.Converter;
import com.unbound.common.HEX;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.attribute.BigNumAttribute;
import com.unbound.provider.kmip.request.RequestItem;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.response.ResponseItem;
import com.unbound.provider.kmip.response.ResponseMessage;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class KMIPConverter {
    private boolean write = false;
    private int offset = 0;
    private int size = 0;
    private byte[] pointer = null;

    public KMIPConverter() {
    }

    public KMIPConverter(byte[] in) {
        this.pointer = in;
        this.size = in.length;
    }

    private KMIPConverter(boolean write, byte[] pointer, int offset, int size) {
        this.write = write;
        this.pointer = pointer;
        this.offset = offset;
        this.size = size;
    }

    private static int padLength(int length) {
        return length + 7 & 0xFFFFFFF8;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getNextTag() {
        if (this.offset + 8 > this.size) {
            return 0;
        }
        return Converter.getBE4(this.pointer, this.offset);
    }

    public static void setError(String message) throws KMIPConvertException {
        throw new KMIPConvertException(message);
    }

    private int readTag(int tag) throws KMIPConvertException {
        byte tagMode;
        int length;
        int tag2;
        if (this.offset + 8 > this.size) {
            KMIPConverter.setError("Invalid length");
        }
        if ((tag2 = Converter.getBE4(this.pointer, this.offset)) != tag) {
            KMIPConverter.setError("Unexpected tag 0x" + HEX.toString(tag2));
        }
        if (this.offset + 8 + KMIPConverter.padLength(length = Converter.getBE4(this.pointer, this.offset + 4)) > this.size) {
            KMIPConverter.setError("Invalid length");
        }
        if ((tagMode = (byte)(tag >> 24)) != 66 && tagMode != 84) {
            KMIPConverter.setError("Unexpected tag 0x" + HEX.toString(tag2));
        }
        byte tagType = (byte)tag;
        switch (tagType) {
            case 3: {
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                if (length == 8) break;
                KMIPConverter.setError("Invalid date length");
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 10: {
                if (length == 4) break;
                KMIPConverter.setError("Invalid interval length");
                break;
            }
            case 1: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                KMIPConverter.setError("Invalid tag type 0x" + HEX.toString(tagType));
            }
        }
        this.offset += 8;
        return length;
    }

    public int convertTag(int tag, int length, boolean present) throws KMIPConvertException {
        if (this.write) {
            if (!present) {
                return -1;
            }
            if (this.pointer != null) {
                Converter.setBE4(this.pointer, this.offset, tag);
                Converter.setBE4(this.pointer, this.offset + 4, length);
            }
            this.offset += 8;
            return length;
        }
        int tag2 = this.getNextTag();
        boolean bl = present = tag2 == tag;
        if (!present) {
            return -1;
        }
        return this.readTag(tag);
    }

    public void skip(int tag) throws KMIPConvertException {
        int length;
        assert (!this.write);
        while (tag == this.getNextTag() && (length = this.readTag(tag)) >= 0) {
            int pad = KMIPConverter.padLength(length);
            this.offset += pad;
        }
    }

    public Boolean convertOptional(int tag, Boolean value) throws KMIPConvertException {
        assert ((byte)tag == 6);
        if (0 > this.convertTag(tag, 8, value != null)) {
            return null;
        }
        if (this.write) {
            if (this.pointer != null) {
                this.pointer[this.offset + 6] = 0;
                this.pointer[this.offset + 5] = 0;
                this.pointer[this.offset + 4] = 0;
                this.pointer[this.offset + 3] = 0;
                this.pointer[this.offset + 2] = 0;
                this.pointer[this.offset + 1] = 0;
                this.pointer[this.offset + 0] = 0;
                this.pointer[this.offset + 7] = value != null && value != false ? (byte)1 : 0;
            }
        } else {
            value = this.pointer[this.offset + 7] != 0;
        }
        this.offset += 8;
        return value;
    }

    public Boolean convert(int tag, Boolean value) throws KMIPConvertException {
        if (this.write && value == null) {
            KMIPConverter.setError("Expected write for tag 0x" + HEX.toString(tag));
        }
        Boolean newValue = this.convertOptional(tag, value);
        if (!this.write && newValue == null) {
            KMIPConverter.setError("Expected read for tag 0x" + HEX.toString(tag));
        }
        return newValue;
    }

    public Integer convertOptional(int tag, Integer value) throws KMIPConvertException {
        return this.convertOptional(tag, value, 0);
    }

    public Integer convertOptional(int tag, Integer value, int actualTag) throws KMIPConvertException {
        assert ((byte)tag == 2 || (byte)tag == 5 || (byte)tag == 10);
        if (0 > this.convertTag(tag, 4, value != null)) {
            return null;
        }
        if (this.write) {
            if (this.pointer != null) {
                Converter.setBE4(this.pointer, this.offset, value == null ? 0 : value);
                this.pointer[this.offset + 7] = 0;
                this.pointer[this.offset + 6] = 0;
                this.pointer[this.offset + 5] = 0;
                this.pointer[this.offset + 4] = 0;
            }
        } else {
            value = Converter.getBE4(this.pointer, this.offset);
        }
        this.offset += 8;
        return value;
    }

    public Integer convert(int tag, Integer value) throws KMIPConvertException {
        return this.convert(tag, value, 0);
    }

    public Integer convert(int tag, Integer value, int actualTag) throws KMIPConvertException {
        if (this.write && value == null) {
            KMIPConverter.setError("Expected write for tag 0x" + HEX.toString(tag));
        }
        Integer newValue = this.convertOptional(tag, value, actualTag);
        if (!this.write && newValue == null) {
            KMIPConverter.setError("Expected read for tag 0x" + HEX.toString(tag));
        }
        return newValue;
    }

    public Long convertOptional(int tag, Long value) throws KMIPConvertException {
        assert ((byte)tag == 3 || (byte)tag == 9);
        if (0 > this.convertTag(tag, 8, value != null)) {
            return null;
        }
        if (this.write) {
            if (this.pointer != null) {
                Converter.setBE8(this.pointer, this.offset, value == null ? 0L : value);
            }
        } else {
            value = Converter.getBE8(this.pointer, this.offset);
        }
        this.offset += 8;
        return value;
    }

    public Long convert(int tag, Long value) throws KMIPConvertException {
        if (this.write && value == null) {
            KMIPConverter.setError("Expected write for tag 0x" + HEX.toString(tag));
        }
        Long newValue = this.convertOptional(tag, value);
        if (!this.write && newValue == null) {
            KMIPConverter.setError("Expected read for tag 0x" + HEX.toString(tag));
        }
        return newValue;
    }

    public String convertOptional(int tag, String value) throws KMIPConvertException {
        assert ((byte)tag == 7);
        byte[] utf8 = null;
        if (value != null) {
            utf8 = value.getBytes(StandardCharsets.UTF_8);
        }
        int length = utf8 == null ? 0 : utf8.length;
        if ((length = this.convertTag(tag, length, value != null)) < 0) {
            return null;
        }
        int pad = KMIPConverter.padLength(length);
        if (this.write) {
            if (this.pointer != null) {
                System.arraycopy(utf8, 0, this.pointer, this.offset, length);
                Arrays.fill(this.pointer, this.offset + length, this.offset + pad, (byte)0);
            }
        } else {
            value = new String(this.pointer, this.offset, length, StandardCharsets.UTF_8);
        }
        this.offset += pad;
        return value;
    }

    public String convert(int tag, String value) throws KMIPConvertException {
        if (this.write && value == null) {
            KMIPConverter.setError("Expected write for tag 0x" + HEX.toString(tag));
        }
        String newValue = this.convertOptional(tag, value);
        if (!this.write && newValue == null) {
            KMIPConverter.setError("Expected read for tag 0x" + HEX.toString(tag));
        }
        return newValue;
    }

    public byte[] convertOptional(int tag, byte[] value) throws KMIPConvertException {
        assert ((byte)tag == 8);
        int length = value == null ? 0 : value.length;
        if ((length = this.convertTag(tag, length, value != null)) < 0) {
            return null;
        }
        int pad = KMIPConverter.padLength(length);
        if (this.write) {
            if (this.pointer != null) {
                System.arraycopy(value, 0, this.pointer, this.offset, length);
                Arrays.fill(this.pointer, this.offset + length, this.offset + pad, (byte)0);
            }
        } else {
            value = new byte[length];
            System.arraycopy(this.pointer, this.offset, value, 0, length);
        }
        this.offset += pad;
        return value;
    }

    public byte[] convert(int tag, byte[] value) throws KMIPConvertException {
        if (this.write && value == null) {
            KMIPConverter.setError("Expected write for tag 0x" + HEX.toString(tag));
        }
        byte[] newValue = this.convertOptional(tag, value);
        if (!this.write && newValue == null) {
            KMIPConverter.setError("Expected read for tag 0x" + HEX.toString(tag));
        }
        return newValue;
    }

    public BigInteger convertOptional(int tag, BigInteger value) throws KMIPConvertException {
        assert ((byte)tag == 4);
        int length = 0;
        if (this.write && value != null) {
            int bits = value.bitLength();
            int num = (bits + 7) / 8;
            length = KMIPConverter.padLength(num + ((bits & 7) == 0 ? 1 : 0));
        }
        if ((length = this.convertTag(tag, length, value != null)) < 0) {
            return null;
        }
        int pad = KMIPConverter.padLength(length);
        if (this.write) {
            if (this.pointer != null) {
                BigNumAttribute.toBin(value, this.pointer, this.offset, pad);
            }
        } else {
            value = BigNumAttribute.fromBin(this.pointer, this.offset, length);
        }
        this.offset += pad;
        return value;
    }

    public BigInteger convert(int tag, BigInteger value) throws KMIPConvertException {
        if (this.write && value == null) {
            KMIPConverter.setError("Expected write for tag 0x" + HEX.toString(tag));
        }
        BigInteger newValue = this.convertOptional(tag, value);
        if (!this.write && newValue == null) {
            KMIPConverter.setError("Expected read for tag 0x" + HEX.toString(tag));
        }
        return newValue;
    }

    public <T extends Enum<T>> T convert(int tag, Enum en, Class<T> enumType) throws KMIPConvertException {
        String eval = en == null ? null : en.toString();
        String enumToString = this.convert(tag, eval);
        if (enumToString != null && !enumToString.isEmpty()) {
            return Enum.valueOf(enumType, enumToString);
        }
        return null;
    }

    int convertBeginOptional(int tag, boolean present) throws KMIPConvertException {
        assert ((byte)tag == 1);
        int length = this.convertTag(tag, 0, present);
        if (length < 0) {
            return -1;
        }
        return this.offset - 8;
    }

    public int convertBegin(int tag) throws KMIPConvertException {
        int result = this.convertBeginOptional(tag, true);
        if (result < 0) {
            KMIPConverter.setError("Expected tag 0x" + HEX.toString(tag));
        }
        return result;
    }

    public void convertEnd(int begin) throws KMIPConvertException {
        if (begin < 0) {
            return;
        }
        if (this.write) {
            int length = this.offset - (begin + 8);
            int pad = KMIPConverter.padLength(length);
            if (this.pointer != null) {
                Converter.setBE4(this.pointer, begin + 4, length);
                Arrays.fill(this.pointer, this.offset, this.offset + pad - length, (byte)0);
            }
            this.offset += pad - length;
        } else {
            int length = Converter.getBE4(this.pointer, begin + 4);
            int pad = KMIPConverter.padLength(length);
            this.offset = begin + 8 + pad;
        }
    }

    public void convertIntList(int tag, List<Integer> list) throws KMIPConvertException {
        if (this.write) {
            for (Integer value : list) {
                this.convert(tag, value);
            }
        } else {
            while (this.getNextTag() == tag) {
                list.add(this.convert(tag, (Integer)null));
            }
        }
    }

    public void convertStrList(int tag, List<String> list) throws KMIPConvertException {
        if (this.write) {
            for (String value : list) {
                this.convert(tag, value);
            }
        } else {
            while (this.getNextTag() == tag) {
                list.add(this.convert(tag, (String)null));
            }
        }
    }

    public void convertBufList(int tag, List<byte[]> list) throws KMIPConvertException {
        if (this.write) {
            for (byte[] value : list) {
                this.convert(tag, value);
            }
        } else {
            while (this.getNextTag() == tag) {
                list.add(this.convert(tag, (byte[])null));
            }
        }
    }

    public boolean isWrite() {
        return this.write;
    }

    public boolean isRead() {
        return !this.isWrite();
    }

    public RequestItem convertRequestItem(RequestItem requestItem) throws KMIPConvertException {
        boolean present = requestItem != null;
        if (present = this.convert(KMIP.Tag.DyPresent, present).booleanValue()) {
            if (this.write) {
                RequestItem.convert(this, requestItem);
            } else {
                requestItem = RequestItem.convert(this, null);
                if (requestItem == null) {
                    throw new KMIPConvertException();
                }
            }
        }
        return requestItem;
    }

    public ResponseItem convertResponseItem(ResponseItem responseItem) throws KMIPConvertException {
        boolean present = responseItem != null;
        if (present = this.convert(KMIP.Tag.DyPresent, present).booleanValue()) {
            if (this.write) {
                ResponseItem.convert(this, responseItem);
            } else {
                responseItem = ResponseItem.convert(this, null);
                if (responseItem == null) {
                    throw new KMIPConvertException();
                }
            }
        }
        return responseItem;
    }

    public static byte[] convert(RequestMessage req) throws KMIPConvertException {
        KMIPConverter converter = new KMIPConverter();
        converter.write = true;
        converter.offset = 0;
        converter.size = 0;
        converter.pointer = null;
        req.convert(converter);
        converter.pointer = new byte[converter.offset];
        converter.offset = 0;
        req.convert(converter);
        return converter.pointer;
    }

    public static byte[] convert(ResponseMessage resp) throws KMIPConvertException {
        KMIPConverter converter = new KMIPConverter();
        converter.write = true;
        converter.offset = 0;
        converter.size = 0;
        converter.pointer = null;
        resp.convert(converter);
        converter.pointer = new byte[converter.offset];
        converter.offset = 0;
        resp.convert(converter);
        return converter.pointer;
    }

    public byte[] convertCustomAttribute(byte[] value) throws KMIPConvertException {
        if (this.write) {
            if (this.pointer != null) {
                System.arraycopy(value, 0, this.pointer, this.offset, value.length);
            }
            this.offset += value.length;
        } else {
            int begin = this.offset;
            int tag = this.getNextTag();
            this.skip(tag);
            int length = this.offset - begin;
            value = new byte[length];
            System.arraycopy(this.pointer, begin, value, 0, length);
        }
        return value;
    }

    public static RequestMessage convertRequestMessage(byte[] in) throws KMIPConvertException {
        KMIPConverter converter = new KMIPConverter();
        converter.write = false;
        converter.pointer = in;
        converter.offset = 0;
        converter.size = in.length;
        RequestMessage req = new RequestMessage();
        req.convert(converter);
        return req;
    }

    public static ResponseMessage convertResponseMessage(byte[] in) throws KMIPConvertException {
        KMIPConverter converter = new KMIPConverter();
        converter.write = false;
        converter.pointer = in;
        converter.offset = 0;
        converter.size = in.length;
        ResponseMessage resp = new ResponseMessage();
        resp.convert(converter);
        return resp;
    }
}

