/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.AlternativeName;
import com.unbound.provider.kmip.attribute.AppInfo;
import com.unbound.provider.kmip.attribute.BigNumAttribute;
import com.unbound.provider.kmip.attribute.BoolAttribute;
import com.unbound.provider.kmip.attribute.BytesAttribute;
import com.unbound.provider.kmip.attribute.CertificateID;
import com.unbound.provider.kmip.attribute.CertificateIssuer;
import com.unbound.provider.kmip.attribute.CertificateSubject;
import com.unbound.provider.kmip.attribute.CryptoDomainParams;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.attribute.DateAttribute;
import com.unbound.provider.kmip.attribute.Digest;
import com.unbound.provider.kmip.attribute.EnumAttribute;
import com.unbound.provider.kmip.attribute.Int64Attribute;
import com.unbound.provider.kmip.attribute.IntAttribute;
import com.unbound.provider.kmip.attribute.KeyValueLocation;
import com.unbound.provider.kmip.attribute.Link;
import com.unbound.provider.kmip.attribute.Name;
import com.unbound.provider.kmip.attribute.RNGParams;
import com.unbound.provider.kmip.attribute.RevocationReason;
import com.unbound.provider.kmip.attribute.TextAttribute;
import com.unbound.provider.kmip.attribute.UsageLimits;
import com.unbound.provider.kmip.attribute.X509CertificateID;
import com.unbound.provider.kmip.attribute.X509CertificateIssuer;
import com.unbound.provider.kmip.attribute.X509CertificateSubject;
import java.util.HashMap;
import java.util.Map;

public abstract class Attribute {
    public int tag = 0;
    public Integer index = null;
    private static final Map<Integer, AttributeDef> tags = new HashMap<Integer, AttributeDef>();
    private static final Map<String, AttributeDef> names = new HashMap<String, AttributeDef>();

    public Attribute() {
    }

    public Attribute(int _tag) {
        this.tag = _tag;
    }

    public String getName() {
        AttributeDef def = tags.get(this.tag);
        if (def == null) {
            return null;
        }
        return def.name;
    }

    private static void register(AttributeDef def) {
        tags.put(def.tag, def);
        names.put(def.name, def);
    }

    public static AttributeDef getDef(int tag) {
        return tags.get(tag);
    }

    public static Attribute create(int tag) {
        AttributeDef def = tags.get(tag);
        if (def == null) {
            return null;
        }
        return def.create();
    }

    public static Attribute create(String name) {
        AttributeDef def = names.get(name);
        if (def == null) {
            return null;
        }
        return def.create();
    }

    public static int nameToTag(String name) {
        AttributeDef def = names.get(name);
        if (def == null) {
            return 0;
        }
        return def.tag;
    }

    public static String tagToName(int tag) {
        AttributeDef def = names.get(tag);
        if (def == null) {
            return "";
        }
        return def.name;
    }

    public static Attribute convert(KMIPConverter converter, Attribute object) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.Attribute);
        if (converter.isWrite()) {
            converter.convert(KMIP.Tag.AttributeName, object.getName());
        } else {
            String name = converter.convert(KMIP.Tag.AttributeName, (String)null);
            object = Attribute.create(name);
            if (object == null) {
                KMIPConverter.setError("Unknown attribute " + name);
            }
        }
        object.index = converter.convertOptional(KMIP.Tag.AttributeIndex, object.index);
        object.convert(converter);
        converter.convertEnd(begin);
        return object;
    }

    public abstract void convert(KMIPConverter var1) throws KMIPConvertException;

    public abstract void log();

    static {
        Attribute.register(new AttributeDefClass(KMIP.Tag.Name, "Name", Name.class));
        Attribute.register(new AttributeDefClass(KMIP.Tag.AlternativeName, "Alternative Name", AlternativeName.class));
        Attribute.register(new AttributeDefText(KMIP.Tag.UniqueIdentifier, "Unique Identifier"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.CryptographicAlgorithm, "Cryptographic Algorithm"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.CryptographicLength, "Cryptographic Length"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.ObjectType, "Object Type"));
        Attribute.register(new AttributeDefClass(KMIP.Tag.CryptographicParameters, "Cryptographic Parameters", CryptoParams.class));
        Attribute.register(new AttributeDefClass(KMIP.Tag.CryptographicDomainParameters, "Cryptographic Domain Parameters", CryptoDomainParams.class));
        Attribute.register(new AttributeDefInt(KMIP.Tag.CertificateLength, "Certificate Length"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.CertificateType, "Certificate Type"));
        Attribute.register(new AttributeDefClass(KMIP.Tag.X509CertificateIdentifier, "X.509 Certificate Identifier", X509CertificateID.class));
        Attribute.register(new AttributeDefClass(KMIP.Tag.X509CertificateSubject, "X.509 Certificate Subject", X509CertificateSubject.class));
        Attribute.register(new AttributeDefClass(KMIP.Tag.X509CertificateIssuer, "X.509 Certificate Issuer", X509CertificateIssuer.class));
        Attribute.register(new AttributeDefClass(KMIP.Tag.CertificateIdentifier, "Certificate Identifier", CertificateID.class));
        Attribute.register(new AttributeDefClass(KMIP.Tag.CertificateSubject, "Certificate Subject", CertificateSubject.class));
        Attribute.register(new AttributeDefClass(KMIP.Tag.CertificateIssuer, "Certificate Issuer", CertificateIssuer.class));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.DigitalSignatureAlgorithm, "Digital Signature Algorithm"));
        Attribute.register(new AttributeDefClass(KMIP.Tag.Digest, "Digest", Digest.class));
        Attribute.register(new AttributeDefText(KMIP.Tag.OperationPolicyName, "Operation Policy Name"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.CryptographicUsageMask, "Cryptographic Usage Mask"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.State, "State"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.InitialDate, "Initial Date"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.ActivationDate, "Activation Date"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.DeactivationDate, "Deactivation Date"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.CompromiseOccurrenceDate, "Compromise Occurrence Date"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.CompromiseDate, "Compromise Date"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.LastChangeDate, "Last Change Date"));
        Attribute.register(new AttributeDefClass(KMIP.Tag.RevocationReason, "Revocation Reason", RevocationReason.class));
        Attribute.register(new AttributeDefText(KMIP.Tag.ObjectGroup, "Object Group"));
        Attribute.register(new AttributeDefClass(KMIP.Tag.ApplicationSpecificInformation, "Application Specific Information", AppInfo.class));
        Attribute.register(new AttributeDefText(KMIP.Tag.ContactInformation, "Contact Information"));
        Attribute.register(new AttributeDefText(KMIP.Tag.CertificateSubjectAlternativeName, "Certificate Subject Alternative Name"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.OriginalCreationDate, "Original Creation Date"));
        Attribute.register(new AttributeDefClass(KMIP.Tag.RNGParameters, "Random Number Generator", RNGParams.class));
        Attribute.register(new AttributeDefDate(KMIP.Tag.ProcessStartDate, "Process Start Date"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.ProtectStopDate, "Protect Stop Date"));
        Attribute.register(new AttributeDefClass(KMIP.Tag.UsageLimits, "Usage Limits", UsageLimits.class));
        Attribute.register(new AttributeDefClass(KMIP.Tag.KeyValueLocation, "Key Value Location", KeyValueLocation.class));
        Attribute.register(new AttributeDefDate(KMIP.Tag.LastChangeDate, "Last Change Date"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.Sensitive, "Sensitive"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.AlwaysSensitive, "AlwaysSensitive"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.Extractable, "Extractable"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.NeverExtractable, "NeverExtractable"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.RecommendedCurve, "RecommendedCurve"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.SecretDataType, "Secret Data Type"));
        Attribute.register(new AttributeDefInt64(KMIP.Tag.DyDYCKA_UID, "x-DYCKA_UID"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyDYCKA_PASS_EC_POINT, "x-DYCKA_PASS_EC_POINT"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyDYCKA_DATA_EC_POINT, "x-DYCKA_DATA_EC_POINT"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyDYCKA_LIMA_PUB_KEY, "x-DYCKA_LIMA_PUB_KEY"));
        Attribute.register(new AttributeDefBigInt(KMIP.Tag.DyDYCKA_ECDSA_ENC_PUB_KEY, "x-DYCKA_ECDSA_ENC_PUB_KEY"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyDYCKA_ERASE_KEY_MATERIAL, "x-DYCKA_ERASE_KEY_MATERIAL"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyDYCKA_EDDSA_PUB_KEY, "x-DYCKA_EDDSA_PUB_KEY"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.CKA_CLASS, "x-CKA_CLASS"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_TOKEN, "x-CKA_TOKEN"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_PRIVATE, "x-CKA_PRIVATE"));
        Attribute.register(new AttributeDefText(KMIP.Tag.CKA_LABEL, "x-CKA_LABEL"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyDoActivate, "x-DY_DO_ACTIVATE"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyKeyOnly, "x-DY_KEY_ONLY"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyTestMode, "x-DY_TEST_MODE"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyTemplate, "x-DY_CLIENT_TEMPLATE"));
        Attribute.register(new AttributeDefText(KMIP.Tag.CKA_APPLICATION, "x-CKA_APPLICATION"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.CKA_VALUE, "x-CKA_VALUE"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.CKA_CERTIFICATE_TYPE, "x-CKA_CERTIFICATE_TYPE"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.CKA_ISSUER, "x-CKA_ISSUER"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.CKA_SERIAL_NUMBER, "x-CKA_SERIAL_NUMBER"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.CKA_CERTIFICATE_CATEGORY, "x-CKA_CERTIFICATE_CATEGORY"));
        Attribute.register(new AttributeDefText(KMIP.Tag.CKA_URL, "x-CKA_URL"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.CKA_OBJECT_ID, "x-CKA_OBJECT_ID"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.CKA_CHECK_VALUE, "x-CKA_CHECK_VALUE"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.CKA_KEY_GEN_MECHANISM, "x-CKA_KEY_GEN_MECHANISM"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.CKA_KEY_TYPE, "x-CKA_KEY_TYPE"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.CKA_SUBJECT, "x-CKA_SUBJECT"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.CKA_ID, "x-CKA_ID"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_SENSITIVE, "x-CKA_SENSITIVE"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_ENCRYPT, "x-CKA_ENCRYPT"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_DECRYPT, "x-CKA_DECRYPT"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_WRAP, "x-CKA_WRAP"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_UNWRAP, "x-CKA_UNWRAP"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_SIGN, "x-CKA_SIGN"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_SIGN_RECOVER, "x-CKA_SIGN_RECOVER"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_VERIFY, "x-CKA_VERIFY"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_VERIFY_RECOVER, "x-CKA_VERIFY_RECOVER"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_DERIVE, "x-CKA_DERIVE"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.CKA_START_DATE, "x-CKA_START_DATE"));
        Attribute.register(new AttributeDefDate(KMIP.Tag.CKA_END_DATE, "x-CKA_END_DATE"));
        Attribute.register(new AttributeDefBigInt(KMIP.Tag.CKA_MODULUS, "x-CKA_MODULUS"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.CKA_MODULUS_BITS, "x-CKA_MODULUS_BITS"));
        Attribute.register(new AttributeDefBigInt(KMIP.Tag.CKA_PUBLIC_EXPONENT, "x-CKA_PUBLIC_EXPONENT"));
        Attribute.register(new AttributeDefBigInt(KMIP.Tag.CKA_COEFFICIENT, "x-CKA_COEFFICIENT"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.CKA_VALUE_LEN, "x-CKA_VALUE_LEN"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_EXTRACTABLE, "x-CKA_EXTRACTABLE"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_LOCAL, "x-CKA_LOCAL"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_NEVER_EXTRACTABLE, "x-CKA_NEVER_EXTRACTABLE"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_ALWAYS_SENSITIVE, "x-CKA_ALWAYS_SENSITIVE"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_MODIFIABLE, "x-CKA_MODIFIABLE"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_ALWAYS_AUTHENTICATE, "x-CKA_ALWAYS_AUTHENTICATE"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.CKA_EC_PARAMS, "x-CKA_EC_PARAMS"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.CKA_EC_POINT, "x-CKA_EC_POINT"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_TRUSTED, "x-CKA_TRUSTED"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.CKA_WRAP_WITH_TRUSTED, "x-CKA_WRAP_WITH_TRUSTED"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DYCKA_ECDSA_BIP_LEVEL, "x-DYCKA_ECDSA_BIP_LEVEL"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DYCKA_ECDSA_BIP_CHILD_NUMBER, "x-DYCKA_ECDSA_BIP_CHILD_NUMBER"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DYCKA_ECDSA_BIP_PARENT_FINGERPRINT, "x-DYCKA_ECDSA_BIP_PARENT_FINGERPRINT"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DYCKA_ECDSA_BIP_CPAR, "x-DYCKA_ECDSA_BIP_CPAR"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DYCKA_ECDSA_BIP_PARENT_UID, "x-DYCKA_ECDSA_BIP_PARENT_UID"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DYCKA_ECDSA_BIP_HARDENED, "x-DYCKA_ECDSA_BIP_HARDENED"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DYCKA_EDDSA_BIP_LEVEL, "x-DYCKA_EDDSA_BIP_LEVEL"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DYCKA_EDDSA_BIP_CHILD_NUMBER, "x-DYCKA_EDDSA_BIP_CHILD_NUMBER"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DYCKA_EDDSA_BIP_CPAR, "x-DYCKA_EDDSA_BIP_CPAR"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DYCKA_EDDSA_BIP_PARENT_UID, "x-DYCKA_EDDSA_BIP_PARENT_UID"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DYCKA_EDDSA_BIP_HARDENED, "x-DYCKA_EDDSA_BIP_HARDENED"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyDYCKA_FIPS, "x-DYCKA_FIPS"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.Key, "Key"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.PublicKey, "Public Key"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.PrivateKey, "Private Key"));
        Attribute.register(new AttributeDefClass(KMIP.Tag.Link, "Link", Link.class));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyChain, "x-DY_CHAIN"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyObjectGroup, "x-DY_OBJECT_GROUP"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyIsPrimaryObject, "x-DY_IS_PRIMARY_OBJECT"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyCreatedUsingDerive, "x-DY_CREATED-USING-DERIVE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyPartitionId, "x-DY_PARTITION_ID"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyPassword, "x-DY_PASSWORD"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.DyAuthType, "x-DY_AUTH_TYPE"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyDetails, "x-DY_DETAILS"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyActivationCode, "x-DY_ACTIVATION_CODE"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyExpiration, "x-DY_ACTIVATION_CODE_EXPIRATION"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyCertificateRequest, "x-DY-CERTIFICATE_REQUEST"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyPfxPassword, "x-DY-PFX-PASSWORD"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyPFX, "x-DY_PFX"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyRole, "x-DY_ROLE"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyBackup, "x-DY_BACKUP"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyIsSync, "x-DY_IS_SYNC"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyCKA_MPC_SIGN_PROTECTED, "x-DYCKA_MPC_SIGN_PROTECTED"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyCKA_INTEGRITY_SIGNATURE, "x-DYCKA_INTEGRITY_SIGNATURE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyClientRegistrainRetries, "x-DY_CLIENT_REGISTRATION_RETRIES"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyClientRegistrationTimeout, "x-DY_CLIENT_REGISTRATION_TIMEOUT"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyUserLoginRetries, "x-DY_USER_LOGIN_RETRIES"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyAllowOnlyCrypto, "x-DY_ALLOW_ONLY_CRYPTO"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyPasswordComplexity, "x-DY_PASSWORD_COMPLEXITY"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyPasswordLength, "x-DY_PASSWORD_LENGTH"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyCheckClientIp, "x-DY_CHECK_IP"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyAllowNat, "x-DY_ALLOW_NAT"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyIpRange, "x-DY_IP_RANGE"));
        Attribute.register(new AttributeDefInt64(KMIP.Tag.DyLastActivity, "x-DY_LAST_ACTIVITY"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DySamlTimeout, "x-DY_SAML_TIMEOUT"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DySamlCertificate, "x-DY_SAML_CERTIFICATE"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyPartitionInheritance, "x-DY_PARTITION_INHERITANCE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyJwtTimeout, "x-DY_JWT_EXPIRATION"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyJwtLimit, "x-DY_JWT_LIMIT"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyCertificatePropagation, "x-DY_CERTIFICATE_PROPAGATION"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyQuorumValue, "x-DY_QUORUM_VALUE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyQuorumTimeout, "x-DY_QUORUM_TIMEOUT"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyEnforceUniqueName, "x-DY_ENFORCE_UNIQUE_NAME"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyEnforceUniqueDescription, "x-DY_ENFORCE_UNIQUE_DESCRIPTION"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyQuorumTimeout, "x-DY_QUORUM_TIMEOUT"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyCheckJwtOriginator, "x-DY_CHECK_JWT_ORIGINATOR"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyRefreshInterval, "x-DY_REFRESH_INTERVAL"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DySyncInterval, "x-DY_SYNC_INTERVAL"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyCheckAllowServers, "x-DY_CHECK_ALLOW_SERVERS"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyAllowNoCertificate, "x-DY_ALLOW_NO_CERTIFICATE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DySeedInterval, "x-DY_SEED_INTERVAL"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyLicense, "x-DY_LICENSE"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyFips, "x-DY_IS_FIPS"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyKeyRotationInterval, "x-DY_KEY_ROTATION_INTERVAL"));
        Attribute.register(new AttributeDefInt64(KMIP.Tag.DyNextKeyRotationTime, "x-DY_NEXT_KEY_ROTATION_TIME"));
        Attribute.register(new AttributeDefEnum(KMIP.Tag.DyPartitionFipsRequirements, "x-DY_FIPS_REQUIREMENTS"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyAllowDefaultClient, "x-DY_ALLOW_DEFAULT_CLIENT"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyOfflineBackupKey, "x-DY_OFFLINE_BACKUP_KEY"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyGetAllCAs, "x-DY_GET_ALL_CAS"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyRootCaCertificateExpiration, "x-DY_ROOT_CA_CERTIFICATE_EXPIRATION"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyServerCertificateExpiration, "x-DY_SERVER_CERTIFICATE_EXPIRATION"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyClientCertificateExpiration, "x-DY_CLIENT_CERTIFICATE_EXPIRATION"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyRootCaCertificatePreExpiry, "x-DY_ROOT_CA_CERTIFICATE_PRE_EXPIRY"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyServerCertificatePreExpiry, "x-DY_SERVER_CERTIFICATE_PRE_EXPIRY"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyClientCertificatePreExpiry, "x-DY_CLIENT_CERTIFICATE_PRE_EXPIRY"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyActivationCodeLength, "x-DY_ACTIVATION_CODE_LENGTH"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyClientSecretExpiration, "x-DY_CLIENT_SECRET_EXPIRATION"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyExportable, "x-DY_EXPORTABLE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyWrapable, "x-DY_WRAPABLE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyWrapableWithTrusted, "x-DY_WRAPABLE_WITH_TRUSTED"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyNonExportable, "x-DY_NON_EXPORTABLE"));
        Attribute.register(new AttributeDefText(KMIP.Tag.xID, "x-ID"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DYCKA_DIGEST_SHA_1, "x-DYCKA_DIGEST_SHA_1"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DYCKA_DIGEST_SHA256, "x-DYCKA_DIGEST_SHA256"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DYCKA_DIGEST_SHA384, "x-DYCKA_DIGEST_SHA384"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DYCKA_DIGEST_SHA512, "x-DYCKA_DIGEST_SHA512"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyLdapProviderUrl, "x-DY_LDAP_PROVIDER_URL"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyLdapBindDn, "x-DY_LDAP_BIND_DN"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyLdapBindDnPwd, "x-DY_LDAP_BIND_DN_PWD"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyLdapCaCert, "x-DY_LDAP_CA_CERTIFICATE"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyLdapSearchFilter, "x-DY_LDAP_SEARCH_FILTER"));
        Attribute.register(new AttributeDefBool(KMIP.Tag.DyLdapDoNotVerifyCert, "x-DY_LDAP_DO_NOT_VERIFY_CERT"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyKeyRotationExecTime, "x-DY_KEY_ROTATION_EXEC_TIME"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyLdapSearchBase, "x-DY_LDAP_SEARCH_BASE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyConnectTimeout, "x-DY_CONNECT_TIMEOUT"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyReadTimeout, "x-DY_READ_TIMEOUT"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyWriteTimeout, "x-DY_WRITE_TIMEOUT"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyKeepAliveIdle, "x-DY_KEEP_ALIVE_IDLE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyKeepAliveInterval, "x-DY_KEEP_ALIVE_INTERVAL"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyKeepAliveCount, "x-DY_KEEP_ALIVE_COUNT"));
        Attribute.register(new AttributeDefBytes(KMIP.Tag.DyJws, "x-DY_JWS"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DySecret, "x-DY_SECRET"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyGrantType, "x-DY_GRANT_TYPE"));
        Attribute.register(new AttributeDefInt(KMIP.Tag.DyClientSecretExpiration, "x-DY_CLIENT_SECRET_EXPIRATION"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DYCKA_OBJECT_GROUPS, "x-DY_OBJECT_GROUPS"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyDseVersion, "x-dse-version"));
        Attribute.register(new AttributeDefText(KMIP.Tag.DyDseKeyNamespace, "x-key-namespace"));
    }

    private static class AttributeDefEnum
    extends AttributeDef {
        AttributeDefEnum(int tag, String name) {
            super(tag, name);
        }

        @Override
        Attribute create() {
            return new EnumAttribute(this.tag);
        }
    }

    private static class AttributeDefBytes
    extends AttributeDef {
        AttributeDefBytes(int tag, String name) {
            super(tag, name);
        }

        @Override
        Attribute create() {
            return new BytesAttribute(this.tag);
        }
    }

    private static class AttributeDefText
    extends AttributeDef {
        AttributeDefText(int tag, String name) {
            super(tag, name);
        }

        @Override
        Attribute create() {
            return new TextAttribute(this.tag);
        }
    }

    private static class AttributeDefBigInt
    extends AttributeDef {
        AttributeDefBigInt(int tag, String name) {
            super(tag, name);
        }

        @Override
        Attribute create() {
            return new BigNumAttribute(this.tag);
        }
    }

    private static class AttributeDefInt64
    extends AttributeDef {
        AttributeDefInt64(int tag, String name) {
            super(tag, name);
        }

        @Override
        Attribute create() {
            return new Int64Attribute(this.tag);
        }
    }

    private static class AttributeDefDate
    extends AttributeDef {
        AttributeDefDate(int tag, String name) {
            super(tag, name);
        }

        @Override
        Attribute create() {
            return new DateAttribute(this.tag);
        }
    }

    private static class AttributeDefBool
    extends AttributeDef {
        AttributeDefBool(int tag, String name) {
            super(tag, name);
        }

        @Override
        Attribute create() {
            return new BoolAttribute(this.tag);
        }
    }

    private static class AttributeDefInt
    extends AttributeDef {
        AttributeDefInt(int tag, String name) {
            super(tag, name);
        }

        @Override
        Attribute create() {
            return new IntAttribute(this.tag);
        }
    }

    private static class AttributeDefClass
    extends AttributeDef {
        Class<? extends Attribute> clazz;

        AttributeDefClass(int tag, String name, Class<? extends Attribute> clazz) {
            super(tag, name);
            this.clazz = clazz;
        }

        @Override
        Attribute create() {
            try {
                return this.clazz.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
    }

    public static class AttributeDef {
        public int tag;
        public String name;

        AttributeDef(int tag, String name) {
            this.tag = tag;
            this.name = name;
        }

        Attribute create() {
            return null;
        }
    }
}

