/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Nonce;

public class Authentication {
    public static Authentication trivialAuth = new Authentication();
    public int credType;
    public String username = null;
    public String password = null;
    public Nonce nonce = new Nonce();
    public int attestationType;
    public byte[] attestationMeasurement = null;
    public byte[] attestationAssertion = null;

    public static boolean isTrivialAuth(Authentication authentication) {
        if (authentication == null) {
            return true;
        }
        return Authentication.trivialAuth.username.equals(authentication.username) && Authentication.trivialAuth.password.equals(authentication.password);
    }

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.Authentication);
        int credBegin = converter.convertBegin(KMIP.Tag.Credential);
        this.credType = converter.convert(KMIP.Tag.CredentialType, this.credType);
        int credValueBegin = converter.convertBegin(KMIP.Tag.CredentialValue);
        if (this.credType == 1) {
            this.username = converter.convert(KMIP.Tag.Username, this.username);
            this.password = converter.convertOptional(KMIP.Tag.Password, this.password);
        } else if (this.credType == 3) {
            this.nonce.convert(converter);
            this.attestationType = converter.convert(KMIP.Tag.AttestationType, this.attestationType);
            this.attestationMeasurement = converter.convertOptional(KMIP.Tag.AttestationMeasurement, this.attestationMeasurement);
            this.attestationAssertion = converter.convertOptional(KMIP.Tag.AttestationAssertion, this.attestationAssertion);
        } else {
            KMIPConverter.setError("Unexpected credential type " + this.credType);
        }
        converter.convertEnd(credValueBegin);
        converter.convertEnd(credBegin);
        converter.convertEnd(begin);
    }

    static {
        Authentication.trivialAuth.credType = 1;
        Authentication.trivialAuth.username = "user";
        Authentication.trivialAuth.password = "";
    }
}

