/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;

public class BytesAttribute
extends Attribute {
    public byte[] value = new byte[0];

    public BytesAttribute(int tag) {
        super(tag);
    }

    public BytesAttribute(int tag, byte[] value) {
        super(tag);
        this.value = value;
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        byte[] v = converter.isWrite() && this.value == null ? new byte[]{} : this.value;
        this.value = converter.convert(KMIP.tagAttributeValue(8), v);
    }

    @Override
    public void log() {
        Log.print("BytesAttribute").log("name", this.getName()).logLen("valueLen", this.value).end();
    }
}

