/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

public class CapabilityInformation {
    Boolean streamingCapability = false;
    Boolean asynchronousCapability = false;
    Boolean attestationCapability = false;
    Boolean batchUndoCapability = false;
    Boolean batchContinueCapability = false;
    Integer unwrapMode = 1;
    Integer destroyAction = 1;
    Integer shreddingAlgorithm = 1;
    Integer RNGMode = 1;

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.CapabilityInformation);
        this.streamingCapability = converter.convertOptional(KMIP.Tag.StreamingCapability, this.streamingCapability);
        this.asynchronousCapability = converter.convertOptional(KMIP.Tag.AsynchronousCapability, this.asynchronousCapability);
        this.attestationCapability = converter.convertOptional(KMIP.Tag.AttestationCapability, this.attestationCapability);
        this.batchUndoCapability = converter.convertOptional(KMIP.Tag.BatchUndoCapability, this.batchUndoCapability);
        this.batchContinueCapability = converter.convertOptional(KMIP.Tag.BatchContinueCapability, this.batchContinueCapability);
        this.unwrapMode = converter.convertOptional(KMIP.Tag.UnwrapMode, this.unwrapMode);
        this.destroyAction = converter.convertOptional(KMIP.Tag.DestroyAction, this.destroyAction);
        this.shreddingAlgorithm = converter.convertOptional(KMIP.Tag.ShreddingAlgorithm, this.shreddingAlgorithm);
        this.RNGMode = converter.convertOptional(KMIP.Tag.RNGMode, this.RNGMode);
        converter.convertEnd(begin);
    }

    public void log() {
        Log.print("CapabilityInformation").log("streamingCapability", this.streamingCapability).log("asynchronousCapability", this.asynchronousCapability).log("attestationCapability", this.attestationCapability).log("batchUndoCapability", this.batchUndoCapability).log("batchContinueCapability", this.batchContinueCapability).log("unwrapMode", this.unwrapMode).log("destroyAction", this.destroyAction).log("shreddingAlgorithm", this.shreddingAlgorithm).log("RNGMode", this.RNGMode).end();
    }
}

