/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;

public class Digest
extends Attribute {
    public int hashingAlg = 0;
    public byte[] value = null;
    public Integer keyFormat = null;

    public Digest() {
        super(KMIP.Tag.Digest);
    }

    public Digest(byte[] value, int hashingAlg, Integer keyFormat) {
        this();
        this.value = value;
        this.hashingAlg = hashingAlg;
        this.keyFormat = keyFormat;
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.tagAttributeValue(1));
        this.hashingAlg = converter.convert(KMIP.Tag.HashingAlgorithm, this.hashingAlg);
        this.value = converter.convertOptional(KMIP.Tag.DigestValue, this.value);
        this.keyFormat = converter.convertOptional(KMIP.Tag.KeyFormatType, this.keyFormat);
        converter.convertEnd(begin);
    }

    @Override
    public void log() {
        Log.print("Digest").log("hashingAlg", this.hashingAlg).log("keyFormat", this.keyFormat).logLen("valueLen", this.value).end();
    }
}

