/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;
import com.unbound.provider.kmip.attribute.KeyWrappingInfo;

public class KeyWrappingData
extends Attribute {
    public int wrappingMethod = 0;
    public KeyWrappingInfo encKey = null;
    public KeyWrappingInfo macKey = null;
    public byte[] mac = null;
    public byte[] iv = null;
    public Integer encodingOption = null;

    public KeyWrappingData() {
        super(KMIP.Tag.KeyWrappingData);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int b;
        int begin = converter.convertBegin(KMIP.Tag.KeyWrappingData);
        this.wrappingMethod = converter.convert(KMIP.Tag.WrappingMethod, this.wrappingMethod);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.EncryptionKeyInformation) {
            this.encKey = new KeyWrappingInfo();
        }
        if (this.encKey != null) {
            b = converter.convertBegin(KMIP.Tag.EncryptionKeyInformation);
            this.encKey.convert(converter);
            converter.convertEnd(b);
        }
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.MacSignatureKeyInformation) {
            this.macKey = new KeyWrappingInfo();
        }
        if (this.macKey != null) {
            b = converter.convertBegin(KMIP.Tag.MacSignatureKeyInformation);
            this.macKey.convert(converter);
            converter.convertEnd(b);
        }
        this.mac = converter.convertOptional(KMIP.Tag.MacSignature, this.mac);
        this.iv = converter.convertOptional(KMIP.Tag.IVCounterNonce, this.iv);
        this.encodingOption = converter.convertOptional(KMIP.Tag.EncodingOption, this.encodingOption);
        converter.convertEnd(begin);
    }

    @Override
    public void log() {
        Log log = Log.func("KeyWrappingData").log("wrappingMethod", this.wrappingMethod).log("encodingOption", this.encodingOption).logLen("macLen", this.mac).logLen("ivLen", this.mac).end();
        if (this.encKey != null) {
            this.encKey.log();
        }
        if (this.macKey != null) {
            this.macKey.log();
        }
        log.leave();
    }
}

