/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.CryptoParams;

public class KeyWrappingInfo {
    public String uid = null;
    public CryptoParams params = null;

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.uid = converter.convert(KMIP.Tag.UniqueIdentifier, this.uid);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CryptographicParameters) {
            this.params = new CryptoParams();
        }
        if (this.params != null) {
            this.params.convertValue(converter);
        }
    }

    public void log() {
        Log log = Log.func("KeyWrappingInfo").log("uid", this.uid).end();
        if (this.params != null) {
            this.params.log();
        }
        log.leave();
    }
}

