/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.KeyWrappingInfo;
import java.util.ArrayList;

public class KeyWrappingSpec {
    public int wrappingMethod = 0;
    public KeyWrappingInfo encKey = null;
    public KeyWrappingInfo macKey = null;
    public ArrayList<String> attrNames = new ArrayList();
    public Integer encodingOption = null;

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int b;
        int begin = converter.convertBegin(KMIP.Tag.KeyWrappingSpecification);
        this.wrappingMethod = converter.convert(KMIP.Tag.WrappingMethod, this.wrappingMethod);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.EncryptionKeyInformation) {
            this.encKey = new KeyWrappingInfo();
        }
        if (this.encKey != null) {
            b = converter.convertBegin(KMIP.Tag.EncryptionKeyInformation);
            this.encKey.convert(converter);
            converter.convertEnd(b);
        }
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.MacSignatureKeyInformation) {
            this.macKey = new KeyWrappingInfo();
        }
        if (this.macKey != null) {
            b = converter.convertBegin(KMIP.Tag.MacSignatureKeyInformation);
            this.macKey.convert(converter);
            converter.convertEnd(b);
        }
        converter.convertStrList(KMIP.Tag.AttributeName, this.attrNames);
        this.encodingOption = converter.convertOptional(KMIP.Tag.EncodingOption, this.encodingOption);
        converter.convertEnd(begin);
    }

    public void log() {
        Log log = Log.func("KeyWrappingSpec").log("wrappingMethod", this.wrappingMethod).log("encodingOption", this.encodingOption).end();
        for (String name : this.attrNames) {
            Log.print("Attribute name").log("name", name).end();
        }
        if (this.encKey != null) {
            this.encKey.log();
        }
        if (this.macKey != null) {
            this.macKey.log();
        }
        log.leave();
    }
}

