/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import java.util.ArrayList;

public class ServerInfo {
    public String version = "2.0";
    public String serverName = "";
    public String clientName = "";
    public String roleName = "";
    public String currentPartition = "";
    public Long lastActivity;
    public ArrayList<String> partitions = new ArrayList();
    public ArrayList<Integer> algs = new ArrayList();
    public ArrayList<Integer> signAlgs = new ArrayList();
    public ArrayList<Integer> hashAlgs = new ArrayList();
    public ArrayList<Integer> blockCipherModes = new ArrayList();
    public ArrayList<Integer> paddings = new ArrayList();

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.ServerInformation);
        converter.convert(KMIP.Tag.DyPartition, this.currentPartition);
        converter.convert(KMIP.Tag.DyClient, this.clientName);
        converter.convert(KMIP.Tag.DyServerName, this.serverName);
        converter.convertStrList(KMIP.Tag.DyPartitionName, this.partitions);
        converter.convertIntList(KMIP.Tag.CryptographicAlgorithm, this.algs);
        converter.convertIntList(KMIP.Tag.DigitalSignatureAlgorithm, this.signAlgs);
        converter.convertIntList(KMIP.Tag.HashingAlgorithm, this.hashAlgs);
        converter.convertIntList(KMIP.Tag.BlockCipherMode, this.blockCipherModes);
        converter.convertIntList(KMIP.Tag.PaddingMethod, this.paddings);
        converter.convertOptional(KMIP.Tag.DyVersion, this.version);
        converter.convertOptional(KMIP.Tag.DyLastActivity, this.lastActivity);
        converter.convertOptional(KMIP.Tag.DyRole, this.roleName);
        converter.convertEnd(begin);
    }

    public void log() {
        Log log = Log.func("ServerInfo").log("version", this.version).log("serverName", this.serverName).log("clientName", this.clientName).log("currentPartition", this.currentPartition).log("lastActivity", this.lastActivity).end();
        if (this.partitions != null) {
            for (String partition : this.partitions) {
                Log.print("Partition").log("name", partition).end();
            }
        }
        if (this.algs != null) {
            for (Integer alg : this.algs) {
                Log.print("Algorithm").log("code", alg).end();
            }
        }
        if (this.signAlgs != null) {
            for (Integer alg : this.signAlgs) {
                Log.print("Sign algorithm").log("code", alg).end();
            }
        }
        if (this.hashAlgs != null) {
            for (Integer alg : this.hashAlgs) {
                Log.print("Hash algorithm").log("code", alg).end();
            }
        }
        if (this.blockCipherModes != null) {
            for (Integer mode : this.blockCipherModes) {
                Log.print("Mode").log("code", mode).end();
            }
        }
        if (this.paddings != null) {
            for (Integer padding : this.paddings) {
                Log.print("Padding").log("code", padding).end();
            }
        }
        log.leave();
    }
}

