/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attributes;
import com.unbound.provider.kmip.attribute.Name;

public class TemplateAttribute {
    public int tag = KMIP.Tag.TemplateAttribute;
    public Name name = null;
    public Attributes attrs = new Attributes();

    public TemplateAttribute() {
    }

    public TemplateAttribute(int _tag) {
        this.tag = _tag;
    }

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        if (converter.isRead()) {
            this.tag = converter.getNextTag();
            if (this.tag == 0) {
                KMIPConverter.setError("Template conversion error");
            }
        }
        int begin = converter.convertBegin(this.tag);
        if (converter.isRead() && converter.getNextTag() == KMIP.Tag.Name) {
            this.name = new Name();
        }
        if (this.name != null) {
            this.name.convertValue(converter);
        }
        this.attrs.convert(converter);
        converter.convertEnd(begin);
    }

    public void log() {
        Log log = Log.func("TemplateAttribute").log("tag", this.tag).end();
        if (this.name != null) {
            this.name.log();
        }
        this.attrs.log();
        log.leave();
    }
}

