/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;

public class X509CertificateID
extends Attribute {
    public byte[] issuer = null;
    public byte[] serialNumber = null;

    public X509CertificateID() {
        super(KMIP.Tag.X509CertificateIdentifier);
    }

    public X509CertificateID(byte[] issuer, byte[] serialNumber) {
        this();
        this.issuer = issuer;
        this.serialNumber = serialNumber;
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.tagAttributeValue(1));
        this.issuer = converter.convert(KMIP.Tag.IssuerDistinguishedName, this.issuer);
        this.serialNumber = converter.convert(KMIP.Tag.CertificateSerialNumber, this.serialNumber);
        converter.convertEnd(begin);
    }

    @Override
    public void log() {
        Log.print("X509CertificateID").logLen("issuerLen", this.issuer).logLen("serialNumberLen", this.serialNumber).end();
    }
}

